/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMapData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import main.AsyncDelayedScheduler;
import main.ColorMapCache;
import main.ConfigPortReader;
import main.LiveFrameProvider;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import sun.misc.Unsafe;

public class CineFrame {
    private final JavaPlugin plugin;
    private final File ffmpegBinary;
    private final ColorMapCache.PaletteLUT RGB_TO_MAP;
    private final Object2ObjectOpenHashMap<String, MediaDisplay> displays = new Object2ObjectOpenHashMap();
    private final AsyncDelayedScheduler asyncScheduler;
    private final PlayerManager playerManager = PacketEvents.getAPI().getPlayerManager();

    public CineFrame(JavaPlugin plugin, File ffmpegBinary, AsyncDelayedScheduler asyncScheduler) {
        this.plugin = plugin;
        this.ffmpegBinary = ffmpegBinary;
        this.RGB_TO_MAP = ColorMapCache.get(plugin);
        this.asyncScheduler = asyncScheduler;
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.displays.keySet());
    }

    public boolean pause(String id) {
        MediaDisplay d = (MediaDisplay)this.displays.get((Object)id);
        if (d == null) {
            return false;
        }
        d.requestPause();
        return true;
    }

    public boolean resume(String id) {
        MediaDisplay d = (MediaDisplay)this.displays.get((Object)id);
        if (d == null) {
            return false;
        }
        if (d.live.getPackManager().isBuilding()) {
            this.plugin.getLogger().warning("Cannot resume while pack is rebuilding");
            return false;
        }
        d.requestPlay();
        return true;
    }

    public boolean remove(String id) {
        MediaDisplay d = (MediaDisplay)this.displays.remove((Object)id);
        if (d != null) {
            d.stop();
            return true;
        }
        return false;
    }

    public void play(File video, Location origin, String id, int tilesX, int tilesY, BlockFace facing, int dx, int dy, int dz) {
        this.asyncScheduler.scheduleWithDelay(() -> {
            try {
                int w = tilesX * 128;
                int h = tilesY * 128;
                LiveFrameProvider live = new LiveFrameProvider(this.plugin, this.ffmpegBinary, video, w, h, 20, ConfigPortReader.getDatapackPort(this.plugin));
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    MediaDisplay d = new MediaDisplay(origin, tilesX, tilesY, facing, dx, dy, dz, w, live);
                    this.displays.put((Object)id, (Object)d);
                    d.start();
                });
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Video start failed: " + ex.getMessage());
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    private class MediaDisplay {
        private static final int TILE_PIXELS = 16384;
        private static final double FPS = 20.0;
        private static final String AUDIO_KEY = "media.video";
        private static final int TILE_POOL_SIZE = 510;
        private static final Unsafe UNSAFE;
        private static final long BYTE_ARR_BASE_OFFSET;
        private final Location origin;
        private final int tilesX;
        private final int tilesY;
        private final BlockFace facing;
        private final int dx;
        private final int dy;
        private final int dz;
        private final int widthPx;
        private final LiveFrameProvider live;
        private final ObjectArrayList<ItemFrame> frames = new ObjectArrayList();
        private final WrapperPlayServerMapData[] wrappers;
        private final IntArrayList mapIds = new IntArrayList();
        private final byte[][] currTiles;
        private final byte[][] prevTiles;
        private final ArrayBlockingQueue<byte[]> tilePool = new ArrayBlockingQueue(510);
        private volatile State state = State.PAUSED;
        private volatile boolean wantPause = false;
        private volatile boolean startRequested = false;
        private long segmentStartNs = 0L;
        private long framesBase = 0L;
        private long framesSent = 0L;
        private boolean posterSent = false;

        MediaDisplay(Location origin, int tilesX, int tilesY, BlockFace facing, int dx, int dy, int dz, int widthPx, LiveFrameProvider live) {
            this.origin = origin;
            this.tilesX = tilesX;
            this.tilesY = tilesY;
            this.facing = facing;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.widthPx = widthPx;
            this.live = live;
            this.wrappers = new WrapperPlayServerMapData[tilesX * tilesY];
            this.prevTiles = new byte[tilesX * tilesY][16384];
            this.currTiles = new byte[tilesX * tilesY][16384];
            for (int i = 0; i < 510; ++i) {
                this.tilePool.offer(new byte[16384]);
            }
        }

        void requestPause() {
            if (this.state == State.PLAYING) {
                this.wantPause = true;
            }
        }

        void requestPlay() {
            if (this.live.getPackManager().isBuilding()) {
                return;
            }
            if (this.state == State.PAUSED) {
                this.startRequested = true;
            }
        }

        void start() {
            World world = this.origin.getWorld();
            if (world == null) {
                return;
            }
            this.spawnFrames(world);
            this.startTicker();
        }

        void stop() {
            this.state = State.FINISHED;
            this.stopAudio();
            try {
                this.live.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Bukkit.getScheduler().runTask((Plugin)CineFrame.this.plugin, () -> {
                int n = this.frames.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        ((ItemFrame)this.frames.get(i)).remove();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        private void stopAudio() {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.stopSound(AUDIO_KEY, SoundCategory.MASTER);
            }
        }

        private int getTileIndex(int r, int c) {
            return r * this.tilesX + c;
        }

        private Location getFrameLocation(World world, int r, int c) {
            double x = this.origin.getBlockX();
            double y = this.origin.getBlockY();
            double z = this.origin.getBlockZ();
            double ox = 0.5;
            double oy = 0.5;
            double oz = 0.5;
            switch (this.facing) {
                case NORTH: {
                    x += (double)(c * this.dx);
                    y += (double)(r * this.dy);
                    z += (double)this.dz;
                    break;
                }
                case SOUTH: {
                    x += (double)((this.tilesX - 1 - c) * this.dx);
                    y += (double)(r * this.dy);
                    z += (double)this.dz;
                    break;
                }
                case EAST: {
                    x += (double)this.dx;
                    y += (double)(r * this.dy);
                    z += (double)(c * this.dz);
                    break;
                }
                case WEST: {
                    x += (double)this.dx;
                    y += (double)(r * this.dy);
                    z += (double)((this.tilesX - 1 - c) * this.dz);
                    break;
                }
                case UP: {
                    x += (double)(c * this.dx);
                    y += (double)this.dy;
                    z += (double)(r * this.dz);
                    break;
                }
                case DOWN: {
                    x += (double)(c * this.dx);
                    y += (double)this.dy;
                    z += (double)((this.tilesY - 1 - r) * this.dz);
                    break;
                }
                default: {
                    x += (double)(c * this.dx);
                    y += (double)(r * this.dy);
                    z += (double)this.dz;
                }
            }
            return new Vector(x + ox, y + oy, z + oz).add(this.facing.getDirection()).toLocation(world);
        }

        private void spawnFrames(World world) {
            for (int r = 0; r < this.tilesY; ++r) {
                for (int c = 0; c < this.tilesX; ++c) {
                    Location loc = this.getFrameLocation(world, r, c);
                    ItemFrame frame = (ItemFrame)world.spawn(loc, ItemFrame.class, fr -> fr.setFacingDirection(this.facing, true));
                    this.frames.add((Object)frame);
                    MapView mv = Bukkit.createMap((World)world);
                    mv.getRenderers().clear();
                    this.mapIds.add(mv.getId());
                    ItemStack mapItem = new ItemStack(Material.FILLED_MAP);
                    MapMeta meta = (MapMeta)mapItem.getItemMeta();
                    meta.setMapView(mv);
                    mapItem.setItemMeta((ItemMeta)meta);
                    frame.setItem(mapItem);
                    int idx = this.getTileIndex(r, c);
                    this.wrappers[idx] = new WrapperPlayServerMapData(mv.getId(), 0, false, false, Collections.emptyList(), 128, 128, 0, 0, new byte[16384]);
                }
            }
        }

        private void startTicker() {
            CineFrame.this.asyncScheduler.scheduleAtFixedRate(() -> {
                if (this.state == State.FINISHED) {
                    return;
                }
                if (this.state == State.PAUSED && this.startRequested) {
                    this.startRequested = false;
                    this.segmentStartNs = System.nanoTime();
                    this.framesBase = this.framesSent;
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.playSound((Entity)p, AUDIO_KEY, SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                    this.state = State.PLAYING;
                    this.posterSent = false;
                }
                if (this.state == State.PAUSED && !this.posterSent) {
                    try {
                        BufferedImage peek = this.live.readNextFrame();
                        if (peek != null) {
                            this.sendFrame(peek);
                            this.posterSent = true;
                        }
                    }
                    catch (Exception peek) {
                        // empty catch block
                    }
                    return;
                }
                if (this.state != State.PLAYING) {
                    return;
                }
                double elapsed = (double)(System.nanoTime() - this.segmentStartNs) / 1.0E9;
                long shouldFrame = this.framesBase + (long)Math.floor(elapsed * 20.0);
                try {
                    while (this.framesSent < shouldFrame) {
                        BufferedImage img = this.live.readNextFrame();
                        if (img == null) continue;
                        if (this.framesSent == shouldFrame - 1L) {
                            this.sendFrame(img);
                        }
                        ++this.framesSent;
                    }
                }
                catch (Exception img) {
                    // empty catch block
                }
                if (this.wantPause) {
                    this.wantPause = false;
                    this.state = State.PAUSED;
                    this.stopAudio();
                    double playedSec = (double)this.framesSent / 20.0;
                    this.live.getPackManager().rebuildTrimmedPack(playedSec);
                    this.posterSent = false;
                }
            }, 0L, 50L, TimeUnit.MILLISECONDS);
        }

        private void sendFrame(BufferedImage img) {
            this.paletteAndTileInPlace(img);
            this.sendMaps();
        }

        private void paletteAndTileInPlace(BufferedImage img) {
            if (img.getType() != 1) {
                BufferedImage rgbImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                Graphics2D g = rgbImg.createGraphics();
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                img = rgbImg;
            }
            int[] rgbArr = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            for (int r = 0; r < this.tilesY; ++r) {
                int rowBase = r * 128 * this.widthPx;
                for (int c = 0; c < this.tilesX; ++c) {
                    int srcCol = this.facing == BlockFace.SOUTH || this.facing == BlockFace.EAST ? this.tilesX - 1 - c : c;
                    int idx = this.getTileIndex(r, c);
                    byte[] tile = this.currTiles[idx];
                    byte[] pooled = this.tilePool.poll();
                    if (pooled != null) {
                        this.currTiles[idx] = pooled;
                        this.tilePool.offer(tile);
                        tile = pooled;
                    }
                    int srcBase = rowBase + srcCol * 128;
                    for (int y = 0; y < 128; ++y) {
                        int offset = srcBase + y * this.widthPx;
                        int tileRow = y * 128;
                        for (int x = 0; x < 128; ++x) {
                            int argb = rgbArr[offset + x];
                            tile[tileRow + x] = CineFrame.this.RGB_TO_MAP.get(argb & 0xFFFFFF);
                        }
                    }
                }
            }
        }

        private void sendMaps() {
            ObjectArrayList playerList = new ObjectArrayList(Bukkit.getOnlinePlayers());
            int changedCount = 0;
            WrapperPlayServerMapData[] changedPackets = new WrapperPlayServerMapData[this.wrappers.length];
            for (int i = 0; i < this.wrappers.length; ++i) {
                byte[] prev = this.prevTiles[i];
                byte[] curr = this.currTiles[i];
                if (Arrays.equals(prev, curr)) continue;
                UNSAFE.copyMemory(curr, BYTE_ARR_BASE_OFFSET, prev, BYTE_ARR_BASE_OFFSET, 16384L);
                WrapperPlayServerMapData pkt = this.wrappers[i];
                pkt.setData(curr);
                changedPackets[changedCount++] = pkt;
            }
            if (changedCount == 0) {
                return;
            }
            int finalChangedCount = changedCount;
            WrapperPlayServerMapData[] finalChangedPackets = new WrapperPlayServerMapData[finalChangedCount];
            System.arraycopy(changedPackets, 0, finalChangedPackets, 0, finalChangedCount);
            int pn = playerList.size();
            for (int pIdx = 0; pIdx < pn; ++pIdx) {
                Player player = (Player)playerList.get(pIdx);
                for (int i = 0; i < finalChangedCount; ++i) {
                    CineFrame.this.playerManager.sendPacket((Object)player, (PacketWrapper)finalChangedPackets[i]);
                }
            }
        }

        static {
            long arrOffset;
            Unsafe tmpUnsafe;
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                tmpUnsafe = (Unsafe)f.get(null);
                arrOffset = tmpUnsafe.arrayBaseOffset(byte[].class);
            }
            catch (Exception e) {
                throw new RuntimeException("Unsafe not available", e);
            }
            UNSAFE = tmpUnsafe;
            BYTE_ARR_BASE_OFFSET = arrOffset;
        }

        private static enum State {
            PAUSED,
            PLAYING,
            FINISHED;

        }
    }
}

