/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.IntStream;
import org.bukkit.map.MapPalette;
import org.bukkit.plugin.java.JavaPlugin;

public final class ColorMapCache {
    private static final String FILE_NAME = "rgb_to_map.bin";
    private static final String DOWNLOAD_URL = "https://www.davids-repo.dev/cdn/rgb_to_map.bin";
    private static final int SIZE = 0x1000000;
    private static PaletteLUT table;

    private ColorMapCache() {
    }

    public static synchronized PaletteLUT get(JavaPlugin plugin) {
        File cacheFile;
        if (table != null) {
            return table;
        }
        File dir = plugin.getDataFolder();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(cacheFile = new File(dir, FILE_NAME)).isFile() || cacheFile.length() != 0x1000000L) {
            plugin.getLogger().info("Trying to download map color cache...");
            boolean downloaded = ColorMapCache.downloadCache(cacheFile, plugin);
            if (!downloaded) {
                plugin.getLogger().warning("Failed to download cache. Building locally...");
            }
        }
        if (cacheFile.isFile() && cacheFile.length() == 0x1000000L) {
            PaletteLUT paletteLUT;
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
            try {
                byte[] lut = new byte[0x1000000];
                in.readFully(lut);
                plugin.getLogger().info("Loaded map color cache from file.");
                paletteLUT = table = new PaletteLUT(lut);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    plugin.getLogger().warning("Failed to load color cache: " + e.getMessage());
                }
            }
            in.close();
            return paletteLUT;
        }
        plugin.getLogger().info("Building map color cache, please wait...");
        byte[] lut = ColorMapCache.buildTable();
        ColorMapCache.saveTable(cacheFile, lut, plugin);
        plugin.getLogger().info("Map color cache ready");
        table = new PaletteLUT(lut);
        return table;
    }

    private static byte[] buildTable() {
        byte[] lut = new byte[0x1000000];
        ((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> IntStream.range(0, 256).parallel().forEach(r -> {
            for (int g = 0; g < 256; ++g) {
                for (int b = 0; b < 256; ++b) {
                    int rgb = r << 16 | g << 8 | b;
                    lut[rgb] = MapPalette.matchColor((int)r, (int)g, (int)b);
                }
            }
        }))).join();
        return lut;
    }

    private static void saveTable(File cacheFile, byte[] lut, JavaPlugin plugin) {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cacheFile)));){
            out.write(lut);
        }
        catch (IOException e) {
            plugin.getLogger().warning("Could not save color cache: " + e.getMessage());
        }
    }

    private static boolean downloadCache(File cacheFile, JavaPlugin plugin) {
        try {
            URI uri = URI.create(DOWNLOAD_URL);
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setInstanceFollowRedirects(true);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                plugin.getLogger().warning("Failed to download color cache: HTTP response " + responseCode);
                return false;
            }
            try (InputStream inputStream = connection.getInputStream();){
                Files.copy(inputStream, cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            plugin.getLogger().info("Downloaded map color cache from CDN.");
            return true;
        }
        catch (Exception e) {
            plugin.getLogger().warning("Download error: " + e.getMessage());
            return false;
        }
    }

    public static class PaletteLUT {
        private final byte[] lut;

        public PaletteLUT(byte[] lut) {
            this.lut = lut;
        }

        public byte get(int rgb) {
            return this.lut[rgb & 0xFFFFFF];
        }
    }
}

