/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import main.CineFrame;
import main.MediaSelectionListener;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisplayCommand
implements CommandExecutor,
TabCompleter {
    private final CineFrame cineFrame;
    private final File mediaDir;

    public DisplayCommand(CineFrame cineFrame, File mediaDir) {
        this.cineFrame = cineFrame;
        this.mediaDir = mediaDir;
    }

    private String combineArgs(String[] args) {
        return String.join((CharSequence)" ", args).trim().replaceAll("\\s{2,}", " ");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String name = cmd.getName().toLowerCase();
        if (name.equals("media")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use /media.");
                return true;
            }
            Player player = (Player)sender;
            this.handleMedia(player, args);
            return true;
        }
        switch (name) {
            case "delmedia": {
                this.handleRemove(sender, args);
                break;
            }
            case "play": {
                this.handlePlay(sender, args);
                break;
            }
            case "pause": {
                this.handlePause(sender, args);
            }
        }
        return true;
    }

    private boolean handlePlay(CommandSender sender, String[] args) {
        String id = this.chooseDisplay(sender, args);
        if (id == null) {
            return true;
        }
        boolean ok = this.cineFrame.resume(id);
        this.sendMsg(sender, ok ? "Playing " + id : "Could not play " + id);
        return true;
    }

    private boolean handlePause(CommandSender sender, String[] args) {
        String id = this.chooseDisplay(sender, args);
        if (id == null) {
            return true;
        }
        boolean ok = this.cineFrame.pause(id);
        this.sendMsg(sender, ok ? "Paused " + id : "Could not pause " + id);
        return true;
    }

    private String chooseDisplay(CommandSender sender, String[] args) {
        String id = this.combineArgs(args);
        if (!id.isEmpty()) {
            return id;
        }
        Set<String> ids = this.cineFrame.getIds();
        if (ids.isEmpty()) {
            this.sendMsg(sender, "No active displays");
            return null;
        }
        if (ids.size() == 1) {
            return ids.iterator().next();
        }
        this.sendMsg(sender, "Pick one id: " + String.valueOf(ids));
        return null;
    }

    private void handleMedia(Player player, String[] args) {
        String fileName = this.combineArgs(args);
        if (fileName.isEmpty()) {
            player.sendMessage("Usage: /media <filename>");
            return;
        }
        File[] mediaFiles = this.mediaDir.listFiles((dir, fname) -> fname.toLowerCase().matches(".*\\.(mp4|mov|webm|mkv|avi)$"));
        if (mediaFiles == null || mediaFiles.length == 0) {
            player.sendMessage("No media files found in " + this.mediaDir.getName() + "/");
            return;
        }
        File chosen = null;
        for (File f : mediaFiles) {
            if (!f.getName().equalsIgnoreCase(fileName)) continue;
            chosen = f;
            break;
        }
        if (chosen == null || !chosen.exists()) {
            player.sendMessage("File not found in " + this.mediaDir.getName() + ": " + fileName);
            return;
        }
        MediaSelectionListener.startSelection(player.getUniqueId(), chosen, this.mediaDir, this.cineFrame);
        player.sendMessage("First corner: left-click a block");
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleRemove(CommandSender sender, String[] args) {
        if (args.length < 1) {
            this.sendMsg(sender, "Usage: /delmedia <id>  |  <x> <y> <z>");
            return true;
        }
        id = null;
        if (args.length != 3 || !(sender instanceof Player)) ** GOTO lbl-1000
        p = (Player)sender;
        if (args[0].matches("-?\\d+") && args[1].matches("-?\\d+") && args[2].matches("-?\\d+")) {
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
                key = p.getWorld().getName() + "," + x + "," + y + "," + z;
                for (String sid : this.cineFrame.getIds()) {
                    if (!sid.endsWith("@" + key)) continue;
                    id = sid;
                }
            }
            catch (NumberFormatException ex) {
                this.sendMsg(sender, "Bad coordinates");
                return true;
            }
        } else lbl-1000:
        // 2 sources

        {
            id = this.combineArgs(args);
        }
        if (id == null || id.isEmpty()) {
            this.sendMsg(sender, "No display found to remove");
            return true;
        }
        ok = this.cineFrame.remove(id);
        if (ok) {
            this.cleanupMediaWork();
        }
        this.sendMsg(sender, ok != false ? "Removed display: " + id : "Failed to remove display: " + id);
        return true;
    }

    private void cleanupMediaWork() {
        Path workDir = this.mediaDir.getParentFile().toPath().resolve("media_work");
        if (Files.exists(workDir, new LinkOption[0])) {
            try {
                Files.walk(workDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendMsg(CommandSender sender, String msg) {
        sender.sendMessage(msg);
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] args) {
        if (alias.equalsIgnoreCase("media")) {
            File[] files = this.mediaDir.listFiles((dir, fname) -> fname.toLowerCase().matches(".*\\.(mp4|mov|webm|mkv|avi)$"));
            if (files == null) {
                return List.of();
            }
            String prefix = args.length > 0 ? this.combineArgs(args) : "";
            return Arrays.stream(files).map(File::getName).filter(n -> n.toLowerCase().startsWith(prefix.toLowerCase())).toList();
        }
        if (alias.equalsIgnoreCase("delmedia") || alias.equalsIgnoreCase("play") || alias.equalsIgnoreCase("pause")) {
            String prefix = args.length > 0 ? this.combineArgs(args) : "";
            return this.cineFrame.getIds().stream().filter(sid -> sid.toLowerCase().startsWith(prefix.toLowerCase())).toList();
        }
        return List.of();
    }
}

