/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.plugin.java.JavaPlugin;

public class FFmpegBootstrap {
    public static File download(JavaPlugin plugin) throws IOException {
        File outputFile;
        String os = System.getProperty("os.name").toLowerCase();
        if (!os.contains("win")) {
            throw new UnsupportedOperationException("Unsupported OS for FFmpeg: " + os);
        }
        String downloadUrl = "https://www.davids-repo.dev/cdn/ffmpeg.zip";
        String exeName = "ffmpeg-temp.exe";
        File dataFolder = plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if ((outputFile = new File(dataFolder, exeName)).exists()) {
            outputFile.setExecutable(true);
            return outputFile;
        }
        File zipFile = new File(dataFolder, "ffmpeg-temp.zip");
        URI uri = URI.create(downloadUrl);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setInstanceFollowRedirects(true);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Failed to download file: HTTP response code " + responseCode);
        }
        try (InputStream inputStream = connection.getInputStream();){
            Files.copy(inputStream, zipFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".exe")) continue;
                Files.copy(zis, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                outputFile.setExecutable(true);
                break;
            }
        }
        zipFile.delete();
        if (!outputFile.exists()) {
            throw new IOException("FFmpeg executable not found in ZIP archive.");
        }
        return outputFile;
    }
}

