/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.MediaResourcePackManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.libjpegturbo.turbojpeg.TJDecompressor;

public class LiveFrameProvider
implements Closeable {
    private Process ffmpegProc;
    private PushbackInputStream ffmpegOut;
    private final ByteArrayList frameBuf = new ByteArrayList(24000000);
    private final byte[] ioBuf = new byte[524288];
    private static final byte[] JPEG_SOI;
    private static final byte[] JPEG_EOI;
    private static final String SCALE_FLAGS = "fast_bilinear";
    private static final int SCALE = 5;
    private final MediaResourcePackManager packManager;
    private final byte[] probeBuf = new byte[2];

    public LiveFrameProvider(JavaPlugin plugin, File ffmpeg, File videoFile, int width, int height, int fps, int webPort) throws Exception {
        this.packManager = new MediaResourcePackManager(plugin, ffmpeg, webPort);
        this.packManager.extractWholeAudio(videoFile);
        this.startFrameProcess(ffmpeg, videoFile, width, height, fps, SCALE_FLAGS, 5);
    }

    public MediaResourcePackManager getPackManager() {
        return this.packManager;
    }

    public BufferedImage readNextFrame() throws IOException {
        while (true) {
            BufferedImage img = null;
            try {
                img = this.readOneFrameInternal();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (img != null) {
                return img;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private BufferedImage readOneFrameInternal() throws IOException {
        int b;
        this.frameBuf.size(0);
        PushbackInputStream in = this.ffmpegOut;
        while ((b = in.read()) != -1) {
            if (b != 255) continue;
            int b2 = in.read();
            if (b2 == -1) {
                return null;
            }
            if (b2 != 216) continue;
            this.frameBuf.add((byte)-1);
            this.frameBuf.add((byte)-40);
            break;
        }
        if (b == -1) {
            return null;
        }
        boolean prevFF = false;
        int n;
        block1: while ((n = in.read(this.ioBuf)) != -1) {
            int i = 0;
            while (true) {
                if (i >= n) continue block1;
                byte v = this.ioBuf[i];
                this.frameBuf.add(v);
                if (prevFF && v == JPEG_EOI[1]) {
                    int remain = n - i - 1;
                    if (remain > 0) {
                        in.unread(this.ioBuf, i + 1, remain);
                    }
                    return this.decodeJPEGFast(this.frameBuf.elements(), this.frameBuf.size());
                }
                prevFF = v == -1;
                ++i;
            }
            break;
        }
        return null;
    }

    private BufferedImage decodeJPEGFast(byte[] data, int length) throws IOException {
        TJDecompressor tj = null;
        try {
            tj = new TJDecompressor(data, length);
            BufferedImage bufferedImage = tj.decompress(0, 0, 5, 2048);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IOException("JPEG decode failed", e);
        }
        finally {
            if (tj != null) {
                try {
                    tj.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void startFrameProcess(File ffmpeg, File videoFile, int width, int height, int fps, String scaleFlags, int jpegQScale) throws IOException {
        jpegQScale = Math.max(2, Math.min(31, jpegQScale));
        String[] baseCmd = this.buildBaseCommand(ffmpeg, videoFile, width, height, fps, scaleFlags, jpegQScale);
        List<String> hwaccels = this.getAvailableHwAccels(ffmpeg);
        String[] cmd = new String[baseCmd.length + 2];
        cmd[0] = ffmpeg.getAbsolutePath();
        cmd[1] = "-hwaccel";
        System.arraycopy(baseCmd, 1, cmd, 3, baseCmd.length - 1);
        Iterator<String> iterator = hwaccels.iterator();
        while (iterator.hasNext()) {
            String hw;
            cmd[2] = hw = iterator.next();
            try {
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(false);
                Process testProc = pb.start();
                InputStream testOut = testProc.getInputStream();
                long deadline = System.currentTimeMillis() + 1700L;
                while (System.currentTimeMillis() < deadline) {
                    if (testOut.available() >= 2 && testOut.read(this.probeBuf) == 2 && this.probeBuf[0] == JPEG_SOI[0] && this.probeBuf[1] == JPEG_SOI[1]) {
                        this.ffmpegProc = testProc;
                        this.ffmpegOut = new PushbackInputStream(testOut, this.ioBuf.length);
                        this.startErrorLogger(this.ffmpegProc);
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                testProc.destroyForcibly();
            }
            catch (IOException iOException) {}
        }
        ProcessBuilder pb = new ProcessBuilder(baseCmd);
        pb.redirectErrorStream(false);
        this.ffmpegProc = pb.start();
        this.ffmpegOut = new PushbackInputStream(this.ffmpegProc.getInputStream(), this.ioBuf.length);
        this.startErrorLogger(this.ffmpegProc);
    }

    private String[] buildBaseCommand(File ffmpeg, File videoFile, int width, int height, int fps, String scaleFlags, int jpegQScale) {
        return new String[]{ffmpeg.getAbsolutePath(), "-re", "-threads", "0", "-loglevel", "error", "-nostdin", "-i", videoFile.getAbsolutePath(), "-vf", "fps=" + fps + ",scale=" + width + ":" + height + ":flags=" + scaleFlags, "-f", "image2pipe", "-vcodec", "mjpeg", "-q:v", String.valueOf(jpegQScale), "-"};
    }

    private List<String> getAvailableHwAccels(File ffmpeg) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(ffmpeg.getAbsolutePath(), "-hide_banner", "-hwaccels");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean start = false;
            while ((line = r.readLine()) != null) {
                if (start) {
                    list.add(line.trim());
                }
                if (!line.trim().equalsIgnoreCase("Hardware acceleration methods:")) continue;
                start = true;
            }
            p.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Override
    public void close() {
        if (this.ffmpegProc != null) {
            this.ffmpegProc.destroyForcibly();
        }
        try {
            if (this.ffmpegOut != null) {
                this.ffmpegOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.packManager.sendToAll();
    }

    private void startErrorLogger(Process proc) {
        Thread t = new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                char[] buf = new char[512];
                while (r.read(buf, 0, buf.length) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "FFmpegErrorLogger");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    static {
        try {
            String lib;
            String dir;
            String bit;
            String os = System.getProperty("os.name").toLowerCase();
            String string = bit = System.getProperty("os.arch").contains("64") ? "64" : "32";
            if (os.contains("win")) {
                dir = "windows_" + bit + "/";
                lib = "turbojpeg.dll";
            } else if (os.contains("mac")) {
                dir = "osx_" + bit + "/";
                lib = "libturbojpeg.dylib";
            } else {
                dir = "linux_" + bit + "/";
                lib = "libturbojpeg.so";
            }
            String res = "/META-INF/lib/" + dir + lib;
            try (InputStream in = LiveFrameProvider.class.getResourceAsStream(res);){
                if (in == null) {
                    throw new UnsatisfiedLinkError("native lib not found: " + res);
                }
                File tmp = File.createTempFile("turbojpeg_", lib);
                tmp.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(tmp);){
                    int n;
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, n);
                    }
                }
                System.load(tmp.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        JPEG_SOI = new byte[]{-1, -40};
        JPEG_EOI = new byte[]{-1, -39};
    }
}

