/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.io.File;
import main.AsyncDelayedScheduler;
import main.CineFrame;
import main.DisplayCommand;
import main.FFmpegBootstrap;
import main.MediaSelectionListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MainPlugin
extends JavaPlugin {
    private File ffmpegBinary;
    private CineFrame cineFrame;
    private AsyncDelayedScheduler asyncScheduler;

    public void onLoad() {
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().init();
        this.saveDefaultConfig();
        try {
            this.ffmpegBinary = FFmpegBootstrap.download(this);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to download FFmpeg binary: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        File mediaDir = new File(this.getDataFolder(), "media");
        if (!mediaDir.exists()) {
            mediaDir.mkdirs();
        }
        this.asyncScheduler = new AsyncDelayedScheduler();
        this.cineFrame = new CineFrame(this, this.ffmpegBinary, this.asyncScheduler);
        Bukkit.getPluginManager().registerEvents((Listener)new MediaSelectionListener(), (Plugin)this);
        DisplayCommand dc = new DisplayCommand(this.cineFrame, mediaDir);
        for (String c : new String[]{"media", "delmedia", "play", "pause"}) {
            PluginCommand pc = this.getCommand(c);
            if (pc == null) continue;
            pc.setExecutor((CommandExecutor)dc);
            pc.setTabCompleter((TabCompleter)dc);
        }
        this.getLogger().info("CineFrame enabled");
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public CineFrame getCineFrame() {
        return this.cineFrame;
    }
}

