/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MediaResourcePackManager
implements Listener {
    private static final Map<Integer, HttpServer> SERVERS = new ConcurrentHashMap<Integer, HttpServer>();
    private final JavaPlugin plugin;
    private final File ffmpegExe;
    private final int webPort;
    private final String publicHost;
    private final String publicScheme;
    private final int publicPort;
    private final String localHost;
    private final String localScheme;
    private final int localPort;
    private final String loopbackHost;
    private final String loopbackScheme;
    private final int loopbackPort;
    private final boolean debugPackUrl;
    private final boolean httpDebug;
    private final boolean httpLogHeaders;
    private final File workDir;
    private final File audioDir;
    private final File packDir;
    private HttpServer httpServer;
    private String publicPackUrl;
    private String localPackUrl;
    private String loopbackPackUrl;
    private byte[] packHash;
    private int version = 0;
    private File curZip;
    private final Set<UUID> delivered = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean building = new AtomicBoolean(false);

    public boolean isBuilding() {
        return this.building.get();
    }

    public MediaResourcePackManager(JavaPlugin plugin, File ffmpegExe, int webPort) {
        this.plugin = plugin;
        this.ffmpegExe = ffmpegExe;
        this.webPort = webPort;
        this.workDir = new File(plugin.getDataFolder(), "media_work");
        this.audioDir = new File(this.workDir, "audio");
        this.packDir = new File(this.workDir, "pack");
        plugin.saveDefaultConfig();
        this.publicHost = plugin.getConfig().getString("datapack-public-host", "").trim();
        this.publicScheme = plugin.getConfig().getString("datapack-scheme", "http").trim();
        this.publicPort = plugin.getConfig().getInt("datapack-public-port", webPort);
        this.localHost = plugin.getConfig().getString("datapack-local-host", "").trim();
        this.localScheme = plugin.getConfig().getString("datapack-local-scheme", "http").trim();
        this.localPort = plugin.getConfig().getInt("datapack-local-port", webPort);
        this.loopbackHost = plugin.getConfig().getString("datapack-loopback-host", "localhost").trim();
        this.loopbackScheme = plugin.getConfig().getString("datapack-loopback-scheme", "http").trim();
        this.loopbackPort = plugin.getConfig().getInt("datapack-loopback-port", webPort);
        this.debugPackUrl = plugin.getConfig().getBoolean("datapack-debug-pack-url", false);
        this.httpDebug = plugin.getConfig().getBoolean("datapack-http-debug", false);
        this.httpLogHeaders = plugin.getConfig().getBoolean("datapack-http-log-headers", false);
        if (this.publicHost.isEmpty()) {
            plugin.getLogger().warning("datapack-public-host is missing in config.yml. Remote users will fail until set.");
        }
        if (this.localHost.isEmpty()) {
            plugin.getLogger().warning("datapack-local-host is missing in config.yml. LAN users will fail unless they are true loopback.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void extractWholeAudio(File videoFile) throws Exception {
        MediaResourcePackManager.cleanDir(this.workDir.toPath());
        this.audioDir.mkdirs();
        List<String> cmd = Arrays.asList(this.ffmpegExe.getAbsolutePath(), "-y", "-loglevel", "error", "-i", videoFile.getAbsolutePath(), "-vn", "-ac", "2", "-ar", "44100", "-c:a", "libvorbis", "-q:a", "5", new File(this.audioDir, "full.ogg").getAbsolutePath());
        this.runCmd(cmd, "extract");
        this.building.set(true);
        try {
            this.buildPack(0.0);
        }
        finally {
            this.building.set(false);
        }
        this.initServer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::sendToAll, 40L);
    }

    public void rebuildTrimmedPack(double offsetSec) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.building.set(true);
            try {
                this.buildPack(offsetSec);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("pack rebuild failed: " + ex.getMessage());
            }
            finally {
                this.building.set(false);
                this.sendToAll();
            }
        });
    }

    private void buildPack(double offsetSec) throws Exception {
        MediaResourcePackManager.cleanDir(this.packDir.toPath());
        Files.createDirectories(this.packDir.toPath(), new FileAttribute[0]);
        File src = new File(this.audioDir, "full.ogg");
        File dst = new File(this.packDir, "video.ogg");
        List<String> cmd = Arrays.asList(this.ffmpegExe.getAbsolutePath(), "-y", "-loglevel", "error", "-ss", String.valueOf(offsetSec), "-i", src.getAbsolutePath(), "-vn", "-ac", "1", "-ar", "22050", "-c:a", "libvorbis", "-q:a", "3", dst.getAbsolutePath());
        this.runCmd(cmd, "trim");
        Path soundsDir = this.packDir.toPath().resolve("assets/minecraft/sounds/media");
        Files.createDirectories(soundsDir, new FileAttribute[0]);
        Files.move(dst.toPath(), soundsDir.resolve("video.ogg"), StandardCopyOption.REPLACE_EXISTING);
        String json = "{\n  \"media.video\": {\"sounds\": [{\"name\":\"media/video\",\"stream\":true}]}\n}";
        Files.write(this.packDir.toPath().resolve("assets/minecraft/sounds.json"), json.getBytes(), new OpenOption[0]);
        String mcmeta = "{\n  \"pack\": {\"pack_format\": 55, \"description\": \"Media Pack\"}\n}";
        Files.write(this.packDir.toPath().resolve("pack.mcmeta"), mcmeta.getBytes(), new OpenOption[0]);
        ++this.version;
        this.curZip = new File(this.workDir, "pack_" + this.version + ".zip");
        MediaResourcePackManager.zipFolder(this.packDir.toPath(), this.curZip.toPath());
        this.packHash = MediaResourcePackManager.sha1(this.curZip);
        this.publicPackUrl = null;
        this.localPackUrl = null;
        this.loopbackPackUrl = null;
        if (!this.publicHost.isEmpty()) {
            this.publicPackUrl = this.buildUrl(this.publicScheme, this.publicHost, this.publicPort, this.curZip.getName());
            this.plugin.getLogger().info("Resource pack public url: " + this.publicPackUrl);
        }
        if (!this.localHost.isEmpty()) {
            this.localPackUrl = this.buildUrl(this.localScheme, this.localHost, this.localPort, this.curZip.getName());
            this.plugin.getLogger().info("Resource pack local url: " + this.localPackUrl);
        }
        if (!this.loopbackHost.isEmpty()) {
            this.loopbackPackUrl = this.buildUrl(this.loopbackScheme, this.loopbackHost, this.loopbackPort, this.curZip.getName());
            this.plugin.getLogger().info("Resource pack loopback url: " + this.loopbackPackUrl);
        }
    }

    private void initServer() throws IOException {
        this.httpServer = SERVERS.computeIfAbsent(this.webPort, p -> {
            try {
                HttpServer s = HttpServer.create(new InetSocketAddress((int)p), 128);
                ExecutorService exec = Executors.newCachedThreadPool(r -> {
                    Thread t = new Thread(r, "CineFramePackHttp");
                    t.setDaemon(true);
                    return t;
                });
                s.setExecutor(exec);
                s.start();
                return s;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.updateContext();
    }

    private void updateContext() {
        try {
            this.httpServer.removeContext("/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpServer.createContext("/", new FileHandler(this.plugin, this.workDir, this.httpDebug, this.httpLogHeaders));
        this.delivered.clear();
    }

    public void sendToAll() {
        this.updateContext();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.maybeSend(p);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.maybeSend(e.getPlayer());
    }

    private void maybeSend(Player p) {
        if (this.packHash == null) {
            return;
        }
        String url = this.pickPackUrlForPlayer(p);
        if (url == null) {
            return;
        }
        if (this.delivered.add(p.getUniqueId())) {
            if (this.debugPackUrl) {
                this.debugPackChoice(p, url);
            }
            p.setResourcePack(url, this.packHash, false);
        }
    }

    private String pickPackUrlForPlayer(Player p) {
        String ip = this.getPlayerIp(p);
        if (ip != null && (ip.equals("127.0.0.1") || ip.equals("::1")) && this.loopbackPackUrl != null) {
            return this.loopbackPackUrl;
        }
        if (ip != null && this.isPrivateIpv4(ip) && this.localPackUrl != null) {
            return this.localPackUrl;
        }
        return this.publicPackUrl;
    }

    private String getPlayerIp(Player p) {
        if (p.getAddress() == null || p.getAddress().getAddress() == null) {
            return null;
        }
        return p.getAddress().getAddress().getHostAddress();
    }

    private void debugPackChoice(Player p, String chosenUrl) {
        String ip = this.getPlayerIp(p);
        if (ip == null) {
            ip = "unknown";
        }
        this.plugin.getLogger().info("Pack for " + p.getName() + " ip=" + ip + " url=" + chosenUrl);
    }

    private boolean isPrivateIpv4(String ip) {
        int b;
        int a;
        String[] parts = ip.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        try {
            a = Integer.parseInt(parts[0]);
            b = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (a == 10) {
            return true;
        }
        if (a == 192 && b == 168) {
            return true;
        }
        return a == 172 && b >= 16 && b <= 31;
    }

    private String buildUrl(String schemeIn, String hostIn, int portIn, String fileName) {
        Object encodedName;
        String host = MediaResourcePackManager.sanitizeHost(hostIn);
        String scheme = schemeIn == null || schemeIn.isBlank() ? "http" : schemeIn.trim().toLowerCase();
        int port = portIn;
        boolean defaultPort = scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443;
        Object portPart = defaultPort ? "" : ":" + port;
        try {
            encodedName = new URI(null, null, "/" + fileName, null).getRawPath();
        }
        catch (Exception e) {
            encodedName = "/" + fileName;
        }
        return scheme + "://" + host + (String)portPart + (String)encodedName;
    }

    private static String sanitizeHost(String host) {
        if (host == null) {
            return "127.0.0.1";
        }
        if ((host = host.trim()).isEmpty()) {
            return "127.0.0.1";
        }
        int slash = (host = host.replace("http://", "").replace("https://", "")).indexOf(47);
        if (slash >= 0) {
            host = host.substring(0, slash);
        }
        return host;
    }

    private void runCmd(List<String> cmd, String tag) throws Exception {
        Process p = new ProcessBuilder(cmd).redirectErrorStream(true).start();
        int code = p.waitFor();
        if (code != 0) {
            throw new IOException("ffmpeg " + tag + " exit " + code);
        }
    }

    private static void zipFolder(Path src, Path dest) throws IOException {
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(dest, new OpenOption[0]));){
            Files.walk(src, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                try {
                    ZipEntry z = new ZipEntry(src.relativize((Path)p).toString().replace('\\', '/'));
                    zs.putNextEntry(z);
                    Files.copy(p, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private static byte[] sha1(File f) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (FileChannel ch = FileChannel.open(f.toPath(), StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(8192);
            while (ch.read(buf) != -1) {
                buf.flip();
                md.update(buf);
                buf.clear();
            }
        }
        return md.digest();
    }

    private static void cleanDir(Path p) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        Files.walk(p, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(t -> {
            try {
                Files.delete(t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static class FileHandler
    implements HttpHandler {
        private final File root;
        private final JavaPlugin plugin;
        private final boolean debug;
        private final boolean logHeaders;

        FileHandler(JavaPlugin plugin, File root, boolean debug, boolean logHeaders) {
            this.plugin = plugin;
            this.root = root;
            this.debug = debug;
            this.logHeaders = logHeaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange ex) throws IOException {
            String path;
            long startNs = System.nanoTime();
            String method = ex.getRequestMethod();
            String string = path = ex.getRequestURI() != null ? ex.getRequestURI().getPath() : null;
            if (path == null) {
                path = "/";
            }
            String remote = String.valueOf(ex.getRemoteAddress());
            String range = ex.getRequestHeaders().getFirst("Range");
            String ua = ex.getRequestHeaders().getFirst("User-Agent");
            if (this.debug) {
                this.plugin.getLogger().info("[PackHTTP] " + remote + " " + method + " " + path + " range=" + (range == null ? "-" : range) + " ua=" + (ua == null ? "-" : ua));
                if (this.logHeaders) {
                    for (Map.Entry<String, List<String>> e : ex.getRequestHeaders().entrySet()) {
                        this.plugin.getLogger().info("[PackHTTP] H " + e.getKey() + ": " + String.valueOf(e.getValue()));
                    }
                }
            }
            int status = 500;
            long bytesServed = 0L;
            try {
                int dash;
                String rr;
                String rawPath = path;
                if (rawPath.startsWith("/")) {
                    rawPath = rawPath.substring(1);
                }
                if (rawPath.isEmpty()) {
                    status = 404;
                    ex.sendResponseHeaders(404, -1L);
                    return;
                }
                File rootCanon = this.root.getCanonicalFile();
                File f = new File(rootCanon, rawPath).getCanonicalFile();
                if (!(f.getPath().startsWith(rootCanon.getPath() + File.separator) && f.exists() && f.isFile())) {
                    status = 404;
                    ex.sendResponseHeaders(404, -1L);
                    return;
                }
                long size = f.length();
                Headers h = ex.getResponseHeaders();
                h.set("Content-Type", "application/zip");
                h.set("Cache-Control", "no-store");
                h.set("Accept-Ranges", "bytes");
                h.set("Connection", "close");
                if ("HEAD".equalsIgnoreCase(method)) {
                    h.set("Content-Length", String.valueOf(size));
                    status = 200;
                    ex.sendResponseHeaders(200, -1L);
                    return;
                }
                String r = ex.getRequestHeaders().getFirst("Range");
                long start = 0L;
                long end = size - 1L;
                boolean partial = false;
                if (r != null && (rr = r.trim().toLowerCase()).startsWith("bytes=") && (dash = (rr = rr.substring("bytes=".length())).indexOf(45)) >= 0) {
                    String a = rr.substring(0, dash).trim();
                    String b = rr.substring(dash + 1).trim();
                    try {
                        if (!a.isEmpty()) {
                            start = Long.parseLong(a);
                        }
                        if (!b.isEmpty()) {
                            end = Long.parseLong(b);
                        }
                        partial = true;
                    }
                    catch (NumberFormatException ignored) {
                        start = 0L;
                        end = size - 1L;
                        partial = false;
                    }
                }
                if (start < 0L) {
                    start = 0L;
                }
                if (end >= size) {
                    end = size - 1L;
                }
                if (end < start) {
                    status = 416;
                    ex.sendResponseHeaders(416, -1L);
                    return;
                }
                long len = end - start + 1L;
                if (partial) {
                    h.set("Content-Range", "bytes " + start + "-" + end + "/" + size);
                    h.set("Content-Length", String.valueOf(len));
                    status = 206;
                    ex.sendResponseHeaders(206, len);
                } else {
                    h.set("Content-Length", String.valueOf(size));
                    status = 200;
                    ex.sendResponseHeaders(200, size);
                }
                try (BufferedOutputStream out = new BufferedOutputStream(ex.getResponseBody(), 262144);
                     FileInputStream fis = new FileInputStream(f);){
                    int want;
                    int n;
                    if (start > 0L) {
                        long s2;
                        for (long skipped = fis.skip(start); skipped < start && (s2 = fis.skip(start - skipped)) > 0L; skipped += s2) {
                        }
                    }
                    byte[] buf = new byte[262144];
                    for (long remaining = len; remaining > 0L && (n = fis.read(buf, 0, want = (int)Math.min((long)buf.length, remaining))) >= 0; remaining -= (long)n) {
                        out.write(buf, 0, n);
                        bytesServed += (long)n;
                    }
                    out.flush();
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    this.plugin.getLogger().warning("[PackHTTP] error " + remote + " " + method + " " + path + " : " + String.valueOf(e));
                }
                try {
                    ex.sendResponseHeaders(500, -1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    ex.close();
                }
                catch (Exception e) {}
                if (this.debug) {
                    long ms = (System.nanoTime() - startNs) / 1000000L;
                    this.plugin.getLogger().info("[PackHTTP] done " + remote + " " + method + " " + path + " status=" + status + " bytes=" + bytesServed + " ms=" + ms);
                }
            }
        }
    }
}

