/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import main.CineFrame;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class MediaSelectionListener
implements Listener {
    private static final Map<UUID, Pending> pending = new HashMap<UUID, Pending>();

    public static String safeIdName(String name) {
        String[] reserved;
        Object cleaned = name.replaceAll("[\\\\/:*?\"<>|\\p{Cntrl}]", "_").replaceAll("[. ]+$", "").trim();
        if (((String)cleaned).isEmpty()) {
            cleaned = "media";
        }
        String upper = ((String)cleaned).toUpperCase();
        for (String word : reserved = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}) {
            if (!upper.equals(word)) continue;
            cleaned = "_" + (String)cleaned;
            break;
        }
        return cleaned;
    }

    public static void startSelection(UUID player, File file, File mediaDir, CineFrame cineFrame) {
        pending.put(player, new Pending(player, file, cineFrame, mediaDir, null));
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent ev) {
        int dz;
        int dy;
        int dx;
        Location origin;
        int tilesY;
        int tilesX;
        BlockFace facing;
        boolean zConst;
        if (ev.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player p = ev.getPlayer();
        Pending sel = pending.get(p.getUniqueId());
        if (sel == null) {
            return;
        }
        ev.setCancelled(true);
        Location clicked = ev.getClickedBlock().getLocation();
        if (sel.first == null) {
            pending.put(p.getUniqueId(), new Pending(sel.player, sel.file, sel.cineFrame, sel.mediaDir, clicked));
            p.sendMessage("First corner set at " + clicked.getBlockX() + "," + clicked.getBlockY() + "," + clicked.getBlockZ());
            p.sendMessage("Now left-click the opposite corner");
            return;
        }
        Location a = sel.first;
        Location b = clicked;
        if (!a.getWorld().equals((Object)b.getWorld())) {
            p.sendMessage("Must be in the same world. Selection cancelled.");
            pending.remove(p.getUniqueId());
            return;
        }
        int x1 = a.getBlockX();
        int y1 = a.getBlockY();
        int z1 = a.getBlockZ();
        int x2 = b.getBlockX();
        int y2 = b.getBlockY();
        int z2 = b.getBlockZ();
        boolean xConst = x1 == x2;
        boolean bl = zConst = z1 == z2;
        if (!xConst && !zConst) {
            p.sendMessage("Corners must share either X or Z. Selection cancelled.");
            pending.remove(p.getUniqueId());
            return;
        }
        Location playerLoc = p.getLocation();
        if (zConst) {
            int xStep;
            int xEnd;
            int xStart;
            BlockFace blockFace = facing = playerLoc.getZ() >= (double)z1 ? BlockFace.SOUTH : BlockFace.NORTH;
            if (facing == BlockFace.SOUTH) {
                xStart = Math.min(x1, x2);
                xEnd = Math.max(x1, x2);
                xStep = 1;
            } else {
                xStart = Math.max(x1, x2);
                xEnd = Math.min(x1, x2);
                xStep = -1;
            }
            int yStart = Math.max(y1, y2);
            int yEnd = Math.min(y1, y2);
            int yStep = -1;
            tilesX = Math.abs(xEnd - xStart) + 1;
            tilesY = Math.abs(yEnd - yStart) + 1;
            origin = new Location(a.getWorld(), (double)xStart, (double)yStart, (double)z1);
            dx = xStep;
            dy = yStep;
            dz = 0;
        } else {
            int zStep;
            int zEnd;
            int zStart;
            BlockFace blockFace = facing = playerLoc.getX() >= (double)x1 ? BlockFace.EAST : BlockFace.WEST;
            if (facing == BlockFace.EAST) {
                zStart = Math.min(z1, z2);
                zEnd = Math.max(z1, z2);
                zStep = 1;
            } else {
                zStart = Math.max(z1, z2);
                zEnd = Math.min(z1, z2);
                zStep = -1;
            }
            int yStart = Math.max(y1, y2);
            int yEnd = Math.min(y1, y2);
            int yStep = -1;
            tilesX = Math.abs(zEnd - zStart) + 1;
            tilesY = Math.abs(yEnd - yStart) + 1;
            origin = new Location(a.getWorld(), (double)x1, (double)yStart, (double)zStart);
            dx = 0;
            dy = yStep;
            dz = zStep;
        }
        String safeFileName = MediaSelectionListener.safeIdName(sel.file.getName());
        if (safeFileName.isEmpty()) {
            p.sendMessage("Could not process file name. Selection cancelled.");
            pending.remove(p.getUniqueId());
            return;
        }
        String id = safeFileName + "@" + a.getWorld().getName() + "," + x1 + "," + y1 + "," + z1 + "-" + x2 + "," + y2 + "," + z2;
        sel.cineFrame.play(sel.file, origin, id, tilesX, tilesY, facing, dx, dy, dz);
        p.sendMessage("Media placed as " + tilesX + "x" + tilesY + " starting at " + origin.getBlockX() + "," + origin.getBlockY() + "," + origin.getBlockZ() + " facing " + String.valueOf(facing));
        pending.remove(p.getUniqueId());
    }

    record Pending(UUID player, File file, CineFrame cineFrame, File mediaDir, Location first) {
    }
}

