/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSelectBundleItem;
import com.google.common.collect.Multimap;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bamboo;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.damage.DamageSource;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.spawner.TrialSpawnerConfiguration;
import org.bukkit.tag.DamageTypeTags;
import org.bukkit.util.Vector;

public class GGQOL
extends JavaPlugin
implements Listener {
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();
    private static final int BULK_CRAFT_MAX_CRAFTS = Integer.MAX_VALUE;
    private static final int BULK_TRADE_MAX_TRADES = Integer.MAX_VALUE;
    private static final int SEA_PICKLE_MAX = 4;
    private static final int DURABILITY_WARN_REMAINING = 1;
    private static final long DURABILITY_WARN_COOLDOWN_MS = 1200L;
    private static final String ANVIL_COST_PREFIX = "Cost: ";
    private static final int CURE_MAJOR_POSITIVE = 20;
    private static final int CURE_MINOR_POSITIVE = 25;
    private static final long WORK_START = 0L;
    private static final long WORK_END = 24000L;
    private static final EnumSet<Material> BONEMEAL_OVERRIDE_BLOCKED = EnumSet.of(Material.CHEST, new Material[]{Material.TRAPPED_CHEST, Material.BARREL, Material.ENDER_CHEST, Material.CRAFTING_TABLE, Material.CARTOGRAPHY_TABLE, Material.FLETCHING_TABLE, Material.LOOM, Material.SMITHING_TABLE, Material.GRINDSTONE, Material.STONECUTTER, Material.ENCHANTING_TABLE, Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL, Material.FURNACE, Material.BLAST_FURNACE, Material.SMOKER, Material.BREWING_STAND, Material.BEACON, Material.LECTERN, Material.COMPOSTER, Material.DISPENSER, Material.DROPPER, Material.HOPPER, Material.CAULDRON, Material.WATER_CAULDRON, Material.LAVA_CAULDRON, Material.POWDER_SNOW_CAULDRON, Material.CHISELED_BOOKSHELF, Material.DECORATED_POT, Material.FLOWER_POT, Material.JUKEBOX, Material.NOTE_BLOCK, Material.CAMPFIRE, Material.SOUL_CAMPFIRE});
    private static final EnumSet<Material> VILLAGER_JOB_SITES = EnumSet.of(Material.BARREL, new Material[]{Material.BLAST_FURNACE, Material.BREWING_STAND, Material.CARTOGRAPHY_TABLE, Material.CAULDRON, Material.COMPOSTER, Material.FLETCHING_TABLE, Material.GRINDSTONE, Material.LECTERN, Material.LOOM, Material.SMITHING_TABLE, Material.SMOKER, Material.STONECUTTER});
    private static final EnumMap<Material, TreeType> SAPLING_TREE_TYPES = new EnumMap(Material.class);
    private final Set<Long> bonemealPending = ConcurrentHashMap.newKeySet();
    private final Set<Long> replantPending = ConcurrentHashMap.newKeySet();
    private final Set<Long> smeltLocks = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<Material, Integer> fuelTicksCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ScheduledTask> replantTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Long> durabilityWarnCooldown = new ConcurrentHashMap();
    private final Set<UUID> armorNearBreakDamagePass = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<UUID, VillagerTradeClickState> villagerTradeClicks = new ConcurrentHashMap();
    private boolean instantFurnace;
    private boolean instantSmoker;
    private boolean instantBlastFurnace;
    private boolean instantBrewing;
    private boolean instantCampfire;
    private double fuelCostMultiplier;
    private boolean safeFuelMode;
    private boolean instantAnimals;
    private boolean animalsInstantGrow;
    private boolean animalsInstantTame;
    private boolean animalsResetBreedCooldown;
    private boolean animalsFeedUsesMultiplier;
    private boolean animalsFeedUseShulkers;
    private boolean animalsFeedUseBundles;
    private int animalsFeedBundleMaxDepth;
    private boolean autoPlant;
    private boolean autoPlantAllowCreative;
    private boolean autoPlantUseShulkers;
    private boolean autoPlantUseBundles;
    private int autoPlantBundleMaxDepth;
    private int replantTries;
    private boolean bonemealMaxGrow;
    private int bonemealBambooCap;
    private int bonemealSugarCaneCap;
    private int bonemealCactusCap;
    private static final Object TREE_GEN_LOCK;
    private boolean villagersInstantCure;
    private boolean villagersInstantWorkbenchUpdate;
    private int villagersInstantWorkbenchRange;
    private boolean villagersResetTradeCooldown;
    private boolean bulkCrafting;
    private boolean bulkCraftingUseShulkers;
    private boolean bulkCraftingUseBundles;
    private int bulkCraftingBundleMaxDepth;
    private boolean villagersBulkTrading;
    private boolean villagersBulkTradingUseShulkers;
    private boolean villagersBulkTradingUseBundles;
    private int villagersBulkTradingBundleMaxDepth;
    private boolean villagersBulkTradingDropOver64;
    private int villagersBulkTradingDoubleClickTicks;
    private boolean seaPicklesFastPlace;
    private boolean seaPicklesFastPlaceUseShulkers;
    private boolean seaPicklesFastPlaceUseBundles;
    private int seaPicklesFastPlaceBundleMaxDepth;
    private boolean anvilUnlimitedRepairCost;
    private int anvilMaxRepairCost;
    private boolean armoredElytra;
    private boolean preventToolBreak;
    private boolean preventArmorBreak;
    private boolean inventoryTotem;
    private boolean inventoryTotemUseShulkers;
    private boolean inventoryTotemUseBundles;
    private boolean inventoryTotemCheckEnderChest;
    private boolean inventoryTotemSkipIfHeld;
    private int inventoryTotemBundleMaxDepth;
    private NamespacedKey zvCurePlayerKey;
    private NamespacedKey anvilCostLoreKey;
    private NamespacedKey armoredElytraTagKey;
    private NamespacedKey armoredElytraArmorModKey;
    private NamespacedKey armoredElytraToughModKey;
    private NamespacedKey armoredElytraKbModKey;
    private NamespacedKey armoredElytraKey;
    private static final long PIN_WINDOW_NANOS = 400000000L;
    private final ConcurrentHashMap<UUID, ConcurrentHashMap<Long, PinnedDrop>> canePins = new ConcurrentHashMap();
    private boolean silkTouchRecoverBlocks;
    private boolean silkTouchRecoverAllowCreative;
    private boolean silkTouchSpawnerDropSpawner;
    private boolean silkTouchSpawnerDropEgg;
    private int silkTouchSpawnerEggAmount;
    private EnumSet<Material> silkTouchRecoverBlacklist = EnumSet.noneOf(Material.class);
    private final ConcurrentHashMap<UUID, SilkTouchBreakTracker> silkTouchBreaks = new ConcurrentHashMap();
    private boolean bundleScroll;
    private int bundleScrollMinStacks;
    private int bundleScrollWindowSize;
    private int bundleScrollStep;
    private long bundleScrollCooldownNanos;
    private final ConcurrentHashMap<UUID, ConcurrentHashMap<Long, BundleScrollState>> bundleScrollStates = new ConcurrentHashMap();
    private BundleScrollPacketListener bundleScrollPacketListener;
    private boolean mudSpread;
    private int mudSpreadRange;
    private int mudSpreadBlocksPerStep;
    private int mudSpreadStepIntervalTicks;
    private final ConcurrentHashMap<Long, MudSpreadJob> mudSpreadJobs = new ConcurrentHashMap();
    volatile ScheduledFuture<?> task;
    final AtomicBoolean tickRunning = new AtomicBoolean(false);
    private boolean concretePowderInWater;
    private boolean concretePowderInWaterUseShulkers;
    private boolean concretePowderInWaterUseBundles;
    private int concretePowderInWaterBundleMaxDepth;
    private final Set<UUID> concretePowderPollActive = ConcurrentHashMap.newKeySet();
    private static final int CONCRETE_POLL_MAX_TICKS = 60;
    private static final int CONCRETE_POLL_INTERVAL = 2;
    private static final EnumMap<Material, Material> POWDER_TO_CONCRETE;
    private boolean pistonProtectFarmland;
    private int pistonProtectFarmlandWaterRadius;

    private ConcurrentHashMap<Long, PinnedDrop> pins(World w) {
        return this.canePins.computeIfAbsent(w.getUID(), k -> new ConcurrentHashMap());
    }

    private static long sanitizeTicks(long ticks) {
        return Math.max(1L, ticks);
    }

    public void onLoad() {
        try {
            PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
            PacketEvents.getAPI().load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onEnable() {
        this.ensureConfigExists();
        this.loadSettings();
        this.initKeys();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.initPacketEvents();
        this.getLogger().info("GoofyGoober's Quality of Life enabled");
    }

    public void onDisable() {
        this.cancelReplantTasks();
        this.cancelMudSpreadTasks();
        this.clearRuntimeState();
        this.terminatePacketEvents();
        this.getLogger().info("GoofyGoober's Quality of Life disabled");
    }

    private void initKeys() {
        this.zvCurePlayerKey = new NamespacedKey((Plugin)this, "zv_cure_player");
        this.anvilCostLoreKey = new NamespacedKey((Plugin)this, "anvil_cost_lore");
        this.armoredElytraTagKey = new NamespacedKey((Plugin)this, "armored_elytra");
        this.armoredElytraArmorModKey = new NamespacedKey((Plugin)this, "armored_elytra_armor");
        this.armoredElytraToughModKey = new NamespacedKey((Plugin)this, "armored_elytra_toughness");
        this.armoredElytraKbModKey = new NamespacedKey((Plugin)this, "armored_elytra_knockback");
        this.armoredElytraKey = this.armoredElytraTagKey;
    }

    private void cancelReplantTasks() {
        for (ScheduledTask t : this.replantTasks.values()) {
            try {
                t.cancel();
            }
            catch (Throwable throwable) {}
        }
        this.replantTasks.clear();
    }

    private void clearRuntimeState() {
        this.replantPending.clear();
        this.bonemealPending.clear();
        this.smeltLocks.clear();
        this.fuelTicksCache.clear();
        this.villagerTradeClicks.clear();
        this.durabilityWarnCooldown.clear();
        this.armorNearBreakDamagePass.clear();
        this.bundleScrollStates.clear();
        this.silkTouchBreaks.clear();
        this.concretePowderPollActive.clear();
    }

    private void ensureConfigExists() {
        File cfg;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(cfg = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
    }

    private void loadSettings() {
        this.reloadConfig();
        this.instantFurnace = this.getConfig().getBoolean("settings.instant-furnace", true);
        this.instantSmoker = this.getConfig().getBoolean("settings.instant-smoker", true);
        this.instantBlastFurnace = this.getConfig().getBoolean("settings.instant-blast-furnace", true);
        this.instantBrewing = this.getConfig().getBoolean("settings.instant-brewing-stand", true);
        this.instantCampfire = this.getConfig().getBoolean("settings.instant-campfire", true);
        this.fuelCostMultiplier = this.getConfig().getDouble("settings.fuel-cost-multiplier", 2.0);
        if (!Double.isFinite(this.fuelCostMultiplier)) {
            this.fuelCostMultiplier = 1.0;
        }
        if (this.fuelCostMultiplier < 0.01) {
            this.fuelCostMultiplier = 0.01;
        }
        this.safeFuelMode = this.getConfig().getBoolean("settings.safe-fuel-mode", true);
        this.instantAnimals = this.getConfig().getBoolean("settings.instant-animals", true);
        this.animalsInstantGrow = this.getConfig().getBoolean("settings.animals-instant-grow", true);
        this.animalsResetBreedCooldown = this.getConfig().getBoolean("settings.animals-reset-breed-cooldown", true);
        this.animalsFeedUsesMultiplier = this.getConfig().getBoolean("settings.animals-feed-uses-multiplier", true);
        this.animalsInstantTame = this.getConfig().getBoolean("settings.animals-instant-tame", true);
        this.animalsFeedUseShulkers = this.getConfig().getBoolean("settings.animals-feed-use-shulkers", true);
        this.animalsFeedUseBundles = this.getConfig().getBoolean("settings.animals-feed-use-bundles", true);
        this.animalsFeedBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.animals-feed-bundle-max-depth", 4), 1, 16);
        this.autoPlant = this.getConfig().getBoolean("settings.auto-plant", true);
        this.autoPlantUseShulkers = this.getConfig().getBoolean("settings.auto-plant-use-shulkers", true);
        this.autoPlantAllowCreative = this.getConfig().getBoolean("settings.auto-plant-allow-creative", false);
        this.autoPlantUseBundles = this.getConfig().getBoolean("settings.auto-plant-use-bundles", true);
        this.autoPlantBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.auto-plant-bundle-max-depth", 4), 1, 16);
        this.bonemealMaxGrow = this.getConfig().getBoolean("settings.bonemeal-max-grow", true);
        this.villagersResetTradeCooldown = this.getConfig().getBoolean("settings.villagers-reset-trade-cooldown", true);
        this.villagersInstantCure = this.getConfig().getBoolean("settings.villagers-instant-cure", true);
        this.villagersInstantWorkbenchUpdate = this.getConfig().getBoolean("settings.villagers-instant-workbench-update", true);
        this.villagersInstantWorkbenchRange = Math.max(0, this.getConfig().getInt("settings.villagers-instant-workbench-range", 1));
        this.replantTries = Math.max(1, this.getConfig().getInt("settings.replant-tries", 120));
        this.bonemealBambooCap = this.clampInt(this.getConfig().getInt("settings.bonemeal-bamboo-cap", 16), 1, 256);
        this.bonemealSugarCaneCap = this.clampInt(this.getConfig().getInt("settings.bonemeal-sugar-cane-cap", 3), 1, 256);
        this.bonemealCactusCap = this.clampInt(this.getConfig().getInt("settings.bonemeal-cactus-cap", 3), 1, 256);
        this.bulkCrafting = this.getConfig().getBoolean("settings.bulk-crafting", true);
        this.bulkCraftingUseShulkers = this.getConfig().getBoolean("settings.bulk-crafting-use-shulkers", true);
        this.bulkCraftingUseBundles = this.getConfig().getBoolean("settings.bulk-crafting-use-bundles", true);
        this.bulkCraftingBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.bulk-crafting-bundle-max-depth", 4), 1, 16);
        this.villagersBulkTrading = this.getConfig().getBoolean("settings.villagers-bulk-trading", true);
        this.villagersBulkTradingUseShulkers = this.getConfig().getBoolean("settings.villagers-bulk-trading-use-shulkers", true);
        this.villagersBulkTradingUseBundles = this.getConfig().getBoolean("settings.villagers-bulk-trading-use-bundles", true);
        this.villagersBulkTradingBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.villagers-bulk-trading-bundle-max-depth", 4), 1, 16);
        this.villagersBulkTradingDropOver64 = this.getConfig().getBoolean("settings.villagers-bulk-trading-drop-over-64", true);
        this.villagersBulkTradingDoubleClickTicks = this.clampInt(this.getConfig().getInt("settings.villagers-bulk-trading-double-click-ticks", 10), 1, 40);
        this.seaPicklesFastPlace = this.getConfig().getBoolean("settings.sea-pickles-fast-place", true);
        this.seaPicklesFastPlaceUseShulkers = this.getConfig().getBoolean("settings.sea-pickles-fast-place-use-shulkers", true);
        this.seaPicklesFastPlaceUseBundles = this.getConfig().getBoolean("settings.sea-pickles-fast-place-use-bundles", true);
        this.seaPicklesFastPlaceBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.sea-pickles-fast-place-bundle-max-depth", 4), 1, 16);
        this.anvilUnlimitedRepairCost = this.getConfig().getBoolean("settings.anvil-unlimited-repair-cost", true);
        this.anvilMaxRepairCost = this.getConfig().getInt("settings.anvil-max-repair-cost", Integer.MAX_VALUE);
        if (this.anvilMaxRepairCost <= 0) {
            this.anvilMaxRepairCost = Integer.MAX_VALUE;
        }
        if (this.anvilMaxRepairCost < 40) {
            this.anvilMaxRepairCost = 40;
        }
        this.armoredElytra = this.getConfig().getBoolean("settings.armored-elytra", true);
        this.preventToolBreak = this.getConfig().getBoolean("settings.prevent-tool-break", true);
        this.preventArmorBreak = this.getConfig().getBoolean("settings.prevent-armor-break", true);
        this.inventoryTotem = this.getConfig().getBoolean("settings.inventory-totem", true);
        this.inventoryTotemUseShulkers = this.getConfig().getBoolean("settings.inventory-totem-use-shulkers", true);
        this.inventoryTotemUseBundles = this.getConfig().getBoolean("settings.inventory-totem-use-bundles", true);
        this.inventoryTotemCheckEnderChest = this.getConfig().getBoolean("settings.inventory-totem-check-ender-chest", true);
        this.inventoryTotemSkipIfHeld = this.getConfig().getBoolean("settings.inventory-totem-skip-if-held", true);
        this.inventoryTotemBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.inventory-totem-bundle-max-depth", 4), 1, 16);
        this.silkTouchRecoverBlocks = this.getConfig().getBoolean("settings.silk-touch-recover-blocks", true);
        this.silkTouchRecoverAllowCreative = this.getConfig().getBoolean("settings.silk-touch-recover-allow-creative", false);
        this.silkTouchSpawnerDropSpawner = this.getConfig().getBoolean("settings.silk-touch-spawner-drop-spawner", true);
        this.silkTouchSpawnerDropEgg = this.getConfig().getBoolean("settings.silk-touch-spawner-drop-egg", true);
        this.silkTouchSpawnerEggAmount = this.clampInt(this.getConfig().getInt("settings.silk-touch-spawner-egg-amount", 1), 0, 64);
        this.silkTouchRecoverBlacklist = this.loadMaterialSet("settings.silk-touch-recover-blacklist", EnumSet.of(Material.BEDROCK, new Material[]{Material.END_PORTAL_FRAME, Material.END_PORTAL, Material.NETHER_PORTAL, Material.STRUCTURE_BLOCK, Material.JIGSAW, Material.BARRIER, Material.LIGHT}));
        this.bundleScroll = this.getConfig().getBoolean("settings.bundle-scroll", true);
        this.bundleScrollMinStacks = this.clampInt(this.getConfig().getInt("settings.bundle-scroll-min-stacks", 13), 2, 4096);
        this.bundleScrollWindowSize = this.clampInt(this.getConfig().getInt("settings.bundle-scroll-window-size", 8), 1, 64);
        this.bundleScrollStep = this.clampInt(this.getConfig().getInt("settings.bundle-scroll-step", 1), 1, 64);
        this.clampInt(this.getConfig().getInt("settings.bundle-scroll-edge-repeat-packets", 1), 1, 16);
        int cooldownTicks = this.clampInt(this.getConfig().getInt("settings.bundle-scroll-cooldown-ticks", 1), 0, 40);
        this.bundleScrollCooldownNanos = cooldownTicks <= 0 ? 0L : (long)cooldownTicks * 50000000L;
        this.mudSpread = this.getConfig().getBoolean("settings.mud-spread", true);
        this.mudSpreadRange = this.clampInt(this.getConfig().getInt("settings.mud-spread-range", 6), 0, 128);
        this.mudSpreadBlocksPerStep = this.clampInt(this.getConfig().getInt("settings.mud-spread-blocks-per-step", 8), 1, 4096);
        this.mudSpreadStepIntervalTicks = this.clampInt(this.getConfig().getInt("settings.mud-spread-step-interval-ticks", 1), 1, 40);
        this.concretePowderInWater = this.getConfig().getBoolean("settings.concrete-powder-in-water", true);
        this.concretePowderInWaterUseShulkers = this.getConfig().getBoolean("settings.concrete-powder-in-water-use-shulkers", true);
        this.concretePowderInWaterUseBundles = this.getConfig().getBoolean("settings.concrete-powder-in-water-use-bundles", true);
        this.concretePowderInWaterBundleMaxDepth = this.clampInt(this.getConfig().getInt("settings.concrete-powder-in-water-bundle-max-depth", 4), 1, 16);
        this.pistonProtectFarmland = this.getConfig().getBoolean("settings.piston-protect-farmland", true);
        this.pistonProtectFarmlandWaterRadius = this.clampInt(this.getConfig().getInt("settings.piston-protect-farmland-water-radius", 4), 1, 16);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareAnvilUnlimitedRepairCost(PrepareAnvilEvent e) {
        int cost;
        ItemStack result;
        if (e == null) {
            return;
        }
        AnvilView view = e.getView();
        if (view == null) {
            return;
        }
        if (this.anvilUnlimitedRepairCost) {
            try {
                view.setMaximumRepairCost(this.anvilMaxRepairCost);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.armoredElytra) {
            this.trySetArmoredElytraAnvilResult(e, view);
        }
        if (this.isEmpty(result = e.getResult())) {
            return;
        }
        try {
            cost = view.getRepairCost();
        }
        catch (Throwable ignored) {
            return;
        }
        if (cost <= 0) {
            return;
        }
        ItemStack out = result.clone();
        ItemMeta meta = out.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.lore();
        ArrayList<TextComponent> newLore = lore == null ? new ArrayList<TextComponent>() : new ArrayList(lore);
        for (int i = newLore.size() - 1; i >= 0; --i) {
            String plain;
            Component c = (Component)newLore.get(i);
            if (c == null || (plain = PLAIN.serialize(c)) == null || !plain.startsWith(ANVIL_COST_PREFIX)) continue;
            newLore.remove(i);
        }
        newLore.add(Component.text((String)(ANVIL_COST_PREFIX + cost + " levels"), (TextColor)NamedTextColor.DARK_GRAY));
        meta.lore(newLore);
        try {
            meta.getPersistentDataContainer().set(this.anvilCostLoreKey, PersistentDataType.BYTE, (Object)1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out.setItemMeta(meta);
        e.setResult(out);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnvilTakeResultStripCostLore(InventoryClickEvent e) {
        boolean tagged;
        if (e == null) {
            return;
        }
        if (e.getView() == null) {
            return;
        }
        if (e.getView().getType() != InventoryType.ANVIL) {
            return;
        }
        if (e.getRawSlot() != 2) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        if (this.isEmpty(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            tagged = meta.getPersistentDataContainer().has(this.anvilCostLoreKey, PersistentDataType.BYTE);
        }
        catch (Throwable ignored) {
            return;
        }
        if (!tagged) {
            return;
        }
        List lore = meta.lore();
        if (lore != null && !lore.isEmpty()) {
            ArrayList newLore = new ArrayList(lore);
            for (int i = newLore.size() - 1; i >= 0; --i) {
                String plain;
                Component c = (Component)newLore.get(i);
                if (c == null || (plain = PLAIN.serialize(c)) == null || !plain.startsWith(ANVIL_COST_PREFIX)) continue;
                newLore.remove(i);
            }
            meta.lore(newLore.isEmpty() ? null : newLore);
        }
        try {
            meta.getPersistentDataContainer().remove(this.anvilCostLoreKey);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        item.setItemMeta(meta);
        e.setCurrentItem(item);
    }

    private boolean isInstantSmeltingEnabled(Material blockType) {
        if (blockType == Material.FURNACE) {
            return this.instantFurnace;
        }
        if (blockType == Material.SMOKER) {
            return this.instantSmoker;
        }
        if (blockType == Material.BLAST_FURNACE) {
            return this.instantBlastFurnace;
        }
        return false;
    }

    private int getAnimalFeedCost() {
        if (!this.animalsFeedUsesMultiplier) {
            return 1;
        }
        int cost = (int)Math.ceil(this.fuelCostMultiplier);
        if (cost < 1) {
            cost = 1;
        }
        if (cost > 64) {
            cost = 64;
        }
        return cost;
    }

    private void spawnBreedHearts(Animals animal) {
        animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 0.6, 0.0), 8, 0.35, 0.35, 0.35, 0.0);
    }

    private Sound soundByKey(String key) {
        return (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)key));
    }

    private Sound getFeedSound(Animals animal) {
        String typeKey = animal.getType().name().toLowerCase(Locale.ROOT);
        Sound eat = this.soundByKey("entity." + typeKey + ".eat");
        if (eat != null) {
            return eat;
        }
        Sound ambient = this.soundByKey("entity." + typeKey + ".ambient");
        if (ambient != null) {
            return ambient;
        }
        Sound genericEat = this.soundByKey("entity.generic.eat");
        if (genericEat != null) {
            return genericEat;
        }
        return Sound.ENTITY_GENERIC_EAT;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInstantTame(PlayerInteractEntityEvent e) {
        if (!this.instantAnimals) {
            return;
        }
        if (!this.animalsInstantTame) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (!(clicked instanceof Tameable)) {
            return;
        }
        Tameable t = (Tameable)clicked;
        if (t.isTamed()) {
            return;
        }
        try {
            t.setOwner((AnimalTamer)p);
            t.setTamed(true);
            clicked.getWorld().spawnParticle(Particle.HEART, clicked.getLocation().add(0.0, 0.8, 0.0), 10, 0.35, 0.35, 0.35, 0.0);
            Sound s = this.soundByKey("entity.player.levelup");
            if (s != null) {
                clicked.getWorld().playSound(clicked.getLocation(), s, SoundCategory.NEUTRAL, 0.7f, 1.4f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEggHatchInstantGrow(CreatureSpawnEvent e) {
        if (!this.instantAnimals) {
            return;
        }
        if (!this.animalsInstantGrow) {
            return;
        }
        if (e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.EGG) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Chicken)) {
            return;
        }
        Chicken c = (Chicken)livingEntity;
        if (c.isAdult()) {
            return;
        }
        try {
            c.getScheduler().run((Plugin)this, t -> {
                try {
                    c.setAdult();
                    c.setAge(0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, null);
        }
        catch (Throwable ignored) {
            try {
                c.setAdult();
                c.setAge(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnimalFeed(PlayerInteractEntityEvent e) {
        boolean creative;
        ItemStack held;
        ItemStack main;
        Tameable tame;
        if (!this.instantAnimals) {
            return;
        }
        Entity entity = e.getRightClicked();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        Player player = e.getPlayer();
        if (player == null) {
            return;
        }
        if (animal instanceof Tameable && !(tame = (Tameable)animal).isTamed()) {
            return;
        }
        EquipmentSlot hand = e.getHand();
        if (hand == null) {
            return;
        }
        if (hand == EquipmentSlot.OFF_HAND && !this.isEmpty(main = player.getInventory().getItemInMainHand()) && animal.isBreedItem(main)) {
            return;
        }
        ItemStack itemStack = held = hand == EquipmentSlot.HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        if (this.isEmpty(held)) {
            return;
        }
        if (!animal.isBreedItem(held)) {
            return;
        }
        if (!animal.isAdult()) {
            return;
        }
        if (animal.isLoveMode()) {
            return;
        }
        int cost = this.getAnimalFeedCost();
        if (cost <= 1) {
            return;
        }
        boolean bl = creative = player.getGameMode() == GameMode.CREATIVE;
        if (!creative) {
            Material payType = held.getType();
            int haveTotal = this.countMaterialInInventoryAndShulkersUpTo(player.getInventory(), payType, cost, this.animalsFeedUseShulkers, this.animalsFeedUseBundles, this.animalsFeedBundleMaxDepth);
            if (haveTotal < cost) {
                e.setCancelled(true);
                return;
            }
        }
        e.setCancelled(true);
        if (!creative) {
            boolean removed;
            int need = cost;
            int fromHand = Math.min(need, held.getAmount());
            if (fromHand > 0) {
                ItemStack newHeld = held.clone();
                newHeld.setAmount(newHeld.getAmount() - fromHand);
                if (hand == EquipmentSlot.HAND) {
                    player.getInventory().setItemInMainHand(newHeld.getAmount() <= 0 ? null : newHeld);
                } else {
                    player.getInventory().setItemInOffHand(newHeld.getAmount() <= 0 ? null : newHeld);
                }
                need -= fromHand;
            }
            if (need > 0 && !(removed = this.removeMaterialFromInventoryAndShulkers(player.getInventory(), held.getType(), need, this.animalsFeedUseShulkers, this.animalsFeedUseBundles, this.animalsFeedBundleMaxDepth))) {
                return;
            }
        }
        UUID playerId = player.getUniqueId();
        animal.getScheduler().run((Plugin)this, t -> {
            try {
                try {
                    if (!animal.canBreed()) {
                        animal.setAgeLock(false);
                        animal.setBreed(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    animal.setBreedCause(playerId);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                animal.setLoveModeTicks(600);
                Sound feedSound = this.getFeedSound(animal);
                animal.getWorld().playSound(animal.getLocation(), feedSound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.spawnBreedHearts(animal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, null);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnimalBreed(EntityBreedEvent e) {
        if (!this.instantAnimals) {
            return;
        }
        LivingEntity child = e.getEntity();
        LivingEntity mom = e.getMother();
        LivingEntity dad = e.getFather();
        if (this.animalsInstantGrow && child instanceof org.bukkit.entity.Ageable) {
            org.bukkit.entity.Ageable a = (org.bukkit.entity.Ageable)child;
            a.getScheduler().run((Plugin)this, t -> {
                try {
                    if (a instanceof Breedable) {
                        Breedable b = (Breedable)a;
                        b.setAgeLock(false);
                        b.setBreed(true);
                    } else {
                        a.setAdult();
                        a.setAge(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, null);
        }
        if (this.animalsResetBreedCooldown) {
            if (mom instanceof Animals) {
                Animals am = (Animals)mom;
                am.getScheduler().run((Plugin)this, t -> {
                    try {
                        am.setLoveModeTicks(0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }, null);
            }
            if (dad instanceof Animals) {
                Animals ad = (Animals)dad;
                ad.getScheduler().run((Plugin)this, t -> {
                    try {
                        ad.setLoveModeTicks(0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }, null);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCropBreak(BlockBreakEvent e) {
        Ageable age;
        if (!this.autoPlant) {
            return;
        }
        Player player = e.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.autoPlantAllowCreative && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = e.getBlock();
        if (block == null) {
            return;
        }
        Material cropType = block.getType();
        if (cropType == Material.SUGAR_CANE) {
            this.handleColumnPlantBreak(e, player, block, Material.SUGAR_CANE);
            return;
        }
        if (cropType == Material.CACTUS) {
            this.handleColumnPlantBreak(e, player, block, Material.CACTUS);
            return;
        }
        Material seedType = this.getReplantSeedForCrop(cropType);
        if (seedType == null) {
            return;
        }
        Material plantType = this.getReplantPlantForCrop(cropType);
        if (plantType == null) {
            return;
        }
        Material soil = block.getRelative(0, -1, 0).getType();
        if (plantType == Material.NETHER_WART ? soil != Material.SOUL_SAND : soil != Material.FARMLAND) {
            return;
        }
        BlockData data = block.getBlockData();
        if (this.isAgeBasedCrop(cropType) && data instanceof Ageable && (age = (Ageable)data).getAge() < age.getMaximumAge()) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        Collection dropsCol = block.getDrops(tool, (Entity)player);
        if (dropsCol == null || dropsCol.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (ItemStack st : dropsCol) {
            if (this.isEmpty(st)) continue;
            drops.add(st.clone());
        }
        if (drops.isEmpty()) {
            return;
        }
        boolean paid = this.removeOneFromDrops(drops, seedType);
        if (!paid) {
            paid = player.getGameMode() == GameMode.CREATIVE ? true : this.takeOneFromInventory(player, seedType);
        }
        if (!paid) {
            return;
        }
        e.setDropItems(false);
        e.setExpToDrop(0);
        Location loc = block.getLocation();
        for (ItemStack st : drops) {
            if (this.isEmpty(st)) continue;
            this.giveToPlayerThenShulkersThenDrop(player, st, loc);
        }
        this.startReplantTask(block, plantType);
    }

    private void handleColumnPlantBreak(BlockBreakEvent e, Player player, Block broken, Material plantType) {
        if (broken == null || player == null) {
            return;
        }
        if (broken.getType() != plantType) {
            return;
        }
        boolean single = broken.getRelative(BlockFace.UP).getType() != plantType && broken.getRelative(BlockFace.DOWN).getType() != plantType;
        boolean isBase = this.isColumnBase(broken, plantType);
        boolean canReplant = isBase && !single && this.canReplantBase(broken, plantType);
        ArrayList<Block> toRemove = new ArrayList<Block>();
        Block cur = broken;
        while (cur.getType() == plantType) {
            toRemove.add(cur);
            cur = cur.getRelative(BlockFace.UP);
        }
        if (plantType == Material.CACTUS && cur.getType() == Material.CACTUS_FLOWER) {
            toRemove.add(cur);
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Block b : toRemove) {
            Collection dc = b.getDrops(tool, (Entity)player);
            if (dc == null) continue;
            for (ItemStack st : dc) {
                if (this.isEmpty(st)) continue;
                drops.add(st.clone());
            }
        }
        boolean willReplant = false;
        if (canReplant) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                willReplant = true;
            } else {
                boolean paid = this.removeOneFromDrops(drops, plantType);
                if (!paid) {
                    paid = this.takeOneFromInventory(player, plantType);
                }
                willReplant = paid;
            }
        }
        e.setCancelled(true);
        for (int i = toRemove.size() - 1; i >= 0; --i) {
            ((Block)toRemove.get(i)).setType(Material.AIR, true);
        }
        Location dropAt = plantType == Material.CACTUS ? player.getLocation() : broken.getLocation();
        for (ItemStack st : drops) {
            if (this.isEmpty(st)) continue;
            this.giveToPlayerThenShulkersThenDrop(player, st, dropAt);
        }
        if (willReplant) {
            this.startReplantTask(broken, plantType);
        }
    }

    private boolean isColumnBase(Block b, Material type) {
        if (b == null) {
            return false;
        }
        Block below = b.getRelative(BlockFace.DOWN);
        return below.getType() != type;
    }

    private boolean canReplantBase(Block base, Material type) {
        if (base == null) {
            return false;
        }
        if (type == Material.SUGAR_CANE) {
            return this.canReplantSugarCaneBase(base);
        }
        if (type == Material.CACTUS) {
            return this.canReplantCactusBase(base);
        }
        return false;
    }

    private boolean canReplantSugarCaneBase(Block base) {
        Waterlogged wl;
        Block below = base.getRelative(BlockFace.DOWN);
        Material soil = below.getType();
        if (soil != Material.SAND && soil != Material.RED_SAND && soil != Material.DIRT && soil != Material.GRASS_BLOCK && soil != Material.COARSE_DIRT && soil != Material.PODZOL && soil != Material.ROOTED_DIRT && soil != Material.MUD && soil != Material.MYCELIUM && soil != Material.MOSS_BLOCK) {
            return false;
        }
        BlockData bd = below.getBlockData();
        if (bd instanceof Waterlogged && (wl = (Waterlogged)bd).isWaterlogged()) {
            return false;
        }
        return this.isWaterLike(below.getRelative(BlockFace.NORTH)) || this.isWaterLike(below.getRelative(BlockFace.SOUTH)) || this.isWaterLike(below.getRelative(BlockFace.EAST)) || this.isWaterLike(below.getRelative(BlockFace.WEST));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSugarCanePlaceInWater(BlockPlaceEvent e) {
        if (e == null) {
            return;
        }
        Block placed = e.getBlockPlaced();
        if (placed == null) {
            return;
        }
        if (placed.getType() != Material.SUGAR_CANE) {
            return;
        }
        BlockState replaced = e.getBlockReplacedState();
        if (replaced == null) {
            return;
        }
        Material rt = replaced.getType();
        if (rt == Material.WATER || rt == Material.BUBBLE_COLUMN) {
            e.setCancelled(true);
            return;
        }
        if (rt == Material.SEAGRASS || rt == Material.TALL_SEAGRASS || rt == Material.KELP || rt == Material.KELP_PLANT) {
            e.setCancelled(true);
            return;
        }
        try {
            Waterlogged wl;
            BlockData bd = replaced.getBlockData();
            if (bd instanceof Waterlogged && (wl = (Waterlogged)bd).isWaterlogged()) {
                e.setCancelled(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isWaterLike(Block b) {
        Waterlogged wl;
        if (b == null) {
            return false;
        }
        Material t = b.getType();
        if (t == Material.WATER) {
            return true;
        }
        BlockData bd = b.getBlockData();
        return bd instanceof Waterlogged && (wl = (Waterlogged)bd).isWaterlogged();
    }

    private boolean canReplantCactusBase(Block base) {
        Block below = base.getRelative(BlockFace.DOWN);
        Material soil = below.getType();
        if (soil != Material.SAND && soil != Material.RED_SAND) {
            return false;
        }
        if (!this.isCactusSideOk(base.getRelative(BlockFace.NORTH))) {
            return false;
        }
        if (!this.isCactusSideOk(base.getRelative(BlockFace.SOUTH))) {
            return false;
        }
        if (!this.isCactusSideOk(base.getRelative(BlockFace.EAST))) {
            return false;
        }
        return this.isCactusSideOk(base.getRelative(BlockFace.WEST));
    }

    private boolean isCactusSideOk(Block side) {
        if (side == null) {
            return false;
        }
        Material t = side.getType();
        return t.isAir() || t == Material.CACTUS_FLOWER;
    }

    private void startReplantTask(Block brokenBase, Material plantType) {
        if (brokenBase == null) {
            return;
        }
        long key = this.blockKey(brokenBase);
        if (!this.replantPending.add(key)) {
            return;
        }
        Location at = brokenBase.getLocation();
        UUID wid = brokenBase.getWorld().getUID();
        int x = brokenBase.getX();
        int y = brokenBase.getY();
        int z = brokenBase.getZ();
        int[] triesLeft = new int[]{this.replantTries};
        ScheduledTask task = Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this, at, t -> {
            if (!this.autoPlant) {
                this.replantPending.remove(key);
                this.replantTasks.remove(key);
                t.cancel();
                return;
            }
            World w = Bukkit.getWorld((UUID)wid);
            if (w == null) {
                this.replantPending.remove(key);
                this.replantTasks.remove(key);
                t.cancel();
                return;
            }
            if (this.tryReplantAt(w, x, y, z, plantType)) {
                this.replantPending.remove(key);
                this.replantTasks.remove(key);
                t.cancel();
                return;
            }
            triesLeft[0] = triesLeft[0] - 1;
            if (triesLeft[0] <= 0) {
                this.replantPending.remove(key);
                this.replantTasks.remove(key);
                t.cancel();
            }
        }, 1L, 1L);
        this.replantTasks.put(key, task);
    }

    private boolean tryReplantAt(World w, int x, int y, int z, Material plantType) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            return false;
        }
        Block b = w.getBlockAt(x, y, z);
        Material current = b.getType();
        if (current == plantType) {
            return true;
        }
        if (!current.isAir()) {
            return false;
        }
        if (plantType == Material.SUGAR_CANE) {
            if (!this.canReplantSugarCaneBase(b)) {
                return false;
            }
            b.setType(Material.SUGAR_CANE, false);
            return true;
        }
        if (plantType == Material.CACTUS) {
            if (!this.canReplantCactusBase(b)) {
                return false;
            }
            b.setType(Material.CACTUS, false);
            return true;
        }
        Material soil = b.getRelative(0, -1, 0).getType();
        if (plantType == Material.NETHER_WART ? soil != Material.SOUL_SAND : soil != Material.FARMLAND) {
            return false;
        }
        b.setType(plantType, false);
        BlockData bd = b.getBlockData();
        if (bd instanceof Ageable) {
            Ageable a = (Ageable)bd;
            a.setAge(0);
            b.setBlockData((BlockData)a, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBonemealPlayer(PlayerInteractEvent e) {
        long key;
        ItemStack main;
        if (!this.bonemealMaxGrow) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EquipmentSlot hand = e.getHand();
        if (hand == null) {
            return;
        }
        Player player = e.getPlayer();
        if (player == null) {
            return;
        }
        if (hand == EquipmentSlot.OFF_HAND && !this.isEmpty(main = player.getInventory().getItemInMainHand()) && main.getType() == Material.BONE_MEAL) {
            return;
        }
        ItemStack item = e.getItem();
        if (this.isEmpty(item)) {
            return;
        }
        if (item.getType() != Material.BONE_MEAL) {
            return;
        }
        Block clicked = e.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (this.shouldSkipBonemealOverride(clicked)) {
            return;
        }
        BlockFace face = e.getBlockFace();
        if (face == null) {
            face = BlockFace.UP;
        }
        if (!this.bonemealPending.add(key = this.blockKey(clicked))) {
            return;
        }
        try {
            List<Block> targets = this.resolveBonemealTargets(clicked, face);
            if (targets.isEmpty()) {
                return;
            }
            boolean anyChanged = false;
            for (Block b : targets) {
                BlockFace useFace;
                boolean changed;
                if (b == null || this.shouldSkipBonemealOverride(b) || this.isBonemealAlreadyMax(b) || !(changed = this.applyBonemealMax(b, useFace = this.blockKey(b) == this.blockKey(clicked) ? face : BlockFace.UP))) continue;
                anyChanged = true;
            }
            if (!anyChanged) {
                return;
            }
            e.setCancelled(true);
            if (player.getGameMode() != GameMode.CREATIVE) {
                this.takeOneFromHand(player, hand);
            }
            clicked.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, clicked.getLocation().add(0.5, 0.7, 0.5), 12, 0.35, 0.35, 0.35, 0.0);
            Sound s = this.soundByKey("item.bone_meal.use");
            if (s != null) {
                clicked.getWorld().playSound(clicked.getLocation(), s, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        finally {
            this.bonemealPending.remove(key);
        }
    }

    private boolean shouldSkipBonemealOverride(Block b) {
        if (b == null) {
            return true;
        }
        Material t = b.getType();
        if (t == null || t.isAir()) {
            return true;
        }
        if (BONEMEAL_OVERRIDE_BLOCKED.contains(t)) {
            return true;
        }
        String n = t.name();
        if (n.endsWith("SHULKER_BOX")) {
            return true;
        }
        if (n.endsWith("_DOOR")) {
            return true;
        }
        if (n.endsWith("_TRAPDOOR")) {
            return true;
        }
        if (n.endsWith("_FENCE_GATE")) {
            return true;
        }
        if (n.endsWith("_BUTTON")) {
            return true;
        }
        if (n.endsWith("_BED")) {
            return true;
        }
        if (n.endsWith("_SIGN")) {
            return true;
        }
        if (n.endsWith("_HANGING_SIGN")) {
            return true;
        }
        if (t == Material.LEVER) {
            return true;
        }
        if (t == Material.REPEATER) {
            return true;
        }
        if (t == Material.COMPARATOR) {
            return true;
        }
        return t == Material.DAYLIGHT_DETECTOR;
    }

    private List<Block> resolveBonemealTargets(Block source, BlockFace hitFace) {
        BlockFace[] around;
        if (source == null) {
            return List.of();
        }
        if (this.isDirectBonemealTarget(source)) {
            return List.of(source);
        }
        LinkedHashMap<Long, Block> out = new LinkedHashMap<Long, Block>();
        this.tryAddBonemealTarget(out, source);
        this.tryAddBonemealTarget(out, source.getRelative(BlockFace.UP));
        for (BlockFace f : around = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
            Block candidate = source.getRelative(f);
            if (candidate == null || !this.isAttachedBonemealTargetTo(source, candidate)) continue;
            this.tryAddBonemealTarget(out, candidate);
        }
        return new ArrayList<Block>(out.values());
    }

    private void tryAddBonemealTarget(LinkedHashMap<Long, Block> map, Block b) {
        if (map == null) {
            return;
        }
        if (b == null) {
            return;
        }
        if (this.shouldSkipBonemealOverride(b)) {
            return;
        }
        map.putIfAbsent(this.blockKey(b), b);
    }

    private boolean isAttachedBonemealTargetTo(Block support, Block candidate) {
        BlockData bd;
        if (support == null || candidate == null) {
            return false;
        }
        Material ct = candidate.getType();
        try {
            bd = candidate.getBlockData();
        }
        catch (Throwable ignored) {
            return false;
        }
        boolean bonemealCandidate = bd instanceof Ageable;
        if (!(bonemealCandidate || ct != Material.CAVE_VINES && ct != Material.CAVE_VINES_PLANT)) {
            bonemealCandidate = true;
        }
        if (!bonemealCandidate) {
            return false;
        }
        if (bd instanceof Directional) {
            BlockFace f;
            Directional dir = (Directional)bd;
            try {
                f = dir.getFacing();
            }
            catch (Throwable ignored) {
                f = null;
            }
            if (f != null) {
                try {
                    Block a = candidate.getRelative(f.getOppositeFace());
                    if (a != null && this.blockKey(a) == this.blockKey(support)) {
                        return true;
                    }
                    Block b = candidate.getRelative(f);
                    if (b != null && this.blockKey(b) == this.blockKey(support)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (ct == Material.CAVE_VINES || ct == Material.CAVE_VINES_PLANT) {
            try {
                Block up = candidate.getRelative(BlockFace.UP);
                return up != null && this.blockKey(up) == this.blockKey(support);
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        return false;
    }

    private boolean isDirectBonemealTarget(Block b) {
        if (b == null) {
            return false;
        }
        Material t = b.getType();
        if (t == Material.SUGAR_CANE) {
            return true;
        }
        if (t == Material.CACTUS) {
            return true;
        }
        if (t == Material.BAMBOO) {
            return true;
        }
        if (t == Material.BAMBOO_SAPLING) {
            return true;
        }
        try {
            BlockData bd = b.getBlockData();
            return bd instanceof Ageable;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBonemealDispenser(BlockDispenseEvent e) {
        if (!this.bonemealMaxGrow) {
            return;
        }
        ItemStack item = e.getItem();
        if (this.isEmpty(item)) {
            return;
        }
        if (item.getType() != Material.BONE_MEAL) {
            return;
        }
        Block src = e.getBlock();
        if (src == null) {
            return;
        }
        if (src.getType() != Material.DISPENSER) {
            return;
        }
        BlockData bd = src.getBlockData();
        if (!(bd instanceof Directional)) {
            return;
        }
        Directional d = (Directional)bd;
        BlockFace out = d.getFacing();
        Block target = src.getRelative(out);
        if (target == null) {
            return;
        }
        if (this.shouldSkipBonemealOverride(target)) {
            return;
        }
        long key = this.blockKey(target);
        if (!this.bonemealPending.add(key)) {
            return;
        }
        e.setCancelled(true);
        UUID wid = src.getWorld().getUID();
        int sx = src.getX();
        int sy = src.getY();
        int sz = src.getZ();
        int tx = target.getX();
        int ty = target.getY();
        int tz = target.getZ();
        BlockFace hitFace = out.getOppositeFace();
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, src.getLocation(), t -> {
            try {
                if (!this.bonemealMaxGrow) {
                    return;
                }
                World w = Bukkit.getWorld((UUID)wid);
                if (w == null) {
                    return;
                }
                int scx = sx >> 4;
                int scz = sz >> 4;
                if (!w.isChunkLoaded(scx, scz)) {
                    return;
                }
                Block dispBlock = w.getBlockAt(sx, sy, sz);
                if (dispBlock.getType() != Material.DISPENSER) {
                    return;
                }
                BlockState patt0$temp = dispBlock.getState();
                if (!(patt0$temp instanceof Dispenser)) {
                    return;
                }
                Dispenser disp = (Dispenser)patt0$temp;
                Inventory inv = disp.getSnapshotInventory();
                boolean consumed = this.consumeOneFromDispenser(inv, Material.BONE_MEAL);
                if (!consumed) {
                    return;
                }
                disp.update(true, false);
                int tcx = tx >> 4;
                int tcz = tz >> 4;
                if (!w.isChunkLoaded(tcx, tcz)) {
                    return;
                }
                Block base = w.getBlockAt(tx, ty, tz);
                List<Block> targets = this.resolveBonemealTargets(base, hitFace);
                boolean anyChanged = false;
                for (Block b : targets) {
                    BlockFace useFace;
                    boolean changed;
                    if (b == null || this.shouldSkipBonemealOverride(b) || this.isBonemealAlreadyMax(b) || !(changed = this.applyBonemealMax(b, useFace = this.blockKey(b) == this.blockKey(base) ? hitFace : BlockFace.UP))) continue;
                    anyChanged = true;
                }
                if (anyChanged) {
                    base.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, base.getLocation().add(0.5, 0.7, 0.5), 12, 0.35, 0.35, 0.35, 0.0);
                    Sound s = this.soundByKey("item.bone_meal.use");
                    if (s != null) {
                        base.getWorld().playSound(base.getLocation(), s, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    Location dropLoc = dispBlock.getLocation().add(0.5 + (double)out.getModX() * 0.7, 0.5 + (double)out.getModY() * 0.7, 0.5 + (double)out.getModZ() * 0.7);
                    ItemStack drop = new ItemStack(Material.BONE_MEAL, 1);
                    try {
                        Item ent = w.dropItem(dropLoc, drop);
                        ent.setVelocity(new Vector((double)out.getModX() * 0.2, (double)out.getModY() * 0.2, (double)out.getModZ() * 0.2));
                    }
                    catch (Throwable ignored) {
                        w.dropItemNaturally(dropLoc, drop);
                    }
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.bonemealPending.remove(key);
            }
        }, 1L);
    }

    private boolean consumeOneFromDispenser(Inventory inv, Material type) {
        if (inv == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack st = inv.getItem(i);
            if (this.isEmpty(st) || st.getType() != type) continue;
            int amt = st.getAmount();
            if (amt <= 1) {
                inv.setItem(i, null);
            } else {
                ItemStack ns = st.clone();
                ns.setAmount(amt - 1);
                inv.setItem(i, ns);
            }
            return true;
        }
        return false;
    }

    private boolean isBonemealAlreadyMax(Block b) {
        Material type = b.getType();
        if (type == Material.TORCHFLOWER) {
            return true;
        }
        if (type == Material.PITCHER_PLANT) {
            return true;
        }
        if (type == Material.MELON_STEM || type == Material.ATTACHED_MELON_STEM) {
            return this.isStemFruitPresent(b, Material.MELON);
        }
        if (type == Material.PUMPKIN_STEM || type == Material.ATTACHED_PUMPKIN_STEM) {
            return this.isStemFruitPresent(b, Material.PUMPKIN);
        }
        if (type == Material.SUGAR_CANE) {
            return !this.canGrowSugarCane(b, this.bonemealSugarCaneCap);
        }
        if (type == Material.CACTUS) {
            return !this.canGrowCactus(b, this.bonemealCactusCap);
        }
        if (type == Material.BAMBOO || type == Material.BAMBOO_SAPLING) {
            return this.getBambooHeight(b) >= this.bonemealBambooCap;
        }
        BlockData bd = b.getBlockData();
        if (bd instanceof Ageable) {
            Ageable age = (Ageable)bd;
            return age.getAge() >= age.getMaximumAge();
        }
        return false;
    }

    private boolean applyBonemealMax(Block b, BlockFace face) {
        if (b == null) {
            return false;
        }
        Material type = b.getType();
        if (type == Material.TORCHFLOWER_CROP) {
            b.setType(Material.TORCHFLOWER, false);
            return true;
        }
        if (type == Material.PITCHER_CROP) {
            return this.growPitcherPlant(b);
        }
        if (type == Material.MELON_STEM || type == Material.ATTACHED_MELON_STEM) {
            return this.forceGrowStemFruit(b, Material.MELON, Material.ATTACHED_MELON_STEM);
        }
        if (type == Material.PUMPKIN_STEM || type == Material.ATTACHED_PUMPKIN_STEM) {
            return this.forceGrowStemFruit(b, Material.PUMPKIN, Material.ATTACHED_PUMPKIN_STEM);
        }
        if (type == Material.SUGAR_CANE) {
            return this.growSugarCaneToCap(b, this.bonemealSugarCaneCap);
        }
        if (type == Material.CACTUS) {
            return this.growCactusToCap(b, this.bonemealCactusCap);
        }
        if (type == Material.BAMBOO || type == Material.BAMBOO_SAPLING) {
            return this.growBambooToCap(b, this.bonemealBambooCap);
        }
        if (type.name().endsWith("_SAPLING")) {
            return this.growSaplingAsTree(b);
        }
        BlockData bd = b.getBlockData();
        if (bd instanceof Ageable) {
            Ageable age = (Ageable)bd;
            if (age.getAge() >= age.getMaximumAge()) {
                return false;
            }
            age.setAge(age.getMaximumAge());
            b.setBlockData((BlockData)age, false);
            return true;
        }
        return false;
    }

    private boolean isStemFruitPresent(Block stem, Material fruit) {
        if (stem == null || fruit == null) {
            return false;
        }
        if (stem.getRelative(BlockFace.NORTH).getType() == fruit) {
            return true;
        }
        if (stem.getRelative(BlockFace.SOUTH).getType() == fruit) {
            return true;
        }
        if (stem.getRelative(BlockFace.EAST).getType() == fruit) {
            return true;
        }
        return stem.getRelative(BlockFace.WEST).getType() == fruit;
    }

    private void restoreClearedIfStillAir(World w, Iterable<SavedBlock> cleared) {
        for (SavedBlock sb : cleared) {
            Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
            if (!at.getType().isAir()) continue;
            at.setBlockData(sb.data(), false);
        }
    }

    private boolean growSaplingAsTree(Block b) {
        Material type = b.getType();
        TreeType mega2x2 = this.get2x2TreeType(type);
        TreeType baseType = SAPLING_TREE_TYPES.get(type);
        if (mega2x2 != null) {
            List<Block> corners = this.find2x2SaplingCorners(b, type);
            if (!corners.isEmpty()) {
                for (Block corner : corners) {
                    if (!this.tryGenerateTreeForced(corner, mega2x2, true)) continue;
                    return true;
                }
                return false;
            }
            if (this.is2x2OnlySapling(type)) {
                return false;
            }
            if (baseType == null) {
                return false;
            }
            return this.tryGenerateTreeForced(b, baseType, false);
        }
        if (baseType == null) {
            return false;
        }
        return this.tryGenerateTreeForced(b, baseType, false);
    }

    private boolean is2x2OnlySapling(Material sapling) {
        return sapling == Material.DARK_OAK_SAPLING || sapling == Material.PALE_OAK_SAPLING;
    }

    private TreeType get2x2TreeType(Material sapling) {
        if (sapling == Material.SPRUCE_SAPLING) {
            return ThreadLocalRandom.current().nextBoolean() ? TreeType.MEGA_REDWOOD : TreeType.MEGA_PINE;
        }
        if (sapling == Material.JUNGLE_SAPLING) {
            return TreeType.JUNGLE;
        }
        if (sapling == Material.DARK_OAK_SAPLING) {
            return TreeType.DARK_OAK;
        }
        if (sapling == Material.PALE_OAK_SAPLING) {
            return TreeType.PALE_OAK;
        }
        return null;
    }

    private boolean tryGenerateTreeForced(Block corner, TreeType treeType, boolean is2x2) {
        int clearRadius;
        if (this.tryGenerateTreeOnce(corner, treeType, is2x2, 0, false, false)) {
            return true;
        }
        int n = clearRadius = is2x2 ? 2 : 1;
        if (this.tryGenerateTreeOnce(corner, treeType, is2x2, clearRadius, false, false)) {
            return true;
        }
        if (is2x2) {
            if (this.tryGenerateTreeOnce(corner, treeType, true, clearRadius, true, false)) {
                return true;
            }
            return this.tryGenerateTreeOnce(corner, treeType, true, clearRadius, true, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryGenerateTreeOnce(Block corner, TreeType treeType, boolean is2x2, int extraSaplingClearRadius, boolean clearCanopySpace, boolean clearHardOverlapBlocks) {
        boolean r222;
        block65: {
            Long2ObjectOpenHashMap protectedSaplings;
            Long2ObjectOpenHashMap canopyCleared;
            ObjectArrayList extraClearedSaplings;
            BlockData savedS;
            BlockData savedSW;
            BlockData savedSE;
            Block s;
            Block sw;
            Block se;
            BlockData savedNW;
            boolean success;
            World w;
            block63: {
                boolean r222;
                block64: {
                    if (corner == null || treeType == null) {
                        return false;
                    }
                    w = corner.getWorld();
                    int y = corner.getY();
                    int cx = corner.getX();
                    int cz = corner.getZ();
                    int fx0 = cx;
                    int fx1 = cx + (is2x2 ? 1 : 0);
                    int fz0 = cz;
                    int fz1 = cz + (is2x2 ? 1 : 0);
                    success = false;
                    savedNW = corner.getBlockData();
                    se = corner.getRelative(1, 0, 0);
                    sw = corner.getRelative(0, 0, 1);
                    s = corner.getRelative(1, 0, 1);
                    savedSE = null;
                    savedSW = null;
                    savedS = null;
                    if (is2x2) {
                        savedSE = se.getBlockData();
                        savedSW = sw.getBlockData();
                        savedS = s.getBlockData();
                    }
                    extraClearedSaplings = new ObjectArrayList();
                    canopyCleared = new Long2ObjectOpenHashMap();
                    protectedSaplings = new Long2ObjectOpenHashMap(256);
                    int protectRadius = treeType == TreeType.JUNGLE ? 5 : (is2x2 ? 3 : 2);
                    this.collectProtectedSaplings(w, fx0, fx1, fz0, fz1, y, protectRadius, (Long2ObjectOpenHashMap<SavedBlock>)protectedSaplings);
                    corner.setType(Material.AIR, false);
                    if (is2x2) {
                        se.setType(Material.AIR, false);
                        sw.setType(Material.AIR, false);
                        s.setType(Material.AIR, false);
                    }
                    if (extraSaplingClearRadius > 0) {
                        int minX = cx - extraSaplingClearRadius;
                        int maxX = cx + (is2x2 ? 1 : 0) + extraSaplingClearRadius;
                        int minZ = cz - extraSaplingClearRadius;
                        int maxZ = cz + (is2x2 ? 1 : 0) + extraSaplingClearRadius;
                        for (int x = minX; x <= maxX; ++x) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                Block at;
                                Material t;
                                boolean inFootprint;
                                boolean bl = inFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                                if (inFootprint || !this.isSaplingMaterial(t = (at = w.getBlockAt(x, y, z)).getType())) continue;
                                extraClearedSaplings.add((Object)new SavedBlock(x, y, z, at.getBlockData()));
                                at.setType(Material.AIR, false);
                            }
                        }
                    }
                    if (clearCanopySpace) {
                        int z;
                        int x;
                        int yy;
                        int r222 = this.overlapRadiusFor(treeType);
                        int h = this.overlapHeightFor(treeType);
                        int minX = cx - r222;
                        int maxX = cx + (is2x2 ? 1 : 0) + r222;
                        int minZ = cz - r222;
                        int maxZ = cz + (is2x2 ? 1 : 0) + r222;
                        int maxY = Math.min(w.getMaxHeight() - 1, y + h);
                        if (clearHardOverlapBlocks) {
                            int hr = this.hardOverlapRadiusFor(treeType);
                            int hMinX = cx - hr;
                            int hMaxX = cx + (is2x2 ? 1 : 0) + hr;
                            int hMinZ = cz - hr;
                            int hMaxZ = cz + (is2x2 ? 1 : 0) + hr;
                            int baseTop = Math.min(maxY, y + 2);
                            for (yy = y; yy <= baseTop; ++yy) {
                                for (x = hMinX; x <= hMaxX; ++x) {
                                    for (z = hMinZ; z <= hMaxZ; ++z) {
                                        Block at;
                                        Material m;
                                        boolean inFootprint;
                                        boolean bl = inFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                                        if (inFootprint || (m = (at = w.getBlockAt(x, yy, z)).getType()).isAir() || !this.isBaseHardClearableForOverlap(m)) continue;
                                        long key = this.blockKey(at);
                                        if (!canopyCleared.containsKey(key)) {
                                            canopyCleared.put(key, (Object)new SavedBlock(x, yy, z, at.getBlockData()));
                                            at.setType(Material.AIR, false);
                                            continue;
                                        }
                                        at.setType(Material.AIR, false);
                                    }
                                }
                            }
                        }
                        for (int yy2 = y + 1; yy2 <= maxY; ++yy2) {
                            for (int x2 = minX; x2 <= maxX; ++x2) {
                                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                                    Block at = w.getBlockAt(x2, yy2, z2);
                                    Material m = at.getType();
                                    if (m.isAir() || !this.isSoftClearableForOverlap(m)) continue;
                                    long key = this.blockKey(at);
                                    if (!canopyCleared.containsKey(key)) {
                                        canopyCleared.put(key, (Object)new SavedBlock(x2, yy2, z2, at.getBlockData()));
                                        at.setType(Material.AIR, false);
                                        continue;
                                    }
                                    at.setType(Material.AIR, false);
                                }
                            }
                        }
                        if (clearHardOverlapBlocks) {
                            int hr = this.hardOverlapRadiusFor(treeType);
                            int hardMinY = y + this.hardClearMinYOffsetFor(treeType);
                            int hMinX = cx - hr;
                            int hMaxX = cx + (is2x2 ? 1 : 0) + hr;
                            int hMinZ = cz - hr;
                            int hMaxZ = cz + (is2x2 ? 1 : 0) + hr;
                            for (yy = Math.max(hardMinY, y); yy <= maxY; ++yy) {
                                for (x = hMinX; x <= hMaxX; ++x) {
                                    for (z = hMinZ; z <= hMaxZ; ++z) {
                                        Block at = w.getBlockAt(x, yy, z);
                                        Material m = at.getType();
                                        if (m.isAir() || !this.isHardClearableForOverlap(m)) continue;
                                        long key = this.blockKey(at);
                                        if (!canopyCleared.containsKey(key)) {
                                            canopyCleared.put(key, (Object)new SavedBlock(x, yy, z, at.getBlockData()));
                                            at.setType(Material.AIR, false);
                                            continue;
                                        }
                                        at.setType(Material.AIR, false);
                                    }
                                }
                            }
                        }
                    }
                    Object r222 = TREE_GEN_LOCK;
                    synchronized (r222) {
                        success = w.generateTree(corner.getLocation(), (Random)ThreadLocalRandom.current(), treeType);
                    }
                    if (!success) {
                        if (!corner.getType().isAir()) {
                            success = true;
                        }
                        if (!(!is2x2 || se.getType().isAir() && sw.getType().isAir() && s.getType().isAir())) {
                            success = true;
                        }
                    }
                    if (success) break block63;
                    r222 = false;
                    if (success) break block64;
                    if (corner.getType().isAir()) {
                        corner.setBlockData(savedNW, false);
                    }
                    if (is2x2) {
                        if (se.getType().isAir()) {
                            se.setBlockData(savedSE, false);
                        }
                        if (sw.getType().isAir()) {
                            sw.setBlockData(savedSW, false);
                        }
                        if (s.getType().isAir()) {
                            s.setBlockData(savedS, false);
                        }
                    }
                    for (SavedBlock sb : extraClearedSaplings) {
                        Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                        if (!at.getType().isAir()) continue;
                        at.setBlockData(sb.data(), false);
                    }
                    for (SavedBlock sb : canopyCleared.values()) {
                        Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                        if (!at.getType().isAir()) continue;
                        at.setBlockData(sb.data(), false);
                    }
                }
                return r222;
            }
            try {
                for (SavedBlock sb : protectedSaplings.values()) {
                    Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                    Material cur = at.getType();
                    if (!this.canOverwriteToRestoreSapling(cur)) continue;
                    at.setBlockData(sb.data(), false);
                }
                for (SavedBlock sb : extraClearedSaplings) {
                    Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                    Material cur = at.getType();
                    if (!this.canOverwriteToRestoreSapling(cur)) continue;
                    at.setBlockData(sb.data(), false);
                }
                this.restoreClearedIfStillAir(w, (Iterable<SavedBlock>)canopyCleared.values());
                r222 = true;
                if (success) break block65;
            }
            catch (Throwable ignored) {
                boolean bl;
                block66: {
                    try {
                        bl = false;
                        if (success) break block66;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            Block at;
                            if (corner.getType().isAir()) {
                                corner.setBlockData(savedNW, false);
                            }
                            if (is2x2) {
                                if (se.getType().isAir()) {
                                    se.setBlockData(savedSE, false);
                                }
                                if (sw.getType().isAir()) {
                                    sw.setBlockData(savedSW, false);
                                }
                                if (s.getType().isAir()) {
                                    s.setBlockData(savedS, false);
                                }
                            }
                            for (SavedBlock sb : extraClearedSaplings) {
                                at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                                if (!at.getType().isAir()) continue;
                                at.setBlockData(sb.data(), false);
                            }
                            for (SavedBlock sb : canopyCleared.values()) {
                                at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                                if (!at.getType().isAir()) continue;
                                at.setBlockData(sb.data(), false);
                            }
                        }
                        throw throwable;
                    }
                    if (corner.getType().isAir()) {
                        corner.setBlockData(savedNW, false);
                    }
                    if (is2x2) {
                        if (se.getType().isAir()) {
                            se.setBlockData(savedSE, false);
                        }
                        if (sw.getType().isAir()) {
                            sw.setBlockData(savedSW, false);
                        }
                        if (s.getType().isAir()) {
                            s.setBlockData(savedS, false);
                        }
                    }
                    for (SavedBlock sb : extraClearedSaplings) {
                        Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                        if (!at.getType().isAir()) continue;
                        at.setBlockData(sb.data(), false);
                    }
                    for (SavedBlock sb : canopyCleared.values()) {
                        Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                        if (!at.getType().isAir()) continue;
                        at.setBlockData(sb.data(), false);
                    }
                }
                return bl;
            }
            if (corner.getType().isAir()) {
                corner.setBlockData(savedNW, false);
            }
            if (is2x2) {
                if (se.getType().isAir()) {
                    se.setBlockData(savedSE, false);
                }
                if (sw.getType().isAir()) {
                    sw.setBlockData(savedSW, false);
                }
                if (s.getType().isAir()) {
                    s.setBlockData(savedS, false);
                }
            }
            for (SavedBlock sb : extraClearedSaplings) {
                Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                if (!at.getType().isAir()) continue;
                at.setBlockData(sb.data(), false);
            }
            for (SavedBlock sb : canopyCleared.values()) {
                Block at = w.getBlockAt(sb.x(), sb.y(), sb.z());
                if (!at.getType().isAir()) continue;
                at.setBlockData(sb.data(), false);
            }
        }
        return r222;
    }

    private void collectProtectedSaplings(World w, int fx0, int fx1, int fz0, int fz1, int y, int radius, Long2ObjectOpenHashMap<SavedBlock> out) {
        int minX = fx0 - radius;
        int maxX = fx1 + radius;
        int minZ = fz0 - radius;
        int maxZ = fz1 + radius;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                long key;
                Block at;
                Material m;
                boolean inFootprint;
                boolean bl = inFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                if (inFootprint || !this.isSaplingMaterial(m = (at = w.getBlockAt(x, y, z)).getType()) || out.containsKey(key = this.blockKey(at))) continue;
                out.put(key, (Object)new SavedBlock(x, y, z, at.getBlockData()));
            }
        }
    }

    private boolean isSaplingMaterial(Material m) {
        if (m == null) {
            return false;
        }
        if (m == Material.BAMBOO_SAPLING) {
            return true;
        }
        return m.name().endsWith("_SAPLING");
    }

    private boolean canOverwriteToRestoreSapling(Material m) {
        if (m == null) {
            return false;
        }
        if (m.isAir()) {
            return true;
        }
        if (this.isBottomDecorationThatMayReplaceSaplings(m)) {
            return true;
        }
        if (Tag.LEAVES.isTagged((Keyed)m)) {
            return true;
        }
        if (Tag.REPLACEABLE_BY_TREES.isTagged((Keyed)m)) {
            return true;
        }
        if (m == Material.GLOW_LICHEN) {
            return true;
        }
        return m == Material.COCOA;
    }

    private boolean isSoftClearableForOverlap(Material m) {
        return Tag.REPLACEABLE_BY_TREES.isTagged((Keyed)m) || Tag.LEAVES.isTagged((Keyed)m) || m == Material.VINE || m == Material.GLOW_LICHEN || m == Material.PALE_HANGING_MOSS || m == Material.COCOA;
    }

    private boolean isHardClearableForOverlap(Material m) {
        return Tag.LOGS.isTagged((Keyed)m);
    }

    private boolean isBaseHardClearableForOverlap(Material m) {
        return this.isSoftClearableForOverlap(m) || this.isHardClearableForOverlap(m);
    }

    private int hardOverlapRadiusFor(TreeType type) {
        return switch (type) {
            case TreeType.JUNGLE -> 6;
            case TreeType.MEGA_REDWOOD, TreeType.MEGA_PINE -> 3;
            case TreeType.DARK_OAK -> 2;
            case TreeType.PALE_OAK -> 2;
            default -> 2;
        };
    }

    private int hardClearMinYOffsetFor(TreeType type) {
        return switch (type) {
            case TreeType.JUNGLE -> 0;
            case TreeType.MEGA_REDWOOD, TreeType.MEGA_PINE -> 4;
            default -> 3;
        };
    }

    private boolean isBottomDecorationThatMayReplaceSaplings(Material m) {
        return m == Material.VINE || m == Material.PALE_HANGING_MOSS;
    }

    private int overlapRadiusFor(TreeType type) {
        return switch (type) {
            case TreeType.JUNGLE -> 10;
            case TreeType.MEGA_REDWOOD, TreeType.MEGA_PINE -> 6;
            case TreeType.DARK_OAK -> 5;
            case TreeType.PALE_OAK -> 5;
            default -> 4;
        };
    }

    private int overlapHeightFor(TreeType type) {
        return switch (type) {
            case TreeType.JUNGLE -> 60;
            case TreeType.MEGA_REDWOOD, TreeType.MEGA_PINE -> 40;
            case TreeType.DARK_OAK -> 20;
            case TreeType.PALE_OAK -> 22;
            default -> 20;
        };
    }

    private List<Block> find2x2SaplingCorners(Block b, Material type) {
        if (b == null || type == null) {
            return List.of();
        }
        World w = b.getWorld();
        int bx = b.getX();
        int by = b.getY();
        int bz = b.getZ();
        int[][] nwOffsets = new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}};
        LongOpenHashSet seen = new LongOpenHashSet(4);
        ObjectArrayList corners = new ObjectArrayList(4);
        for (int[] off : nwOffsets) {
            long key;
            Block nw = w.getBlockAt(bx + off[0], by, bz + off[1]);
            if (!this.is2x2Sapling(nw, type) || !seen.add(key = this.blockKey(nw))) continue;
            corners.add((Object)nw);
        }
        return corners;
    }

    private boolean is2x2Sapling(Block nw, Material type) {
        return nw.getType() == type && nw.getRelative(1, 0, 0).getType() == type && nw.getRelative(0, 0, 1).getType() == type && nw.getRelative(1, 0, 1).getType() == type;
    }

    private boolean forceGrowStemFruit(Block stem, Material fruitType, Material attachedStemType) {
        BlockFace[] faces;
        Ageable age;
        if (stem == null) {
            return false;
        }
        boolean changed = false;
        BlockData bd = stem.getBlockData();
        if (bd instanceof Ageable && (age = (Ageable)bd).getAge() < age.getMaximumAge()) {
            age.setAge(age.getMaximumAge());
            stem.setBlockData((BlockData)age, false);
            changed = true;
        }
        if (this.isStemFruitPresent(stem, fruitType)) {
            return changed;
        }
        for (BlockFace f : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block below;
            Material belowType;
            Block target = stem.getRelative(f);
            if (!target.getType().isAir() || (belowType = (below = target.getRelative(BlockFace.DOWN)).getType()).isAir() || belowType == Material.WATER || belowType == Material.LAVA) continue;
            target.setType(fruitType, false);
            stem.setType(attachedStemType, false);
            BlockData newBd = stem.getBlockData();
            if (newBd instanceof Directional) {
                Directional dir = (Directional)newBd;
                dir.setFacing(f);
                stem.setBlockData((BlockData)dir, false);
            }
            return true;
        }
        return changed;
    }

    private Block getColumnBase(Block any, Material type) {
        Block below;
        if (any == null) {
            return null;
        }
        Block cur = any;
        World w = cur.getWorld();
        int minY = w.getMinHeight();
        while (cur.getY() > minY && (below = cur.getRelative(BlockFace.DOWN)).getType() == type) {
            cur = below;
        }
        return cur;
    }

    private int getColumnHeight(Block base, Material type, int hardCap) {
        if (base == null) {
            return 0;
        }
        World w = base.getWorld();
        int maxY = w.getMaxHeight();
        int height = 0;
        Block cur = base;
        while (cur.getY() < maxY && cur.getType() == type && ++height < hardCap) {
            cur = cur.getRelative(BlockFace.UP);
        }
        return height;
    }

    private boolean canGrowSugarCane(Block any, int cap) {
        Block base = this.getColumnBase(any, Material.SUGAR_CANE);
        if (base == null) {
            return false;
        }
        int height = this.getColumnHeight(base, Material.SUGAR_CANE, cap);
        if (height >= cap) {
            return false;
        }
        Block placeAt = base.getRelative(0, height, 0);
        return placeAt.getType().isAir();
    }

    private boolean growSugarCaneToCap(Block any, int cap) {
        Block placeAt;
        Block base = this.getColumnBase(any, Material.SUGAR_CANE);
        if (base == null) {
            return false;
        }
        int before = this.getColumnHeight(base, Material.SUGAR_CANE, cap);
        if (before >= cap) {
            return false;
        }
        boolean changed = false;
        for (int i = before; i < cap && (placeAt = base.getRelative(0, i, 0)).getType().isAir(); ++i) {
            placeAt.setType(Material.SUGAR_CANE, false);
            changed = true;
        }
        return changed;
    }

    private boolean canGrowCactus(Block any, int cap) {
        Block base = this.getColumnBase(any, Material.CACTUS);
        if (base == null) {
            return false;
        }
        int height = this.getColumnHeight(base, Material.CACTUS, cap);
        if (height >= cap) {
            return false;
        }
        Block placeAt = base.getRelative(0, height, 0);
        return this.canPlaceCactus(placeAt);
    }

    private boolean growCactusToCap(Block any, int cap) {
        Block placeAt;
        Block base = this.getColumnBase(any, Material.CACTUS);
        if (base == null) {
            return false;
        }
        int before = this.getColumnHeight(base, Material.CACTUS, cap);
        if (before >= cap) {
            return false;
        }
        boolean changed = false;
        for (int i = before; i < cap && this.canPlaceCactus(placeAt = base.getRelative(0, i, 0)); ++i) {
            placeAt.setType(Material.CACTUS, false);
            changed = true;
        }
        return changed;
    }

    private boolean canPlaceCactus(Block b) {
        if (b == null) {
            return false;
        }
        if (!b.getType().isAir()) {
            return false;
        }
        Block below = b.getRelative(BlockFace.DOWN);
        Material belowType = below.getType();
        if (belowType != Material.CACTUS && belowType != Material.SAND && belowType != Material.RED_SAND) {
            return false;
        }
        if (!this.isCactusSideOk(b.getRelative(BlockFace.NORTH))) {
            return false;
        }
        if (!this.isCactusSideOk(b.getRelative(BlockFace.SOUTH))) {
            return false;
        }
        if (!this.isCactusSideOk(b.getRelative(BlockFace.EAST))) {
            return false;
        }
        return this.isCactusSideOk(b.getRelative(BlockFace.WEST));
    }

    private Block getBambooBaseBlock(Block any) {
        Block below;
        Material bt;
        if (any == null) {
            return null;
        }
        Material t = any.getType();
        if (t != Material.BAMBOO && t != Material.BAMBOO_SAPLING) {
            return any;
        }
        Block cur = any;
        World w = cur.getWorld();
        int minY = w.getMinHeight();
        while (cur.getY() > minY && ((bt = (below = cur.getRelative(BlockFace.DOWN)).getType()) == Material.BAMBOO || bt == Material.BAMBOO_SAPLING)) {
            cur = below;
        }
        return cur;
    }

    private int getBambooHeight(Block any) {
        Block cur;
        Material t;
        if (any == null) {
            return 0;
        }
        Block base = this.getBambooBaseBlock(any);
        if (base == null) {
            return 0;
        }
        World w = base.getWorld();
        int x = base.getX();
        int z = base.getZ();
        int height = 0;
        int maxY = w.getMaxHeight();
        for (int y = base.getY(); y < maxY && ((t = (cur = w.getBlockAt(x, y, z)).getType()) == Material.BAMBOO || t == Material.BAMBOO_SAPLING); ++y) {
            if (++height < 256) continue;
            break;
        }
        return height;
    }

    private boolean growBambooToCap(Block any, int cap) {
        Block placeAt;
        int height;
        if (any == null) {
            return false;
        }
        Material t = any.getType();
        if (t != Material.BAMBOO && t != Material.BAMBOO_SAPLING) {
            return false;
        }
        Block base = this.getBambooBaseBlock(any);
        if (base == null) {
            return false;
        }
        int before = this.getBambooHeight(base);
        if (before >= cap) {
            return false;
        }
        boolean changed = false;
        if (base.getType() == Material.BAMBOO_SAPLING) {
            base.setType(Material.BAMBOO, false);
            changed = true;
        }
        if ((height = this.getBambooHeight(base)) < 1) {
            height = 1;
        }
        for (int i = height; i < cap && (placeAt = base.getRelative(0, i, 0)).getType().isAir(); ++i) {
            placeAt.setType(Material.BAMBOO, false);
            this.setBambooLeavesSafe(placeAt, Bamboo.Leaves.NONE);
            changed = true;
        }
        int after = this.getBambooHeight(base);
        if (after > 0) {
            this.fixBambooTopLeaves(base, after);
        }
        return changed;
    }

    private void fixBambooTopLeaves(Block base, int height) {
        if (base == null) {
            return;
        }
        if (height <= 0) {
            return;
        }
        Block top = base.getRelative(0, height - 1, 0);
        this.setBambooLeavesSafe(top, Bamboo.Leaves.LARGE);
        if (height >= 2) {
            Block belowTop = base.getRelative(0, height - 2, 0);
            this.setBambooLeavesSafe(belowTop, Bamboo.Leaves.SMALL);
        }
    }

    private void setBambooLeavesSafe(Block b, Bamboo.Leaves leaves) {
        if (b == null) {
            return;
        }
        try {
            BlockData bd = b.getBlockData();
            if (bd instanceof Bamboo) {
                Bamboo bamboo = (Bamboo)bd;
                bamboo.setLeaves(leaves);
                b.setBlockData((BlockData)bamboo, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void takeOneFromHand(Player player, EquipmentSlot hand) {
        ItemStack held;
        ItemStack itemStack = held = hand == EquipmentSlot.HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        if (this.isEmpty(held)) {
            return;
        }
        if (held.getType() != Material.BONE_MEAL) {
            return;
        }
        int amt = held.getAmount();
        if (amt <= 1) {
            if (hand == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
            return;
        }
        held = held.clone();
        held.setAmount(amt - 1);
        if (hand == EquipmentSlot.HAND) {
            player.getInventory().setItemInMainHand(held);
        } else {
            player.getInventory().setItemInOffHand(held);
        }
    }

    private boolean growPitcherPlant(Block crop) {
        BlockData bdTop;
        Block below = crop.getRelative(BlockFace.DOWN);
        if (below.getType() != Material.FARMLAND) {
            return false;
        }
        Block top = crop.getRelative(BlockFace.UP);
        if (!top.getType().isAir()) {
            return false;
        }
        crop.setType(Material.PITCHER_PLANT, false);
        top.setType(Material.PITCHER_PLANT, false);
        BlockData bdBottom = crop.getBlockData();
        if (bdBottom instanceof Bisected) {
            Bisected b = (Bisected)bdBottom;
            b.setHalf(Bisected.Half.BOTTOM);
            crop.setBlockData((BlockData)b, false);
        }
        if ((bdTop = top.getBlockData()) instanceof Bisected) {
            Bisected b = (Bisected)bdTop;
            b.setHalf(Bisected.Half.TOP);
            top.setBlockData((BlockData)b, false);
        }
        return true;
    }

    private boolean isAgeBasedCrop(Material cropType) {
        return cropType == Material.WHEAT || cropType == Material.CARROTS || cropType == Material.POTATOES || cropType == Material.BEETROOTS || cropType == Material.NETHER_WART || cropType == Material.TORCHFLOWER_CROP || cropType == Material.PITCHER_CROP || cropType == Material.MELON_STEM || cropType == Material.PUMPKIN_STEM || cropType == Material.ATTACHED_MELON_STEM || cropType == Material.ATTACHED_PUMPKIN_STEM;
    }

    private Material getReplantSeedForCrop(Material cropType) {
        return switch (cropType) {
            case Material.WHEAT -> Material.WHEAT_SEEDS;
            case Material.CARROTS -> Material.CARROT;
            case Material.POTATOES -> Material.POTATO;
            case Material.BEETROOTS -> Material.BEETROOT_SEEDS;
            case Material.NETHER_WART -> Material.NETHER_WART;
            case Material.TORCHFLOWER_CROP -> Material.TORCHFLOWER_SEEDS;
            case Material.PITCHER_CROP -> Material.PITCHER_POD;
            case Material.MELON_STEM, Material.ATTACHED_MELON_STEM -> Material.MELON_SEEDS;
            case Material.PUMPKIN_STEM, Material.ATTACHED_PUMPKIN_STEM -> Material.PUMPKIN_SEEDS;
            default -> null;
        };
    }

    private Material getReplantPlantForCrop(Material cropType) {
        return switch (cropType) {
            case Material.WHEAT -> Material.WHEAT;
            case Material.CARROTS -> Material.CARROTS;
            case Material.POTATOES -> Material.POTATOES;
            case Material.BEETROOTS -> Material.BEETROOTS;
            case Material.NETHER_WART -> Material.NETHER_WART;
            case Material.TORCHFLOWER_CROP -> Material.TORCHFLOWER_CROP;
            case Material.PITCHER_CROP -> Material.PITCHER_CROP;
            case Material.MELON_STEM, Material.ATTACHED_MELON_STEM -> Material.MELON_STEM;
            case Material.PUMPKIN_STEM, Material.ATTACHED_PUMPKIN_STEM -> Material.PUMPKIN_STEM;
            default -> null;
        };
    }

    private boolean removeOneFromDrops(List<ItemStack> drops, Material type) {
        if (type == null) {
            return false;
        }
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack st = drops.get(i);
            if (this.isEmpty(st) || st.getType() != type) continue;
            int amt = st.getAmount();
            if (amt <= 1) {
                drops.remove(i);
            } else {
                st.setAmount(amt - 1);
            }
            return true;
        }
        return false;
    }

    private void giveToPlayerThenShulkersThenDrop(Player player, ItemStack stack, Location dropAt) {
        if (this.isEmpty(stack)) {
            return;
        }
        HashMap left = player.getInventory().addItem(new ItemStack[]{stack});
        if (left == null || left.isEmpty()) {
            return;
        }
        for (ItemStack leftover : left.values()) {
            if (this.isEmpty(leftover)) continue;
            ItemStack afterContainers = leftover;
            boolean useShulkers = this.autoPlantUseShulkers;
            boolean useBundles = this.autoPlantUseBundles;
            int depth = this.autoPlantBundleMaxDepth;
            if (useBundles) {
                afterContainers = this.tryPutInBundlesPlayerAndShulkers(player, afterContainers, useShulkers, depth);
            }
            if (!this.isEmpty(afterContainers) && useShulkers) {
                afterContainers = this.tryPutInShulkers(player, afterContainers, useBundles, depth);
            }
            if (this.isEmpty(afterContainers)) continue;
            player.getWorld().dropItemNaturally(dropAt, afterContainers);
        }
    }

    private boolean isBundleItem(ItemStack it) {
        if (this.isEmpty(it)) {
            return false;
        }
        return it.getType() == Material.BUNDLE && it.getItemMeta() instanceof BundleMeta;
    }

    private int bundleUnitWeight(ItemStack it) {
        if (this.isEmpty(it)) {
            return 0;
        }
        int max = 64;
        try {
            max = Math.max(1, it.getMaxStackSize());
        }
        catch (Throwable ignored) {
            max = 64;
        }
        int unit = 64 / max;
        if (unit < 1) {
            unit = 64;
        }
        if (unit > 64) {
            unit = 64;
        }
        return unit;
    }

    private int bundleUsedWeight(BundleMeta bm) {
        List items;
        if (bm == null) {
            return 0;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return 0;
        }
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int used = 0;
        for (ItemStack it : items) {
            int unit;
            long add;
            long next;
            if (this.isEmpty(it) || (used = (next = (long)used + (add = (long)(unit = this.bundleUnitWeight(it)) * (long)Math.max(1, it.getAmount()))) > 64L ? 64 : (int)next) < 64) continue;
            return 64;
        }
        return used;
    }

    private ItemStack tryPutInBundleItem(ItemStack bundleItem, ItemStack toAdd, int depth, boolean allowNestedBundles) {
        ArrayList<ItemStack> items;
        if (this.isEmpty(bundleItem) || this.isEmpty(toAdd)) {
            return toAdd;
        }
        if (!this.isBundleItem(bundleItem)) {
            return toAdd;
        }
        if (depth <= 0) {
            return toAdd;
        }
        BundleMeta bm = (BundleMeta)bundleItem.getItemMeta();
        if (bm == null) {
            return toAdd;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return toAdd;
        }
        if (items == null) {
            items = new ArrayList<ItemStack>();
        }
        if (allowNestedBundles && depth > 1 && !items.isEmpty()) {
            for (int i = 0; i < items.size(); ++i) {
                ItemStack rem;
                ItemStack inside = (ItemStack)items.get(i);
                if (!this.isBundleItem(inside) || (rem = this.tryPutInBundleItem(inside, toAdd, depth - 1, true)) == toAdd) continue;
                items.set(i, inside);
                toAdd = rem;
                if (this.isEmpty(toAdd)) break;
            }
        }
        if (this.isEmpty(toAdd)) {
            try {
                bm.setItems(items);
                bundleItem.setItemMeta((ItemMeta)bm);
            }
            catch (Throwable i) {
                // empty catch block
            }
            return null;
        }
        int used = this.bundleUsedWeight(bm);
        int free = 64 - used;
        if (free <= 0) {
            return toAdd;
        }
        int unit = this.bundleUnitWeight(toAdd);
        if (unit <= 0) {
            return toAdd;
        }
        int maxByWeight = free / unit;
        if (maxByWeight <= 0) {
            return toAdd;
        }
        int want = Math.min(toAdd.getAmount(), maxByWeight);
        if (want <= 0) {
            return toAdd;
        }
        for (int i = 0; i < items.size() && want > 0; ++i) {
            ItemStack inside = (ItemStack)items.get(i);
            if (this.isEmpty(inside)) continue;
            try {
                if (!inside.isSimilar(toAdd)) {
                }
            }
            catch (Throwable ignored) {}
            continue;
            int insideMax = inside.getMaxStackSize();
            int space = insideMax - inside.getAmount();
            if (space <= 0) continue;
            int add = Math.min(space, want);
            inside.setAmount(inside.getAmount() + add);
            items.set(i, inside);
            want -= add;
        }
        while (want > 0) {
            int stackMax = toAdd.getMaxStackSize();
            int add = Math.min(stackMax, want);
            ItemStack ns = toAdd.clone();
            ns.setAmount(add);
            items.add(ns);
            want -= add;
        }
        int removed = Math.min(toAdd.getAmount(), maxByWeight);
        removed = Math.max(0, removed);
        int remainAmt = toAdd.getAmount() - removed;
        ItemStack remain = null;
        if (remainAmt > 0) {
            remain = toAdd.clone();
            remain.setAmount(remainAmt);
        }
        try {
            bm.setItems(items);
            bundleItem.setItemMeta((ItemMeta)bm);
        }
        catch (Throwable ignored) {
            return toAdd;
        }
        return remain;
    }

    private ItemStack tryPutInBundlesInInventory(Inventory inv, ItemStack stack, int depth) {
        if (inv == null) {
            return stack;
        }
        if (this.isEmpty(stack)) {
            return stack;
        }
        if (depth <= 0) {
            return stack;
        }
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack rem;
            ItemStack it = inv.getItem(slot);
            if (!this.isBundleItem(it) || (rem = this.tryPutInBundleItem(it, stack, depth, true)) == stack) continue;
            try {
                inv.setItem(slot, it);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stack = rem;
            if (!this.isEmpty(stack)) continue;
            return null;
        }
        return stack;
    }

    private ItemStack tryPutInBundlesPlayerAndShulkers(Player player, ItemStack stack, boolean includeShulkers, int depth) {
        int slot;
        if (player == null) {
            return stack;
        }
        if (this.isEmpty(stack)) {
            return stack;
        }
        PlayerInventory pinv = player.getInventory();
        for (slot = 0; slot < pinv.getSize(); ++slot) {
            ItemStack rem;
            ItemStack it = pinv.getItem(slot);
            if (!this.isBundleItem(it) || (rem = this.tryPutInBundleItem(it, stack, depth, true)) == stack) continue;
            try {
                pinv.setItem(slot, it);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stack = rem;
            if (!this.isEmpty(stack)) continue;
            return null;
        }
        if (!includeShulkers || this.isEmpty(stack)) {
            return stack;
        }
        for (slot = 0; slot < pinv.getSize(); ++slot) {
            ShulkerBox shulker;
            Inventory shInv;
            ItemStack rem;
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta itemMeta;
            ItemStack boxItem = pinv.getItem(slot);
            if (!this.isShulkerBoxItem(boxItem) || !((itemMeta = boxItem.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)itemMeta).getBlockState()) instanceof ShulkerBox) || (rem = this.tryPutInBundlesInInventory(shInv = (shulker = (ShulkerBox)blockState).getInventory(), stack, depth)) == stack) continue;
            try {
                bsm.setBlockState((BlockState)shulker);
                boxItem.setItemMeta((ItemMeta)bsm);
                pinv.setItem(slot, boxItem);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stack = rem;
            if (!this.isEmpty(stack)) continue;
            return null;
        }
        return stack;
    }

    private ItemStack tryPutInShulkers(Player player, ItemStack stack, boolean includeBundlesInsideShulkers, int bundleDepth) {
        if (this.isEmpty(stack)) {
            return stack;
        }
        for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta itemMeta;
            String name;
            ItemStack boxItem = player.getInventory().getItem(slot);
            if (this.isEmpty(boxItem) || !(name = boxItem.getType().name()).endsWith("SHULKER_BOX") || !((itemMeta = boxItem.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)itemMeta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulker = (ShulkerBox)blockState;
            Inventory inv = shulker.getInventory();
            if (includeBundlesInsideShulkers && bundleDepth > 0 && this.isEmpty(stack = this.tryPutInBundlesInInventory(inv, stack, bundleDepth))) {
                try {
                    bsm.setBlockState((BlockState)shulker);
                    boxItem.setItemMeta((ItemMeta)bsm);
                    player.getInventory().setItem(slot, boxItem);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
            HashMap left = inv.addItem(new ItemStack[]{stack});
            bsm.setBlockState((BlockState)shulker);
            boxItem.setItemMeta((ItemMeta)bsm);
            player.getInventory().setItem(slot, boxItem);
            if (left == null || left.isEmpty()) {
                return null;
            }
            ItemStack still = null;
            for (ItemStack v : left.values()) {
                if (this.isEmpty(v)) continue;
                still = v;
                break;
            }
            if (still == null) {
                return null;
            }
            stack = still;
        }
        return stack;
    }

    private boolean takeOneFromInventory(Player player, Material type) {
        if (player == null || type == null) {
            return false;
        }
        return this.removeMaterialFromInventoryAndShulkers(player.getInventory(), type, 1, this.autoPlantUseShulkers, this.autoPlantUseBundles, this.autoPlantBundleMaxDepth);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBurn(FurnaceBurnEvent e) {
        Block block = e.getBlock();
        if (!this.isInstantSmeltingEnabled(block.getType())) {
            return;
        }
        long key = this.blockKey(block);
        if (!this.smeltLocks.add(key)) {
            return;
        }
        ItemStack fuelItem = e.getFuel();
        int burnTicks = e.getBurnTime();
        if (!this.isEmpty(fuelItem) && burnTicks > 0) {
            this.fuelTicksCache.put(fuelItem.getType(), burnTicks);
        }
        e.setCancelled(true);
        Location at = block.getLocation();
        Bukkit.getRegionScheduler().run((Plugin)this, at, t -> {
            try {
                this.instantCookAll(block, null, burnTicks, this.isEmpty(fuelItem) ? null : fuelItem.getType());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                this.smeltLocks.remove(key);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStartSmelt(FurnaceStartSmeltEvent e) {
        int defaultCook;
        Block block = e.getBlock();
        if (!this.isInstantSmeltingEnabled(block.getType())) {
            return;
        }
        long key = this.blockKey(block);
        if (!this.smeltLocks.add(key)) {
            return;
        }
        CookingRecipe recipe = e.getRecipe();
        int cook = defaultCook = block.getType() == Material.FURNACE ? 200 : 100;
        if (recipe != null) {
            int ct;
            try {
                ct = recipe.getCookingTime();
            }
            catch (Throwable ignored) {
                ct = 0;
            }
            if (ct > 0) {
                cook = ct;
            }
            if (cook < defaultCook) {
                cook = defaultCook;
            }
        }
        try {
            e.setTotalCookTime(cook);
        }
        catch (Throwable ct) {
            // empty catch block
        }
        Location at = block.getLocation();
        Bukkit.getRegionScheduler().run((Plugin)this, at, t -> {
            try {
                this.instantCookAll(block, recipe, -1, null);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                this.smeltLocks.remove(key);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBrewingStart(BrewingStartEvent e) {
        if (!this.instantBrewing) {
            return;
        }
        e.setBrewingTime(1);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCampfireStart(CampfireStartEvent e) {
        if (!this.instantCampfire) {
            return;
        }
        e.setTotalCookTime(1);
    }

    private void instantCookAll(Block block, CookingRecipe<?> knownRecipe, int burnTimeFromEvent, Material eventFuelType) {
        long baseTicks;
        long scaledTicks;
        int perInputOut;
        Material fuelType;
        BlockState blockState = block.getState();
        if (!(blockState instanceof Furnace)) {
            return;
        }
        Furnace furnaceState = (Furnace)blockState;
        FurnaceInventory inv = furnaceState.getSnapshotInventory();
        ItemStack input = inv.getSmelting();
        ItemStack fuel = inv.getFuel();
        ItemStack output = inv.getResult();
        if (this.isEmpty(input)) {
            return;
        }
        Material blockType = block.getType();
        if (!this.isInstantSmeltingEnabled(blockType)) {
            return;
        }
        CookingRecipe<?> recipe = knownRecipe;
        if (recipe == null) {
            recipe = this.findRecipe(blockType, input);
        }
        if (recipe == null) {
            return;
        }
        ItemStack resultPerItem = recipe.getResult();
        if (this.isEmpty(resultPerItem)) {
            return;
        }
        if (!this.isEmpty(output) && !output.isSimilar(resultPerItem)) {
            return;
        }
        int defaultCook = blockType == Material.FURNACE ? 200 : 100;
        int cookTotal = recipe.getCookingTime();
        if (cookTotal <= 0) {
            cookTotal = defaultCook;
        }
        if (cookTotal < defaultCook) {
            cookTotal = defaultCook;
        }
        int burnLeft = Math.max(0, furnaceState.getBurnTime());
        long totalFuelTicks = burnLeft;
        int perFuelTicks = 0;
        if (!this.isEmpty(fuel) && (perFuelTicks = this.getPerFuelTicks(fuelType = fuel.getType(), burnTimeFromEvent, eventFuelType)) > 0) {
            totalFuelTicks += (long)perFuelTicks * (long)fuel.getAmount();
        }
        if (totalFuelTicks <= 0L) {
            return;
        }
        int inputCount = input.getAmount();
        int outAmt = this.isEmpty(output) ? 0 : output.getAmount();
        int outMax = resultPerItem.getMaxStackSize();
        int outFree = outMax - outAmt;
        int maxByOutput = outFree / (perInputOut = Math.max(1, resultPerItem.getAmount()));
        if (maxByOutput <= 0) {
            return;
        }
        int cookProgress = Math.max(0, furnaceState.getCookTime());
        int ticksLeftFirst = cookTotal - cookProgress;
        if (ticksLeftFirst <= 0) {
            ticksLeftFirst = cookTotal;
        }
        int maxPossible = Math.min(inputCount, maxByOutput);
        int toCook = 0;
        int i = 1;
        while (i <= maxPossible && (scaledTicks = this.scaleTicks(baseTicks = (long)ticksLeftFirst + (long)(i - 1) * (long)cookTotal)) <= totalFuelTicks) {
            toCook = i++;
        }
        if (toCook <= 0) {
            return;
        }
        long baseNeeded = (long)ticksLeftFirst + (long)(toCook - 1) * (long)cookTotal;
        long ticksNeededScaled = this.scaleTicks(baseNeeded);
        this.spendFuelTicks(furnaceState, inv, ticksNeededScaled);
        int produced = toCook * perInputOut;
        if (this.isEmpty(output)) {
            ItemStack newOut = resultPerItem.clone();
            newOut.setAmount(produced);
            inv.setResult(newOut);
        } else {
            output.setAmount(output.getAmount() + produced);
            inv.setResult(output);
        }
        if (input.getAmount() == toCook) {
            inv.setSmelting(null);
        } else {
            input.setAmount(input.getAmount() - toCook);
            inv.setSmelting(input);
        }
        furnaceState.setCookTime((short)0);
        furnaceState.update(true, false);
    }

    private long scaleTicks(long baseTicks) {
        if (baseTicks <= 0L) {
            return 0L;
        }
        double scaled = (double)baseTicks * this.fuelCostMultiplier;
        if (scaled <= 0.0) {
            return 0L;
        }
        return (long)Math.ceil(scaled);
    }

    private int getPerFuelTicks(Material fuelType, int burnTimeFromEvent, Material eventFuelType) {
        if (fuelType == null) {
            return 0;
        }
        if (burnTimeFromEvent > 0 && eventFuelType != null && eventFuelType == fuelType) {
            return burnTimeFromEvent;
        }
        Integer cached = this.fuelTicksCache.get(fuelType);
        if (cached != null && cached > 0) {
            return cached;
        }
        if (this.safeFuelMode) {
            return 0;
        }
        return this.guessFuelTicks(fuelType);
    }

    private int guessFuelTicks(Material m) {
        if (m == Material.LAVA_BUCKET) {
            return 20000;
        }
        if (m == Material.COAL || m == Material.CHARCOAL) {
            return 1600;
        }
        if (m == Material.COAL_BLOCK) {
            return 16000;
        }
        if (m == Material.BLAZE_ROD) {
            return 2400;
        }
        if (m == Material.DRIED_KELP_BLOCK) {
            return 4000;
        }
        try {
            if (m.isFuel()) {
                return 300;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private void spendFuelTicks(Furnace furnaceState, FurnaceInventory inv, long ticksNeededScaled) {
        ItemStack fuel;
        long remaining = Math.max(0L, ticksNeededScaled);
        int burnLeft = Math.max(0, furnaceState.getBurnTime());
        if ((long)burnLeft >= remaining) {
            furnaceState.setBurnTime((short)(burnLeft - (int)remaining));
            return;
        }
        remaining -= (long)burnLeft;
        furnaceState.setBurnTime((short)0);
        while (remaining > 0L && !this.isEmpty(fuel = inv.getFuel())) {
            int per;
            Material type = fuel.getType();
            Integer perObj = this.fuelTicksCache.get(type);
            int n = per = perObj == null ? 0 : perObj;
            if (per <= 0 && !this.safeFuelMode) {
                per = this.guessFuelTicks(type);
            }
            if (per <= 0) break;
            this.consumeOneFuel(inv, fuel);
            if (remaining < (long)per) {
                int leftover = (int)((long)per - remaining);
                furnaceState.setBurnTime((short)this.clampShort(leftover));
                remaining = 0L;
                continue;
            }
            remaining -= (long)per;
            furnaceState.setBurnTime((short)0);
        }
    }

    private void consumeOneFuel(FurnaceInventory inv, ItemStack fuel) {
        Material type = fuel.getType();
        if (fuel.getAmount() <= 1) {
            Material remain = type.getCraftingRemainingItem();
            if (remain != null && remain != Material.AIR) {
                inv.setFuel(new ItemStack(remain, 1));
            } else {
                inv.setFuel(null);
            }
        } else {
            fuel.setAmount(fuel.getAmount() - 1);
            inv.setFuel(fuel);
        }
    }

    private CookingRecipe<?> findRecipe(Material blockType, ItemStack input) {
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe r = (Recipe)it.next();
            if (!(r instanceof CookingRecipe)) continue;
            CookingRecipe cr = (CookingRecipe)r;
            if (blockType == Material.FURNACE && !(cr instanceof FurnaceRecipe) || blockType == Material.SMOKER && !(cr instanceof SmokingRecipe) || blockType == Material.BLAST_FURNACE && !(cr instanceof BlastingRecipe)) continue;
            try {
                if (!cr.getInputChoice().test(input)) continue;
                return cr;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVillagerInteractPreOpen(PlayerInteractEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (!(clicked instanceof AbstractVillager)) {
            return;
        }
        AbstractVillager av = (AbstractVillager)clicked;
        if (clicked instanceof Villager) {
            Villager v = (Villager)clicked;
            try {
                if (v.isAdult()) {
                    this.clearNegativeVillagerGossip(v, p.getUniqueId());
                }
            }
            catch (Throwable ignored) {
                this.clearNegativeVillagerGossip(v, p.getUniqueId());
            }
        }
        if (!this.villagersResetTradeCooldown) {
            return;
        }
        this.resetVillagerTrades(av);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onZombieVillagerLoadInstantCure(EntityAddToWorldEvent e) {
        boolean converting;
        if (!this.villagersInstantCure) {
            return;
        }
        if (e == null) {
            return;
        }
        Entity ent = e.getEntity();
        if (!(ent instanceof ZombieVillager)) {
            return;
        }
        ZombieVillager zv = (ZombieVillager)ent;
        try {
            converting = zv.isConverting();
        }
        catch (Throwable ignored) {
            return;
        }
        if (!converting) {
            return;
        }
        try {
            zv.getScheduler().run((Plugin)this, t -> this.tryInstantCureZombieVillager(zv, null), null);
        }
        catch (Throwable ignored) {
            this.tryInstantCureZombieVillager(zv, null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onZombieVillagerInstantCure(PlayerInteractEntityEvent e) {
        ItemStack held;
        ItemStack main;
        if (!this.villagersInstantCure) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Entity entity = e.getRightClicked();
        if (!(entity instanceof ZombieVillager)) {
            return;
        }
        ZombieVillager zv = (ZombieVillager)entity;
        EquipmentSlot hand = e.getHand();
        if (hand == null) {
            return;
        }
        if (hand == EquipmentSlot.OFF_HAND && !this.isEmpty(main = p.getInventory().getItemInMainHand()) && main.getType() == Material.GOLDEN_APPLE) {
            return;
        }
        ItemStack itemStack = held = hand == EquipmentSlot.HAND ? p.getInventory().getItemInMainHand() : p.getInventory().getItemInOffHand();
        if (this.isEmpty(held) || held.getType() != Material.GOLDEN_APPLE) {
            return;
        }
        try {
            if (!zv.hasPotionEffect(PotionEffectType.WEAKNESS)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.markZombieVillagerCureBy(zv, p.getUniqueId());
        UUID curedBy = p.getUniqueId();
        try {
            zv.getScheduler().runDelayed((Plugin)this, t -> this.tryInstantCureZombieVillager(zv, curedBy), null, 1L);
        }
        catch (Throwable ignored) {
            try {
                Location at = zv.getLocation();
                Bukkit.getRegionScheduler().runDelayed((Plugin)this, at, t -> this.tryInstantCureZombieVillager(zv, curedBy), 1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onZombieVillagerCured(EntityTransformEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof ZombieVillager)) {
            return;
        }
        ZombieVillager zv = (ZombieVillager)entity;
        if (e.getTransformReason() != EntityTransformEvent.TransformReason.CURED) {
            return;
        }
        UUID curedBy = null;
        try {
            OfflinePlayer op = zv.getConversionPlayer();
            if (op != null) {
                curedBy = op.getUniqueId();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (curedBy == null) {
            curedBy = this.getMarkedCurePlayer(zv);
        }
        if (curedBy == null) {
            return;
        }
        for (Entity newEnt : e.getTransformedEntities()) {
            if (!(newEnt instanceof Villager)) continue;
            Villager v = (Villager)newEnt;
            UUID pid = curedBy;
            try {
                v.getScheduler().run((Plugin)this, t -> this.applyCureReputationNow(v, pid), null);
            }
            catch (Throwable ignored) {
                this.applyCureReputationNow(v, pid);
            }
        }
    }

    private void resetVillagerTrades(AbstractVillager villager) {
        if (villager == null) {
            return;
        }
        int count = villager.getRecipeCount();
        for (int i = 0; i < count; ++i) {
            int special;
            MerchantRecipe recipe = villager.getRecipe(i);
            if (recipe == null) continue;
            boolean changed = false;
            if (recipe.getUses() != 0) {
                recipe.setUses(0);
                changed = true;
            }
            if (recipe.getMaxUses() != Integer.MAX_VALUE) {
                recipe.setMaxUses(Integer.MAX_VALUE);
                changed = true;
            }
            if (recipe.getDemand() != 0) {
                recipe.setDemand(0);
                changed = true;
            }
            if ((special = recipe.getSpecialPrice()) > 0) {
                recipe.setSpecialPrice(0);
                changed = true;
            }
            if (!changed) continue;
            villager.setRecipe(i, recipe);
        }
    }

    private void tryInstantCureZombieVillager(ZombieVillager zv, UUID curedBy) {
        boolean converting;
        if (!this.villagersInstantCure) {
            return;
        }
        if (zv == null) {
            return;
        }
        try {
            if (!zv.isValid()) {
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        try {
            converting = zv.isConverting();
        }
        catch (Throwable ignored) {
            return;
        }
        if (!converting) {
            return;
        }
        this.ensureZombieVillagerConversionPlayer(zv, curedBy);
        try {
            zv.setConversionTime(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void markZombieVillagerCureBy(ZombieVillager zv, UUID playerId) {
        if (zv == null) {
            return;
        }
        if (playerId == null) {
            return;
        }
        try {
            if (this.zvCurePlayerKey != null) {
                zv.getPersistentDataContainer().set(this.zvCurePlayerKey, PersistentDataType.STRING, (Object)playerId.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            zv.setConversionPlayer(Bukkit.getOfflinePlayer((UUID)playerId));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private UUID getMarkedCurePlayer(ZombieVillager zv) {
        if (zv == null) {
            return null;
        }
        if (this.zvCurePlayerKey == null) {
            return null;
        }
        try {
            String s = (String)zv.getPersistentDataContainer().get(this.zvCurePlayerKey, PersistentDataType.STRING);
            if (s == null || s.isEmpty()) {
                return null;
            }
            return UUID.fromString(s);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void applyCureReputationNow(Villager v, UUID pid) {
        if (v == null || pid == null) {
            return;
        }
        try {
            Reputation rep = v.getReputation(pid);
            if (rep == null) {
                rep = new Reputation();
            }
            int major = rep.getReputation(ReputationType.MAJOR_POSITIVE);
            int minor = rep.getReputation(ReputationType.MINOR_POSITIVE);
            if (major < 20) {
                rep.setReputation(ReputationType.MAJOR_POSITIVE, 20);
            }
            if (minor < 25) {
                rep.setReputation(ReputationType.MINOR_POSITIVE, 25);
            }
            v.setReputation(pid, rep);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void ensureZombieVillagerConversionPlayer(ZombieVillager zv, UUID curedBy) {
        if (zv == null) {
            return;
        }
        UUID id = curedBy;
        if (id == null) {
            id = this.getMarkedCurePlayer(zv);
        }
        if (id == null) {
            return;
        }
        try {
            zv.setConversionPlayer(Bukkit.getOfflinePlayer((UUID)id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long ticksUntilWork(World w) {
        long day = Math.floorMod(w.getTime(), 24000L);
        if (day >= 0L && day < 24000L) {
            return 1L;
        }
        if (day < 0L) {
            return 0L - day;
        }
        return 24000L - day + 0L;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMerchantOpen(InventoryOpenEvent e) {
        block9: {
            if (e == null) {
                return;
            }
            Inventory inv = e.getInventory();
            if (inv == null) {
                return;
            }
            if (inv.getType() != InventoryType.MERCHANT) {
                return;
            }
            if (!(inv instanceof MerchantInventory)) {
                return;
            }
            MerchantInventory mi = (MerchantInventory)inv;
            Merchant merchant = mi.getMerchant();
            if (!(merchant instanceof AbstractVillager)) {
                return;
            }
            AbstractVillager av = (AbstractVillager)merchant;
            UUID openerId = null;
            HumanEntity humanEntity = e.getPlayer();
            if (humanEntity instanceof Player) {
                Player p = (Player)humanEntity;
                openerId = p.getUniqueId();
            }
            boolean doTradeReset = this.villagersResetTradeCooldown;
            UUID pid = openerId;
            try {
                av.getScheduler().run((Plugin)this, t -> {
                    if (doTradeReset) {
                        this.resetVillagerTrades(av);
                    }
                    if (pid != null && av instanceof Villager) {
                        Villager v = (Villager)av;
                        this.clearNegativeVillagerGossip(v, pid);
                    }
                }, null);
            }
            catch (Throwable ignored) {
                if (doTradeReset) {
                    this.resetVillagerTrades(av);
                }
                if (pid == null || !(av instanceof Villager)) break block9;
                Villager v = (Villager)av;
                this.clearNegativeVillagerGossip(v, pid);
            }
        }
    }

    private void clearNegativeVillagerGossip(Villager v, UUID playerId) {
        if (v == null || playerId == null) {
            return;
        }
        try {
            Reputation rep = v.getReputation(playerId);
            if (rep == null) {
                rep = new Reputation();
            }
            int majorNeg = rep.getReputation(ReputationType.MAJOR_NEGATIVE);
            int minorNeg = rep.getReputation(ReputationType.MINOR_NEGATIVE);
            boolean changed = false;
            if (majorNeg != 0) {
                rep.setReputation(ReputationType.MAJOR_NEGATIVE, 0);
                changed = true;
            }
            if (minorNeg != 0) {
                rep.setReputation(ReputationType.MINOR_NEGATIVE, 0);
                changed = true;
            }
            if (changed) {
                v.setReputation(playerId, rep);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVillagerJobSitePlaced(BlockPlaceEvent e) {
        Collection nearby;
        if (!this.villagersInstantWorkbenchUpdate) {
            return;
        }
        Block placed = e.getBlockPlaced();
        if (placed == null) {
            return;
        }
        Material type = placed.getType();
        if (!VILLAGER_JOB_SITES.contains(type)) {
            return;
        }
        Villager.Profession prof = this.getProfessionForJobSiteBlock(type);
        if (prof == null) {
            return;
        }
        int range = Math.max(0, this.villagersInstantWorkbenchRange);
        Location center = placed.getLocation().add(0.5, 0.5, 0.5);
        double r = (double)range + 0.5;
        try {
            nearby = placed.getWorld().getNearbyEntities(center, r, r, r, ent -> {
                if (!(ent instanceof Villager)) {
                    return false;
                }
                Villager v = (Villager)ent;
                if (!v.isAdult()) {
                    return false;
                }
                return v.getProfession() == Villager.Profession.NONE;
            });
        }
        catch (Throwable ignored) {
            return;
        }
        if (nearby == null || nearby.isEmpty()) {
            return;
        }
        Villager target = null;
        double best = Double.MAX_VALUE;
        for (Entity ent2 : nearby) {
            Villager v = (Villager)ent2;
            double d = v.getLocation().distanceSquared(center);
            if (!(d < best)) continue;
            best = d;
            target = v;
        }
        if (target == null) {
            return;
        }
        Location jobSiteLoc = placed.getLocation();
        Villager fv = target;
        long delay = this.ticksUntilWork(placed.getWorld());
        try {
            fv.getScheduler().runDelayed((Plugin)this, t -> this.tryAssignVillagerJobClean(fv, prof, jobSiteLoc), null, delay);
        }
        catch (Throwable ignored) {
            this.tryAssignVillagerJobClean(fv, prof, jobSiteLoc);
        }
    }

    private void tryAssignVillagerJobClean(Villager v, Villager.Profession prof, Location jobSiteLoc) {
        if (!this.villagersInstantWorkbenchUpdate) {
            return;
        }
        if (v == null || prof == null || jobSiteLoc == null) {
            return;
        }
        if (!v.isValid()) {
            return;
        }
        if (!v.isAdult()) {
            return;
        }
        if (v.getProfession() != Villager.Profession.NONE) {
            return;
        }
        try {
            v.setMemory(MemoryKey.POTENTIAL_JOB_SITE, (Object)jobSiteLoc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Villager.Profession getProfessionForJobSiteBlock(Material type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case Material.BLAST_FURNACE -> Villager.Profession.ARMORER;
            case Material.SMOKER -> Villager.Profession.BUTCHER;
            case Material.CARTOGRAPHY_TABLE -> Villager.Profession.CARTOGRAPHER;
            case Material.BREWING_STAND -> Villager.Profession.CLERIC;
            case Material.COMPOSTER -> Villager.Profession.FARMER;
            case Material.BARREL -> Villager.Profession.FISHERMAN;
            case Material.FLETCHING_TABLE -> Villager.Profession.FLETCHER;
            case Material.CAULDRON -> Villager.Profession.LEATHERWORKER;
            case Material.LECTERN -> Villager.Profession.LIBRARIAN;
            case Material.LOOM -> Villager.Profession.SHEPHERD;
            case Material.SMITHING_TABLE -> Villager.Profession.TOOLSMITH;
            case Material.GRINDSTONE -> Villager.Profession.WEAPONSMITH;
            case Material.STONECUTTER -> Villager.Profession.MASON;
            default -> null;
        };
    }

    private boolean isEmpty(ItemStack item) {
        return item == null || item.getType().isAir() || item.getAmount() <= 0;
    }

    private int clampShort(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return v;
    }

    private int clampInt(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    private long blockKey(Block b) {
        long x = (long)b.getX() & 0x3FFFFFFL;
        long y = (long)b.getY() & 0xFFFL;
        long z = (long)b.getZ() & 0x3FFFFFFL;
        long pos = x << 38 | z << 12 | y;
        return pos ^ b.getWorld().getUID().getMostSignificantBits() ^ b.getWorld().getUID().getLeastSignificantBits();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRecipeBookBulkCraft(PlayerRecipeBookClickEvent e) {
        Recipe recipe;
        NamespacedKey key;
        CraftingInventory crafting;
        InventoryType viewType;
        if (!this.bulkCrafting) {
            return;
        }
        if (e == null) {
            return;
        }
        if (!e.isMakeAll()) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        try {
            viewType = p.getOpenInventory().getType();
        }
        catch (Throwable ignored) {
            return;
        }
        if (viewType != InventoryType.CRAFTING && viewType != InventoryType.WORKBENCH) {
            return;
        }
        try {
            Inventory inventory = p.getOpenInventory().getTopInventory();
            if (!(inventory instanceof CraftingInventory)) {
                return;
            }
            CraftingInventory ci = (CraftingInventory)inventory;
            crafting = ci;
        }
        catch (Throwable ignored) {
            return;
        }
        if (!this.matrixHasAnyFullStack(crafting.getMatrix())) {
            return;
        }
        try {
            key = e.getRecipe();
        }
        catch (Throwable ignored) {
            return;
        }
        if (key == null) {
            return;
        }
        try {
            recipe = Bukkit.getRecipe((NamespacedKey)key);
        }
        catch (Throwable ignored) {
            return;
        }
        if (recipe == null) {
            return;
        }
        if (!(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe)) {
            return;
        }
        if (!this.matrixLooksCompatibleWithRecipe(crafting.getMatrix(), recipe, viewType)) {
            return;
        }
        e.setCancelled(true);
        try {
            p.getScheduler().runDelayed((Plugin)this, t -> this.tryBulkCraftNow(p, recipe, viewType), null, 1L);
        }
        catch (Throwable ignored) {
            this.tryBulkCraftNow(p, recipe, viewType);
        }
    }

    private ItemStack deepCloneItemForContainers(ItemStack in, boolean useShulkers, boolean useBundles, int bundleDepth) {
        if (in == null) {
            return null;
        }
        ItemStack out = in.clone();
        if (this.isEmpty(out)) {
            return out;
        }
        if (useBundles && bundleDepth > 0 && this.isBundleItem(out)) {
            try {
                BundleMeta bm = (BundleMeta)out.getItemMeta();
                if (bm != null) {
                    List items = bm.getItems();
                    ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(items == null ? 0 : items.size());
                    if (items != null) {
                        for (ItemStack it : items) {
                            if (it == null) continue;
                            int nextDepth = bundleDepth - 1;
                            newItems.add(this.deepCloneItemForContainers(it, useShulkers, useBundles, nextDepth));
                        }
                    }
                    bm.setItems(newItems);
                    out.setItemMeta((ItemMeta)bm);
                }
            }
            catch (Throwable bm) {
                // empty catch block
            }
            return out;
        }
        if (useShulkers && this.isShulkerBoxItem(out)) {
            try {
                BlockStateMeta bsm;
                ItemMeta newItems = out.getItemMeta();
                if (newItems instanceof BlockStateMeta && (newItems = (bsm = (BlockStateMeta)newItems).getBlockState()) instanceof ShulkerBox) {
                    ShulkerBox shulker = (ShulkerBox)newItems;
                    Inventory inv = shulker.getInventory();
                    ItemStack[] c = inv.getContents();
                    ItemStack[] nc = new ItemStack[c == null ? 0 : c.length];
                    if (c != null) {
                        for (int i = 0; i < c.length; ++i) {
                            nc[i] = this.deepCloneItemForContainers(c[i], useShulkers, useBundles, bundleDepth);
                        }
                    }
                    inv.setContents(nc);
                    bsm.setBlockState((BlockState)shulker);
                    out.setItemMeta((ItemMeta)bsm);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    private ItemStack[] deepCloneStorageContents(ItemStack[] in, boolean useShulkers, boolean useBundles, int bundleDepth) {
        if (in == null) {
            return new ItemStack[0];
        }
        ItemStack[] out = new ItemStack[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.deepCloneItemForContainers(in[i], useShulkers, useBundles, bundleDepth);
        }
        return out;
    }

    private void addCraftingRemainingItem(ItemStack usedOne, Map<Material, Integer> remainingItems) {
        if (this.isEmpty(usedOne)) {
            return;
        }
        if (remainingItems == null) {
            return;
        }
        Material used = usedOne.getType();
        Material rem = null;
        try {
            rem = used.getCraftingRemainingItem();
        }
        catch (Throwable ignored) {
            rem = null;
        }
        if (rem != null && !rem.isAir()) {
            remainingItems.merge(rem, 1, Integer::sum);
        }
    }

    private boolean consumeOneFromStack(ItemStack[] items, int idx, Map<Material, Integer> remainingItems) {
        ItemStack it = items[idx];
        if (this.isEmpty(it)) {
            return false;
        }
        this.addCraftingRemainingItem(it, remainingItems);
        int amt = it.getAmount();
        if (amt <= 1) {
            items[idx] = null;
        } else {
            it.setAmount(amt - 1);
            items[idx] = it;
        }
        return true;
    }

    private boolean takeOneFromBundleForChoice(ItemStack bundleItem, RecipeChoice need, Map<Material, Integer> remainingItems, boolean useShulkers, boolean useBundles, int bundleDepth) {
        List items;
        if (!this.isBundleItem(bundleItem)) {
            return false;
        }
        if (!useBundles || bundleDepth <= 0) {
            return false;
        }
        BundleMeta bm = (BundleMeta)bundleItem.getItemMeta();
        if (bm == null) {
            return false;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (items == null || items.isEmpty()) {
            return false;
        }
        for (int i = 0; i < items.size(); ++i) {
            ItemStack inside = (ItemStack)items.get(i);
            if (this.isEmpty(inside)) continue;
            boolean match = false;
            try {
                match = need.test(inside);
            }
            catch (Throwable ignored) {
                match = false;
            }
            if (match) {
                this.addCraftingRemainingItem(inside, remainingItems);
                int amt = inside.getAmount();
                if (amt <= 1) {
                    items.remove(i);
                } else {
                    inside.setAmount(amt - 1);
                    items.set(i, inside);
                }
                try {
                    bm.setItems(items);
                    bundleItem.setItemMeta((ItemMeta)bm);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (useBundles && bundleDepth > 1 && this.isBundleItem(inside) && this.takeOneFromBundleForChoice(inside, need, remainingItems, useShulkers, useBundles, bundleDepth - 1)) {
                items.set(i, inside);
                try {
                    bm.setItems(items);
                    bundleItem.setItemMeta((ItemMeta)bm);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (!useShulkers || !this.isShulkerBoxItem(inside) || !this.takeOneFromShulkerForChoice(inside, need, remainingItems, useShulkers, useBundles, bundleDepth)) continue;
            items.set(i, inside);
            try {
                bm.setItems(items);
                bundleItem.setItemMeta((ItemMeta)bm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean takeOneFromShulkerForChoice(ItemStack boxItem, RecipeChoice need, Map<Material, Integer> remainingItems, boolean useShulkers, boolean useBundles, int bundleDepth) {
        if (!useShulkers) {
            return false;
        }
        if (!this.isShulkerBoxItem(boxItem)) {
            return false;
        }
        ItemMeta itemMeta = boxItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return false;
        }
        BlockStateMeta bsm = (BlockStateMeta)itemMeta;
        BlockState blockState = bsm.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return false;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        Inventory inv = shulker.getInventory();
        int size = inv.getSize();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack it = inv.getItem(slot);
            if (this.isEmpty(it)) continue;
            boolean match = false;
            try {
                match = need.test(it);
            }
            catch (Throwable ignored) {
                match = false;
            }
            if (match) {
                this.addCraftingRemainingItem(it, remainingItems);
                int amt = it.getAmount();
                if (amt <= 1) {
                    inv.setItem(slot, null);
                } else {
                    it.setAmount(amt - 1);
                    inv.setItem(slot, it);
                }
                try {
                    bsm.setBlockState((BlockState)shulker);
                    boxItem.setItemMeta((ItemMeta)bsm);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (!useBundles || bundleDepth <= 0 || !this.isBundleItem(it) || !this.takeOneFromBundleForChoice(it, need, remainingItems, useShulkers, useBundles, bundleDepth)) continue;
            inv.setItem(slot, it);
            try {
                bsm.setBlockState((BlockState)shulker);
                boxItem.setItemMeta((ItemMeta)bsm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean takeOneFromStorageDeep(ItemStack[] storage, RecipeChoice need, Map<Material, Integer> remainingItems, boolean useShulkers, boolean useBundles, int bundleDepth) {
        if (storage == null) {
            return false;
        }
        for (int i = 0; i < storage.length; ++i) {
            ItemStack it = storage[i];
            if (this.isEmpty(it)) continue;
            boolean match = false;
            try {
                match = need.test(it);
            }
            catch (Throwable ignored) {
                match = false;
            }
            if (match) {
                return this.consumeOneFromStack(storage, i, remainingItems);
            }
            if (useBundles && bundleDepth > 0 && this.isBundleItem(it) && this.takeOneFromBundleForChoice(it, need, remainingItems, useShulkers, useBundles, bundleDepth)) {
                storage[i] = it;
                return true;
            }
            if (!useShulkers || !this.isShulkerBoxItem(it) || !this.takeOneFromShulkerForChoice(it, need, remainingItems, useShulkers, useBundles, bundleDepth)) continue;
            storage[i] = it;
            return true;
        }
        return false;
    }

    private void tryBulkCraftNow(Player player, Recipe recipe, InventoryType viewType) {
        int crafts;
        ItemStack resultProto;
        CraftingInventory crafting;
        if (!this.bulkCrafting) {
            return;
        }
        if (player == null) {
            return;
        }
        if (recipe == null) {
            return;
        }
        try {
            if (player.getOpenInventory() == null) {
                return;
            }
            if (player.getOpenInventory().getType() != viewType) {
                return;
            }
            Inventory inventory = player.getOpenInventory().getTopInventory();
            if (!(inventory instanceof CraftingInventory)) {
                return;
            }
            CraftingInventory ci = (CraftingInventory)inventory;
            crafting = ci;
        }
        catch (Throwable ignored) {
            return;
        }
        List<RecipeChoice> needs = this.buildNeeds(recipe, viewType);
        if (needs == null || needs.isEmpty()) {
            return;
        }
        try {
            resultProto = recipe.getResult();
        }
        catch (Throwable ignored) {
            return;
        }
        if (this.isEmpty(resultProto)) {
            return;
        }
        boolean useShulkers = this.bulkCraftingUseShulkers;
        boolean useBundles = this.bulkCraftingUseBundles;
        int bundleDepth = this.bulkCraftingBundleMaxDepth;
        PlayerInventory inv = player.getInventory();
        ItemStack[] matrix = this.cloneItems(crafting.getMatrix());
        ItemStack[] storage = this.deepCloneStorageContents(inv.getStorageContents(), useShulkers, useBundles, bundleDepth);
        HashMap<Material, Integer> remainingItems = new HashMap<Material, Integer>();
        for (crafts = 0; crafts < Integer.MAX_VALUE; ++crafts) {
            boolean ok = true;
            for (RecipeChoice need : needs) {
                if (need == null) {
                    ok = false;
                    break;
                }
                boolean took = false;
                for (int i = 0; i < matrix.length; ++i) {
                    ItemStack it = matrix[i];
                    if (this.isEmpty(it)) continue;
                    boolean match = false;
                    try {
                        match = need.test(it);
                    }
                    catch (Throwable ignored) {
                        match = false;
                    }
                    if (!match) continue;
                    took = this.consumeOneFromStack(matrix, i, remainingItems);
                    break;
                }
                if (took || this.takeOneFromStorageDeep(storage, need, remainingItems, useShulkers, useBundles, bundleDepth)) continue;
                ok = false;
                break;
            }
            if (!ok) break;
        }
        if (crafts <= 0) {
            return;
        }
        try {
            crafting.setMatrix(matrix);
            crafting.setResult(null);
        }
        catch (Throwable ok) {
            // empty catch block
        }
        try {
            inv.setStorageContents(storage);
        }
        catch (Throwable ok) {
            // empty catch block
        }
        int perCraft = Math.max(1, resultProto.getAmount());
        int totalResult = crafts * perCraft;
        this.giveOrDropStackedAtFeet(player, resultProto.clone(), totalResult);
        for (Map.Entry ent : remainingItems.entrySet()) {
            Material m = (Material)ent.getKey();
            int amt = (Integer)ent.getValue();
            if (m == null || amt <= 0) continue;
            this.giveOrDropStackedAtFeet(player, new ItemStack(m, 1), amt);
        }
        try {
            player.updateInventory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Location getFeetDropLocation(Player p) {
        Block base;
        if (p == null) {
            return null;
        }
        Location l = p.getLocation();
        if (l == null) {
            return null;
        }
        Block feet = l.getBlock();
        Block block = base = feet == null ? null : feet.getRelative(BlockFace.DOWN);
        if (base == null || base.getType().isAir()) {
            base = feet;
        }
        if (base == null) {
            return l;
        }
        return base.getLocation().add(0.5, 1.1, 0.5);
    }

    private void dropItemNeatly(World w, Location loc, ItemStack st) {
        if (w == null || loc == null) {
            return;
        }
        if (this.isEmpty(st)) {
            return;
        }
        try {
            Item ent = w.dropItem(loc, st);
            ent.setVelocity(new Vector(0.0, 0.0, 0.0));
        }
        catch (Throwable ignored) {
            try {
                w.dropItemNaturally(loc, st);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void giveOrDropStackedAtFeet(Player player, ItemStack proto, int totalAmount) {
        int take;
        if (player == null) {
            return;
        }
        if (this.isEmpty(proto)) {
            return;
        }
        if (totalAmount <= 0) {
            return;
        }
        Location dropLoc = this.getFeetDropLocation(player);
        if (dropLoc == null) {
            dropLoc = player.getLocation();
        }
        ItemStack one = proto.clone();
        one.setAmount(1);
        int max = one.getMaxStackSize();
        for (int remaining = totalAmount; remaining > 0; remaining -= take) {
            Map left;
            take = Math.min(max, remaining);
            ItemStack stack = one.clone();
            stack.setAmount(take);
            try {
                left = player.getInventory().addItem(new ItemStack[]{stack});
            }
            catch (Throwable ignored) {
                left = null;
            }
            if (left == null || left.isEmpty()) continue;
            World w = player.getWorld();
            for (ItemStack lf : left.values()) {
                if (this.isEmpty(lf)) continue;
                this.dropItemNeatly(w, dropLoc, lf);
            }
        }
    }

    private boolean matrixHasAnyFullStack(ItemStack[] matrix) {
        if (matrix == null) {
            return false;
        }
        for (ItemStack it : matrix) {
            if (this.isEmpty(it) || it.getAmount() < it.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private boolean matrixLooksCompatibleWithRecipe(ItemStack[] matrix, Recipe recipe, InventoryType viewType) {
        if (matrix == null) {
            return false;
        }
        List<RecipeChoice> needs = this.buildNeeds(recipe, viewType);
        if (needs == null || needs.isEmpty()) {
            return false;
        }
        for (ItemStack it : matrix) {
            if (this.isEmpty(it)) continue;
            boolean ok = false;
            for (RecipeChoice c : needs) {
                try {
                    if (c == null || !c.test(it)) continue;
                    ok = true;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    private List<RecipeChoice> buildNeeds(Recipe recipe, InventoryType viewType) {
        if (recipe == null) {
            return null;
        }
        int gridSize = viewType == InventoryType.WORKBENCH ? 3 : 2;
        int maxSlots = gridSize * gridSize;
        if (recipe instanceof ShapelessRecipe) {
            List list;
            ShapelessRecipe sl = (ShapelessRecipe)recipe;
            try {
                list = sl.getChoiceList();
            }
            catch (Throwable ignored) {
                return null;
            }
            if (list == null) {
                return null;
            }
            if (list.size() > maxSlots) {
                return null;
            }
            ArrayList<RecipeChoice> out = new ArrayList<RecipeChoice>(list.size());
            for (RecipeChoice c : list) {
                if (c == null) continue;
                out.add(c);
            }
            return out;
        }
        if (recipe instanceof ShapedRecipe) {
            Map map;
            String[] shape;
            ShapedRecipe sr = (ShapedRecipe)recipe;
            try {
                shape = sr.getShape();
                map = sr.getChoiceMap();
            }
            catch (Throwable ignored) {
                return null;
            }
            if (shape == null || map == null) {
                return null;
            }
            int minRow = 999;
            int maxRow = -1;
            int minCol = 999;
            int maxCol = -1;
            for (int r = 0; r < shape.length; ++r) {
                String row = shape[r];
                if (row == null) continue;
                for (int c = 0; c < row.length(); ++c) {
                    char ch = row.charAt(c);
                    if (ch == ' ') continue;
                    minRow = Math.min(minRow, r);
                    maxRow = Math.max(maxRow, r);
                    minCol = Math.min(minCol, c);
                    maxCol = Math.max(maxCol, c);
                }
            }
            if (maxRow >= 0) {
                int h = maxRow - minRow + 1;
                int w = maxCol - minCol + 1;
                if (h > gridSize || w > gridSize) {
                    return null;
                }
            }
            ArrayList<RecipeChoice> out = new ArrayList<RecipeChoice>(9);
            for (String row : shape) {
                if (row == null) continue;
                for (int c = 0; c < row.length(); ++c) {
                    char ch = row.charAt(c);
                    if (ch == ' ') continue;
                    RecipeChoice choice = (RecipeChoice)map.get(Character.valueOf(ch));
                    if (choice == null) {
                        return null;
                    }
                    out.add(choice);
                }
            }
            if (out.size() > maxSlots) {
                return null;
            }
            return out;
        }
        return null;
    }

    private void giveOrDropStacked(Player player, ItemStack proto, int totalAmount) {
        int take;
        if (player == null) {
            return;
        }
        if (this.isEmpty(proto)) {
            return;
        }
        if (totalAmount <= 0) {
            return;
        }
        ItemStack one = proto.clone();
        one.setAmount(1);
        int max = one.getMaxStackSize();
        for (int remaining = totalAmount; remaining > 0; remaining -= take) {
            Map left;
            take = Math.min(max, remaining);
            ItemStack stack = one.clone();
            stack.setAmount(take);
            try {
                left = player.getInventory().addItem(new ItemStack[]{stack});
            }
            catch (Throwable ignored) {
                left = null;
            }
            if (left == null || left.isEmpty()) continue;
            World w = player.getWorld();
            Location loc = player.getLocation();
            for (ItemStack lf : left.values()) {
                if (this.isEmpty(lf)) continue;
                try {
                    w.dropItemNaturally(loc, lf);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private ItemStack[] cloneItems(ItemStack[] in) {
        if (in == null) {
            return new ItemStack[0];
        }
        ItemStack[] out = new ItemStack[in.length];
        for (int i = 0; i < in.length; ++i) {
            ItemStack it = in[i];
            out[i] = it == null ? null : it.clone();
        }
        return out;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSeaPickleFastPlace(PlayerInteractEvent e) {
        int upTo2;
        Block target;
        ItemStack main;
        if (!this.seaPicklesFastPlace) {
            return;
        }
        if (e == null) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EquipmentSlot hand = e.getHand();
        if (hand == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (hand == EquipmentSlot.OFF_HAND && !this.isEmpty(main = p.getInventory().getItemInMainHand()) && main.getType() == Material.SEA_PICKLE) {
            return;
        }
        ItemStack held = e.getItem();
        if (this.isEmpty(held)) {
            return;
        }
        if (held.getType() != Material.SEA_PICKLE) {
            return;
        }
        Block clicked = e.getClickedBlock();
        if (clicked == null) {
            return;
        }
        BlockFace face = e.getBlockFace();
        if (face == null) {
            face = BlockFace.UP;
        }
        boolean creative = p.getGameMode() == GameMode.CREATIVE;
        boolean useShulkers = this.seaPicklesFastPlaceUseShulkers;
        boolean useBundles = this.seaPicklesFastPlaceUseBundles;
        int bundleDepth = this.seaPicklesFastPlaceBundleMaxDepth;
        if (clicked.getType() == Material.SEA_PICKLE) {
            target = clicked;
        } else if (this.isSeaPickleWaterSpace(clicked)) {
            Block down;
            Bisected bi;
            BlockData cbd;
            target = clicked;
            try {
                cbd = clicked.getBlockData();
            }
            catch (Throwable ignored) {
                cbd = null;
            }
            if (cbd instanceof Bisected && (bi = (Bisected)cbd).getHalf() == Bisected.Half.TOP && (down = clicked.getRelative(BlockFace.DOWN)) != null) {
                target = down;
            }
        } else {
            target = clicked.getRelative(face);
        }
        if (target == null) {
            return;
        }
        if (target.getType() == Material.SEA_PICKLE ? this.getSeaPickleCount(target) >= 4 : !this.isSeaPickleWaterSpace(target)) {
            return;
        }
        if (!creative && held.getAmount() < 2 && (upTo2 = this.countMaterialInInventoryAndShulkersUpTo(p.getInventory(), Material.SEA_PICKLE, 2, useShulkers, useBundles, bundleDepth)) < 2) {
            return;
        }
        UUID pid = p.getUniqueId();
        UUID wid = target.getWorld().getUID();
        int tx = target.getX();
        int ty = target.getY();
        int tz = target.getZ();
        Location runAt = new Location(target.getWorld(), (double)tx + 0.5, (double)ty + 0.5, (double)tz + 0.5);
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, runAt, t -> this.seaPickleFastPlaceStep1(pid, wid, tx, ty, tz), 1L);
    }

    private void seaPickleFastPlaceStep1(UUID playerId, UUID worldId, int x, int y, int z) {
        if (!this.seaPicklesFastPlace) {
            return;
        }
        if (playerId == null || worldId == null) {
            return;
        }
        World w = Bukkit.getWorld((UUID)worldId);
        if (w == null) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            return;
        }
        Block b = w.getBlockAt(x, y, z);
        if (b.getType() != Material.SEA_PICKLE) {
            return;
        }
        int basePickles = this.getSeaPickleCount(b);
        if (basePickles >= 4) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)playerId);
        if (p == null) {
            return;
        }
        int bp = basePickles;
        try {
            p.getScheduler().run((Plugin)this, pt -> this.seaPickleFastPlacePlayerStep(playerId, worldId, x, y, z, bp), null);
        }
        catch (Throwable ignored) {
            this.seaPickleFastPlacePlayerStep(playerId, worldId, x, y, z, bp);
        }
    }

    private void seaPickleFastPlacePlayerStep(UUID playerId, UUID worldId, int x, int y, int z, int basePickles) {
        World w;
        if (!this.seaPicklesFastPlace) {
            return;
        }
        if (playerId == null || worldId == null) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)playerId);
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        boolean creative = p.getGameMode() == GameMode.CREATIVE;
        boolean useShulkers = this.seaPicklesFastPlaceUseShulkers;
        boolean useBundles = this.seaPicklesFastPlaceUseBundles;
        int bundleDepth = this.seaPicklesFastPlaceBundleMaxDepth;
        int available = creative ? 4 : this.countMaterialInInventoryAndShulkers(p.getInventory(), Material.SEA_PICKLE, useShulkers, useBundles, bundleDepth);
        int desired = Math.min(4, basePickles + available);
        int toAdd = desired - basePickles;
        if (toAdd <= 0) {
            return;
        }
        if (!creative) {
            if (available < toAdd) {
                return;
            }
            boolean removed = this.removeMaterialFromInventoryAndShulkers(p.getInventory(), Material.SEA_PICKLE, toAdd, useShulkers, useBundles, bundleDepth);
            if (!removed) {
                return;
            }
            try {
                p.updateInventory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((w = Bukkit.getWorld((UUID)worldId)) == null) {
            if (!creative) {
                this.refundSeaPickles(playerId, toAdd);
            }
            return;
        }
        int removedAmount = creative ? 0 : toAdd;
        Location at = new Location(w, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        Bukkit.getRegionScheduler().run((Plugin)this, at, rt -> this.seaPickleFastPlaceFinalStep(playerId, worldId, x, y, z, desired, removedAmount));
    }

    private boolean isSeaPickleWaterSpace(Block b) {
        if (b == null) {
            return false;
        }
        Material t = b.getType();
        if (t == Material.WATER) {
            return true;
        }
        if (t == Material.BUBBLE_COLUMN) {
            return true;
        }
        if (t == Material.SEAGRASS) {
            return true;
        }
        if (t == Material.TALL_SEAGRASS) {
            return true;
        }
        if (t == Material.KELP) {
            return true;
        }
        if (t == Material.KELP_PLANT) {
            return true;
        }
        try {
            Waterlogged wl;
            if (!b.isPassable()) {
                return false;
            }
            BlockData bd = b.getBlockData();
            if (bd instanceof Waterlogged && (wl = (Waterlogged)bd).isWaterlogged()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean isShulkerBoxItem(ItemStack it) {
        if (this.isEmpty(it)) {
            return false;
        }
        String name = it.getType().name();
        return name.endsWith("SHULKER_BOX");
    }

    private int countMaterialInBundleItemUpTo(ItemStack bundleItem, Material type, int limit, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        List items;
        if (limit <= 0) {
            return 0;
        }
        if (!includeBundles || bundleDepth <= 0) {
            return 0;
        }
        if (!this.isBundleItem(bundleItem)) {
            return 0;
        }
        BundleMeta bm = (BundleMeta)bundleItem.getItemMeta();
        if (bm == null) {
            return 0;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return 0;
        }
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack it : items) {
            if (this.isEmpty(it)) continue;
            if (it.getType() == type && (total += it.getAmount()) >= limit) {
                return total;
            }
            if (includeBundles && bundleDepth > 1 && this.isBundleItem(it) && (total += this.countMaterialInBundleItemUpTo(it, type, limit - total, includeShulkers, includeBundles, bundleDepth - 1)) >= limit) {
                return total;
            }
            if (!includeShulkers || !this.isShulkerBoxItem(it) || (total += this.countMaterialInShulkerItemUpTo(it, type, limit - total, includeShulkers, includeBundles, bundleDepth)) < limit) continue;
            return total;
        }
        return total;
    }

    private int countMaterialInShulkerItemUpTo(ItemStack boxItem, Material type, int limit, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        ItemStack[] items;
        if (limit <= 0) {
            return 0;
        }
        if (!includeShulkers) {
            return 0;
        }
        if (!this.isShulkerBoxItem(boxItem)) {
            return 0;
        }
        ItemMeta itemMeta = boxItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return 0;
        }
        BlockStateMeta bsm = (BlockStateMeta)itemMeta;
        BlockState blockState = bsm.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return 0;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        Inventory inv = shulker.getInventory();
        try {
            items = inv.getContents();
        }
        catch (Throwable ignored) {
            items = null;
        }
        if (items == null) {
            return 0;
        }
        int total = 0;
        for (ItemStack it : items) {
            if (this.isEmpty(it)) continue;
            if (it.getType() == type && (total += it.getAmount()) >= limit) {
                return total;
            }
            if (!includeBundles || bundleDepth <= 0 || !this.isBundleItem(it) || (total += this.countMaterialInBundleItemUpTo(it, type, limit - total, includeShulkers, includeBundles, bundleDepth)) < limit) continue;
            return total;
        }
        return total;
    }

    private int countMaterialInInventoryAndShulkersUpTo(PlayerInventory inv, Material type, int limit, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        ItemStack[] items;
        if (inv == null || type == null) {
            return 0;
        }
        if (limit <= 0) {
            return 0;
        }
        int total = 0;
        try {
            items = inv.getContents();
        }
        catch (Throwable ignored) {
            items = null;
        }
        if (items != null) {
            for (ItemStack it : items) {
                if (this.isEmpty(it)) continue;
                if (it.getType() == type) {
                    if ((total += it.getAmount()) < limit) continue;
                    return total;
                }
                if (includeBundles && bundleDepth > 0 && this.isBundleItem(it) && (total += this.countMaterialInBundleItemUpTo(it, type, limit - total, includeShulkers, includeBundles, bundleDepth)) >= limit) {
                    return total;
                }
                if (!includeShulkers || !this.isShulkerBoxItem(it) || (total += this.countMaterialInShulkerItemUpTo(it, type, limit - total, includeShulkers, includeBundles, bundleDepth)) < limit) continue;
                return total;
            }
        }
        return total;
    }

    private int countMaterialInInventoryAndShulkers(PlayerInventory inv, Material type, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        return this.countMaterialInInventoryAndShulkersUpTo(inv, type, 1000000, includeShulkers, includeBundles, bundleDepth);
    }

    private int removeMaterialFromBundleItem(ItemStack bundleItem, Material type, int amount, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        List items;
        if (amount <= 0) {
            return 0;
        }
        if (!includeBundles || bundleDepth <= 0) {
            return 0;
        }
        if (!this.isBundleItem(bundleItem)) {
            return 0;
        }
        BundleMeta bm = (BundleMeta)bundleItem.getItemMeta();
        if (bm == null) {
            return 0;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return 0;
        }
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int removed = 0;
        for (int i = 0; i < items.size() && removed < amount; ++i) {
            int r;
            ItemStack inside = (ItemStack)items.get(i);
            if (this.isEmpty(inside)) continue;
            if (inside.getType() == type) {
                int take = Math.min(inside.getAmount(), amount - removed);
                int leftAmt = inside.getAmount() - take;
                removed += take;
                if (leftAmt <= 0) {
                    items.remove(i);
                    --i;
                    continue;
                }
                inside.setAmount(leftAmt);
                items.set(i, inside);
                continue;
            }
            if (includeBundles && bundleDepth > 1 && this.isBundleItem(inside)) {
                r = this.removeMaterialFromBundleItem(inside, type, amount - removed, includeShulkers, includeBundles, bundleDepth - 1);
                if (r <= 0) continue;
                removed += r;
                items.set(i, inside);
                continue;
            }
            if (!includeShulkers || !this.isShulkerBoxItem(inside) || (r = this.removeMaterialFromShulkerItem(inside, type, amount - removed, includeShulkers, includeBundles, bundleDepth)) <= 0) continue;
            removed += r;
            items.set(i, inside);
        }
        if (removed > 0) {
            try {
                bm.setItems(items);
                bundleItem.setItemMeta((ItemMeta)bm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return removed;
    }

    private int removeMaterialFromShulkerItem(ItemStack boxItem, Material type, int amount, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        int removed;
        if (amount <= 0) {
            return 0;
        }
        if (!includeShulkers) {
            return 0;
        }
        if (!this.isShulkerBoxItem(boxItem)) {
            return 0;
        }
        ItemMeta itemMeta = boxItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return 0;
        }
        BlockStateMeta bsm = (BlockStateMeta)itemMeta;
        BlockState blockState = bsm.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return 0;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        Inventory shInv = shulker.getInventory();
        int left = amount;
        left = this.removeFromAnyInventory(shInv, type, left);
        if (left > 0 && includeBundles && bundleDepth > 0) {
            for (int slot = 0; slot < shInv.getSize() && left > 0; ++slot) {
                int r;
                ItemStack it = shInv.getItem(slot);
                if (!this.isBundleItem(it) || (r = this.removeMaterialFromBundleItem(it, type, left, includeShulkers, includeBundles, bundleDepth)) <= 0) continue;
                left -= r;
                try {
                    shInv.setItem(slot, it);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if ((removed = amount - left) > 0) {
            try {
                bsm.setBlockState((BlockState)shulker);
                boxItem.setItemMeta((ItemMeta)bsm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return removed;
    }

    private boolean removeMaterialFromInventoryAndShulkers(PlayerInventory inv, Material type, int amount, boolean includeShulkers, boolean includeBundles, int bundleDepth) {
        int r;
        int slot;
        if (inv == null || type == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        int have = this.countMaterialInInventoryAndShulkers(inv, type, includeShulkers, includeBundles, bundleDepth);
        if (have < amount) {
            return false;
        }
        int left = amount;
        if ((left = this.removeFromPlayerSlots(inv, type, left)) <= 0) {
            return true;
        }
        if (includeBundles && bundleDepth > 0) {
            for (slot = 0; slot < inv.getSize() && left > 0; ++slot) {
                ItemStack it = inv.getItem(slot);
                if (!this.isBundleItem(it) || (r = this.removeMaterialFromBundleItem(it, type, left, includeShulkers, includeBundles, bundleDepth)) <= 0) continue;
                left -= r;
                try {
                    inv.setItem(slot, it);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (left <= 0) {
                return true;
            }
        }
        if (includeShulkers) {
            for (slot = 0; slot < inv.getSize() && left > 0; ++slot) {
                ItemStack boxItem = inv.getItem(slot);
                if (!this.isShulkerBoxItem(boxItem) || (r = this.removeMaterialFromShulkerItem(boxItem, type, left, includeShulkers, includeBundles, bundleDepth)) <= 0) continue;
                left -= r;
                try {
                    inv.setItem(slot, boxItem);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return left <= 0;
    }

    private int removeFromPlayerSlots(PlayerInventory inv, Material type, int amount) {
        int size;
        int left = amount;
        try {
            size = inv.getSize();
        }
        catch (Throwable ignored) {
            return left;
        }
        for (int i = 0; i < size && left > 0; ++i) {
            ItemStack it = inv.getItem(i);
            if (this.isEmpty(it) || it.getType() != type) continue;
            int amt = it.getAmount();
            int take = Math.min(amt, left);
            int newAmt = amt - take;
            left -= take;
            if (newAmt <= 0) {
                inv.setItem(i, null);
                continue;
            }
            ItemStack ns = it.clone();
            ns.setAmount(newAmt);
            inv.setItem(i, ns);
        }
        return left;
    }

    private int removeFromAnyInventory(Inventory inv, Material type, int amount) {
        if (inv == null) {
            return amount;
        }
        int left = amount;
        for (int i = 0; i < inv.getSize() && left > 0; ++i) {
            ItemStack it = inv.getItem(i);
            if (this.isEmpty(it) || it.getType() != type) continue;
            int amt = it.getAmount();
            int take = Math.min(amt, left);
            int newAmt = amt - take;
            left -= take;
            if (newAmt <= 0) {
                inv.setItem(i, null);
                continue;
            }
            ItemStack ns = it.clone();
            ns.setAmount(newAmt);
            inv.setItem(i, ns);
        }
        return left;
    }

    private void seaPickleFastPlaceFinalStep(UUID playerId, UUID worldId, int x, int y, int z, int desired, int removedAmount) {
        if (playerId == null || worldId == null) {
            return;
        }
        if (!this.seaPicklesFastPlace) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        World w = Bukkit.getWorld((UUID)worldId);
        if (w == null) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        Block b = w.getBlockAt(x, y, z);
        if (b.getType() != Material.SEA_PICKLE) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        int nowPickles = this.getSeaPickleCount(b);
        if (nowPickles >= desired) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        int delta = desired - nowPickles;
        if (delta <= 0) {
            if (removedAmount > 0) {
                this.refundSeaPickles(playerId, removedAmount);
            }
            return;
        }
        this.setSeaPickleCount(b, desired);
        int refund = removedAmount - delta;
        if (refund > 0) {
            this.refundSeaPickles(playerId, refund);
        }
    }

    private int getSeaPickleCount(Block b) {
        if (b == null) {
            return 0;
        }
        if (b.getType() != Material.SEA_PICKLE) {
            return 0;
        }
        try {
            BlockData bd = b.getBlockData();
            if (bd instanceof SeaPickle) {
                SeaPickle sp = (SeaPickle)bd;
                int c = sp.getPickles();
                if (c < 1) {
                    c = 1;
                }
                if (c > 4) {
                    c = 4;
                }
                return c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    private void setSeaPickleCount(Block b, int count) {
        if (b == null) {
            return;
        }
        if (b.getType() != Material.SEA_PICKLE) {
            return;
        }
        if (count < 1) {
            count = 1;
        }
        if (count > 4) {
            count = 4;
        }
        try {
            BlockData bd = b.getBlockData();
            if (!(bd instanceof SeaPickle)) {
                return;
            }
            SeaPickle sp = (SeaPickle)bd;
            if (sp.getPickles() == count) {
                return;
            }
            sp.setPickles(count);
            b.setBlockData((BlockData)sp, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void refundSeaPickles(UUID playerId, int amount) {
        if (amount <= 0) {
            return;
        }
        if (playerId == null) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)playerId);
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        try {
            p.getScheduler().run((Plugin)this, t -> {
                if (p.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                this.giveOrDropStacked(p, new ItemStack(Material.SEA_PICKLE, 1), amount);
            }, null);
        }
        catch (Throwable ignored) {
            this.giveOrDropStacked(p, new ItemStack(Material.SEA_PICKLE, 1), amount);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTradeSelectVillagerBulkTrade(TradeSelectEvent e) {
        if (!this.villagersBulkTrading) {
            return;
        }
        if (e == null) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        MerchantInventory mi = e.getInventory();
        if (mi == null) {
            return;
        }
        Merchant merchant = e.getMerchant();
        if (!(merchant instanceof AbstractVillager)) {
            return;
        }
        int index = e.getIndex();
        long mk = this.merchantKey(merchant);
        UUID pid = p.getUniqueId();
        long now = System.nanoTime();
        VillagerTradeClickState prev = this.villagerTradeClicks.get(pid);
        boolean isDoubleClick = false;
        if (prev != null) {
            long window = this.ticksToNanos(this.villagersBulkTradingDoubleClickTicks);
            if (prev.merchantKey == mk && prev.index == index && now - prev.timeNanos <= window) {
                isDoubleClick = true;
            }
        }
        this.villagerTradeClicks.put(pid, new VillagerTradeClickState(mk, index, now));
        if (!isDoubleClick) {
            return;
        }
        try {
            p.getScheduler().runDelayed((Plugin)this, t -> this.tryBulkTradeNow(p, mk, index), null, 1L);
        }
        catch (Throwable ignored) {
            this.tryBulkTradeNow(p, mk, index);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMerchantCloseClearBulkTradeState(InventoryCloseEvent e) {
        if (e == null) {
            return;
        }
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory inv = e.getInventory();
        if (inv == null) {
            return;
        }
        if (inv.getType() != InventoryType.MERCHANT) {
            return;
        }
        this.villagerTradeClicks.remove(p.getUniqueId());
    }

    private void tryBulkTradeNow(Player p, long expectedMerchantKey, int tradeIndex) {
        ItemStack ing1Adj;
        ItemStack resultProto;
        MerchantRecipe recipe;
        int selectedIndex;
        if (!this.villagersBulkTrading) {
            return;
        }
        if (p == null) {
            return;
        }
        if (p.getOpenInventory() == null) {
            return;
        }
        if (p.getOpenInventory().getType() != InventoryType.MERCHANT) {
            return;
        }
        Inventory top = p.getOpenInventory().getTopInventory();
        if (!(top instanceof MerchantInventory)) {
            return;
        }
        MerchantInventory mi = (MerchantInventory)top;
        Merchant merchant = mi.getMerchant();
        if (!(merchant instanceof AbstractVillager)) {
            return;
        }
        AbstractVillager av = (AbstractVillager)merchant;
        long mk = this.merchantKey(merchant);
        if (mk != expectedMerchantKey) {
            return;
        }
        try {
            selectedIndex = mi.getSelectedRecipeIndex();
        }
        catch (Throwable ignored) {
            selectedIndex = tradeIndex;
        }
        if (selectedIndex != tradeIndex) {
            return;
        }
        try {
            recipe = mi.getSelectedRecipe();
        }
        catch (Throwable ignored) {
            recipe = null;
        }
        if (recipe == null) {
            return;
        }
        try {
            resultProto = recipe.getResult();
        }
        catch (Throwable ignored) {
            return;
        }
        if (this.isEmpty(resultProto)) {
            return;
        }
        ItemStack slot0 = this.safeGet(mi, 0);
        ItemStack slot1 = this.safeGet(mi, 1);
        ItemStack slot2 = this.safeGet(mi, 2);
        if (this.isEmpty(slot2)) {
            return;
        }
        boolean hasFull = false;
        if (!this.isEmpty(slot0) && slot0.getAmount() >= slot0.getMaxStackSize()) {
            hasFull = true;
        }
        if (!this.isEmpty(slot1) && slot1.getAmount() >= slot1.getMaxStackSize()) {
            hasFull = true;
        }
        if (!hasFull) {
            return;
        }
        try {
            ing1Adj = recipe.getAdjustedIngredient1();
        }
        catch (Throwable ignored) {
            ing1Adj = null;
        }
        if (this.isEmpty(ing1Adj)) {
            return;
        }
        Material t1 = ing1Adj.getType();
        int per1 = Math.max(1, ing1Adj.getAmount());
        ItemStack ing2 = null;
        try {
            List ings = recipe.getIngredients();
            if (ings == null) break block33;
            if (ings.size() < 2) break block34;
            ItemStack maybe = (ItemStack)ings.get(1);
            if (this.isEmpty(maybe)) break block35;
            if (maybe.getType().isAir()) break block36;
            if (maybe.getAmount() > 0) {
                ing2 = maybe;
            }
        }
        finally {
            Material t2 = null;
        }
        {
            block33: {
                block34: {
                    block35: {
                        block36: {
                        }
                    }
                }
            }
        }
    }

    private void applyVillagerXpAndLevelForBulkTrades(AbstractVillager av, MerchantRecipe recipe, long trades, UUID playerId, long expectedMerchantKey) {
        int xpGain;
        if (av == null) {
            return;
        }
        if (recipe == null) {
            return;
        }
        if (trades <= 0L) {
            return;
        }
        if (!(av instanceof Villager)) {
            return;
        }
        Villager v = (Villager)av;
        int perTradeXp = 0;
        try {
            perTradeXp = recipe.getVillagerExperience();
        }
        catch (Throwable ignored) {
            perTradeXp = 0;
        }
        if (perTradeXp <= 0) {
            return;
        }
        long gainL = trades * (long)perTradeXp;
        if (gainL <= 0L) {
            return;
        }
        int n = xpGain = gainL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)gainL;
        if (xpGain <= 0) {
            return;
        }
        try {
            v.getScheduler().run((Plugin)this, task -> this.doApplyVillagerXpAndLevel(v, xpGain, playerId, expectedMerchantKey), null);
        }
        catch (Throwable ignored) {
            this.doApplyVillagerXpAndLevel(v, xpGain, playerId, expectedMerchantKey);
        }
    }

    private void doApplyVillagerXpAndLevel(Villager v, int xpGain, UUID playerId, long expectedMerchantKey) {
        if (v == null) {
            return;
        }
        try {
            if (!v.isValid()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int oldXp = 0;
        int oldLevel = 1;
        try {
            oldXp = v.getVillagerExperience();
        }
        catch (Throwable ignored) {
            oldXp = 0;
        }
        try {
            oldLevel = v.getVillagerLevel();
        }
        catch (Throwable ignored) {
            oldLevel = 1;
        }
        if (oldXp < 0) {
            oldXp = 0;
        }
        if (oldLevel < 1) {
            oldLevel = 1;
        }
        if (oldLevel > 5) {
            oldLevel = 5;
        }
        if (oldLevel >= 5) {
            return;
        }
        long newXpL = (long)oldXp + (long)xpGain;
        int newXp = newXpL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newXpL;
        int targetLevel = this.villagerLevelForXp(newXp);
        if (targetLevel < oldLevel) {
            targetLevel = oldLevel;
        }
        if (targetLevel > 5) {
            targetLevel = 5;
        }
        try {
            v.setVillagerExperience(newXp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean leveledUp = false;
        if (targetLevel > oldLevel) {
            int diff = targetLevel - oldLevel;
            int beforeTrades = 0;
            try {
                List r = v.getRecipes();
                beforeTrades = r == null ? 0 : r.size();
            }
            finally {
                int i = 0;
            }
        }
        int newLevelActual = oldLevel;
        try {
            newLevelActual = v.getVillagerLevel();
        }
        catch (Throwable ignored) {
            newLevelActual = oldLevel;
        }
        if (newLevelActual > oldLevel) {
            leveledUp = true;
        }
        if (leveledUp) {
            Player p;
            try {
                v.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, v.getLocation().add(0.0, 1.0, 0.0), 12, 0.35, 0.35, 0.35, 0.0);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                v.getWorld().playSound(v.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, SoundCategory.NEUTRAL, 0.7f, 1.4f);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (playerId != null && (p = Bukkit.getPlayer((UUID)playerId)) != null) {
                try {
                    p.getScheduler().runDelayed((Plugin)this, pt -> this.tryRefreshMerchantView(p, (Merchant)v, expectedMerchantKey), null, 1L);
                }
                catch (Throwable ignored) {
                    this.tryRefreshMerchantView(p, (Merchant)v, expectedMerchantKey);
                }
            }
        }
    }

    private int villagerLevelForXp(int totalXp) {
        if (totalXp < 0) {
            totalXp = 0;
        }
        if (totalXp >= 250) {
            return 5;
        }
        if (totalXp >= 150) {
            return 4;
        }
        if (totalXp >= 70) {
            return 3;
        }
        if (totalXp >= 10) {
            return 2;
        }
        return 1;
    }

    private void tryRefreshMerchantView(Player p, Merchant merchant, long expectedMerchantKey) {
        Merchant openMerchant;
        Inventory top;
        InventoryView openView;
        if (p == null || merchant == null) {
            return;
        }
        try {
            openView = p.getOpenInventory();
        }
        catch (Throwable ignored) {
            return;
        }
        if (openView == null) {
            return;
        }
        try {
            if (openView.getType() != InventoryType.MERCHANT) {
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        try {
            top = openView.getTopInventory();
        }
        catch (Throwable ignored) {
            return;
        }
        if (!(top instanceof MerchantInventory)) {
            return;
        }
        MerchantInventory mi = (MerchantInventory)top;
        try {
            openMerchant = mi.getMerchant();
        }
        catch (Throwable ignored) {
            return;
        }
        if (openMerchant == null) {
            return;
        }
        if (this.merchantKey(openMerchant) != expectedMerchantKey) {
            return;
        }
        try {
            InventoryView newView = ((MerchantInventoryViewBuilder)MenuType.MERCHANT.builder()).merchant(merchant).checkReachable(false).build((HumanEntity)p);
            p.openInventory(newView);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long merchantKey(Merchant m) {
        if (m instanceof Entity) {
            Entity ent = (Entity)m;
            UUID id = ent.getUniqueId();
            return id.getMostSignificantBits() ^ id.getLeastSignificantBits();
        }
        return System.identityHashCode(m);
    }

    private long ticksToNanos(int ticks) {
        if (ticks <= 0) {
            ticks = 1;
        }
        return (long)ticks * 50000000L;
    }

    private ItemStack safeGet(MerchantInventory mi, int slot) {
        try {
            return mi.getItem(slot);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private int countMaterialInMerchantInputs(MerchantInventory mi, Material type) {
        ItemStack s1;
        if (mi == null || type == null) {
            return 0;
        }
        int total = 0;
        ItemStack s0 = this.safeGet(mi, 0);
        if (!this.isEmpty(s0) && s0.getType() == type) {
            total += s0.getAmount();
        }
        if (!this.isEmpty(s1 = this.safeGet(mi, 1)) && s1.getType() == type) {
            total += s1.getAmount();
        }
        return total;
    }

    private int removeMaterialFromMerchantInputsPreferSlot(MerchantInventory mi, Material type, int amount, int preferSlot) {
        if (mi == null || type == null) {
            return 0;
        }
        if (amount <= 0) {
            return 0;
        }
        int removed = 0;
        int first = preferSlot == 1 ? 1 : 0;
        int second = first == 0 ? 1 : 0;
        if ((removed += this.removeMaterialFromMerchantSlot(mi, first, type, amount - removed)) < amount) {
            removed += this.removeMaterialFromMerchantSlot(mi, second, type, amount - removed);
        }
        return removed;
    }

    private int removeMaterialFromMerchantSlot(MerchantInventory mi, int slot, Material type, int amount) {
        int take;
        if (amount <= 0) {
            return 0;
        }
        ItemStack it = this.safeGet(mi, slot);
        if (this.isEmpty(it)) {
            return 0;
        }
        if (it.getType() != type) {
            return 0;
        }
        int amt = it.getAmount();
        int left = amt - (take = Math.min(amt, amount));
        if (left <= 0) {
            try {
                mi.setItem(slot, null);
            }
            catch (Throwable throwable) {}
        } else {
            ItemStack ns = it.clone();
            ns.setAmount(left);
            try {
                mi.setItem(slot, ns);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return take;
    }

    private void dropItemStackedAt(World w, Location loc, ItemStack proto, int totalAmount) {
        int take;
        if (w == null || loc == null) {
            return;
        }
        if (this.isEmpty(proto)) {
            return;
        }
        if (totalAmount <= 0) {
            return;
        }
        ItemStack one = proto.clone();
        one.setAmount(1);
        int max = one.getMaxStackSize();
        for (int remaining = totalAmount; remaining > 0; remaining -= take) {
            take = Math.min(max, remaining);
            ItemStack st = one.clone();
            st.setAmount(take);
            try {
                w.dropItemNaturally(loc, st);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void trySetArmoredElytraAnvilResult(PrepareAnvilEvent e, AnvilView view) {
        AnvilInventory top;
        if (e == null || view == null) {
            return;
        }
        try {
            top = view.getTopInventory();
        }
        catch (Throwable ignored) {
            return;
        }
        if (top == null) {
            return;
        }
        ItemStack a = null;
        ItemStack b = null;
        try {
            a = top.getItem(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            b = top.getItem(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.isEmpty(a) || this.isEmpty(b)) {
            return;
        }
        ItemStack elytra = null;
        ItemStack chest = null;
        if (a.getType() == Material.ELYTRA && b.getType() == Material.NETHERITE_CHESTPLATE) {
            elytra = a;
            chest = b;
        } else if (b.getType() == Material.ELYTRA && a.getType() == Material.NETHERITE_CHESTPLATE) {
            elytra = b;
            chest = a;
        } else {
            return;
        }
        String rename = null;
        try {
            rename = view.getRenameText();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ItemStack result = this.buildArmoredElytraResult(elytra, chest, rename);
        if (this.isEmpty(result)) {
            return;
        }
        this.markArmoredElytra(result);
        e.setResult(result);
        try {
            view.setRepairCost(39);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            view.setRepairItemCountCost(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ItemStack buildArmoredElytraResult(ItemStack elytraIn, ItemStack chestIn, String renameText) {
        String r;
        if (this.isEmpty(elytraIn) || this.isEmpty(chestIn)) {
            return null;
        }
        if (elytraIn.getType() != Material.ELYTRA) {
            return null;
        }
        if (chestIn.getType() != Material.NETHERITE_CHESTPLATE) {
            return null;
        }
        ItemStack out = elytraIn.clone();
        out.setAmount(1);
        ItemMeta meta = out.getItemMeta();
        if (meta == null) {
            return out;
        }
        HashMap<Enchantment, Integer> merged = new HashMap<Enchantment, Integer>();
        try {
            Map e1 = elytraIn.getEnchantments();
            if (e1 != null) {
                for (Map.Entry entry : e1.entrySet()) {
                    int lvl;
                    Enchantment ench2 = (Enchantment)entry.getKey();
                    int n = lvl = entry.getValue() == null ? 0 : (Integer)entry.getValue();
                    if (ench2 == null || lvl <= 0) continue;
                    merged.put(ench2, lvl);
                }
            }
        }
        catch (Throwable e1) {
            // empty catch block
        }
        try {
            Map e2 = chestIn.getEnchantments();
            if (e2 != null) {
                for (Map.Entry entry : e2.entrySet()) {
                    Integer cur;
                    int lvl3;
                    Enchantment ench = (Enchantment)entry.getKey();
                    int n = lvl3 = entry.getValue() == null ? 0 : (Integer)entry.getValue();
                    if (ench == null || lvl3 <= 0 || (cur = (Integer)merged.get(ench)) != null && lvl3 <= cur) continue;
                    merged.put(ench, lvl3);
                }
            }
        }
        catch (Throwable e2) {
            // empty catch block
        }
        try {
            Map existing = meta.getEnchants();
            if (existing != null && !existing.isEmpty()) {
                ArrayList arrayList = new ArrayList(existing.keySet());
                for (Enchantment ench : arrayList) {
                    if (ench == null) continue;
                    meta.removeEnchant(ench);
                }
            }
        }
        catch (Throwable existing) {
            // empty catch block
        }
        for (Map.Entry entry : merged.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer lvl2 = (Integer)entry.getValue();
            if (enchantment == null || lvl2 == null || lvl2 <= 0) continue;
            try {
                meta.addEnchant(enchantment, lvl2.intValue(), true);
            }
            catch (Throwable lvl3) {}
        }
        double armor = this.sumNetheriteChestplateAddNumber(chestIn, Attribute.ARMOR);
        double d = this.sumNetheriteChestplateAddNumber(chestIn, Attribute.ARMOR_TOUGHNESS);
        double kb = this.sumNetheriteChestplateAddNumber(chestIn, Attribute.KNOCKBACK_RESISTANCE);
        this.removeAttrModByKey(meta, Attribute.ARMOR, this.armoredElytraArmorModKey);
        this.removeAttrModByKey(meta, Attribute.ARMOR_TOUGHNESS, this.armoredElytraToughModKey);
        this.removeAttrModByKey(meta, Attribute.KNOCKBACK_RESISTANCE, this.armoredElytraKbModKey);
        try {
            if (armor != 0.0) {
                meta.addAttributeModifier(Attribute.ARMOR, new AttributeModifier(this.armoredElytraArmorModKey, armor, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.CHEST));
            }
            if (d != 0.0) {
                meta.addAttributeModifier(Attribute.ARMOR_TOUGHNESS, new AttributeModifier(this.armoredElytraToughModKey, d, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.CHEST));
            }
            if (kb != 0.0) {
                meta.addAttributeModifier(Attribute.KNOCKBACK_RESISTANCE, new AttributeModifier(this.armoredElytraKbModKey, kb, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.CHEST));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            meta.getPersistentDataContainer().set(this.armoredElytraTagKey, PersistentDataType.BYTE, (Object)1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (renameText != null && !(r = renameText.trim()).isEmpty()) {
            try {
                meta.displayName((Component)Component.text((String)r));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        out.setItemMeta(meta);
        return out;
    }

    private double sumNetheriteChestplateAddNumber(ItemStack chest, Attribute attr) {
        double total;
        block13: {
            EquipmentSlotGroup g;
            Collection mods;
            block12: {
                if (this.isEmpty(chest) || attr == null) {
                    return 0.0;
                }
                if (chest.getType() != Material.NETHERITE_CHESTPLATE) {
                    return 0.0;
                }
                total = 0.0;
                try {
                    Multimap defs = chest.getType().getDefaultAttributeModifiers(EquipmentSlot.CHEST);
                    if (defs == null || (mods = defs.get((Object)attr)) == null) break block12;
                    for (AttributeModifier m : mods) {
                        if (m == null || m.getOperation() != AttributeModifier.Operation.ADD_NUMBER) continue;
                        g = null;
                        try {
                            g = m.getSlotGroup();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (g != null && g != EquipmentSlotGroup.CHEST) continue;
                        total += m.getAmount();
                    }
                }
                catch (Throwable defs) {
                    // empty catch block
                }
            }
            try {
                ItemMeta meta = chest.getItemMeta();
                if (meta == null || (mods = meta.getAttributeModifiers(attr)) == null) break block13;
                for (AttributeModifier m : mods) {
                    if (m == null || m.getOperation() != AttributeModifier.Operation.ADD_NUMBER) continue;
                    g = null;
                    try {
                        g = m.getSlotGroup();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (g != null && g != EquipmentSlotGroup.CHEST) continue;
                    total += m.getAmount();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return total;
    }

    private void removeAttrModByKey(ItemMeta meta, Attribute attr, NamespacedKey key) {
        Collection mods;
        if (meta == null || attr == null || key == null) {
            return;
        }
        try {
            mods = meta.getAttributeModifiers(attr);
        }
        catch (Throwable ignored) {
            return;
        }
        if (mods == null || mods.isEmpty()) {
            return;
        }
        for (AttributeModifier m : new ArrayList(mods)) {
            if (m == null) continue;
            NamespacedKey mk = null;
            try {
                mk = m.getKey();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!key.equals((Object)mk)) continue;
            try {
                meta.removeAttributeModifier(attr, m);
            }
            catch (Throwable throwable) {}
        }
    }

    private void markArmoredElytra(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        if (stack.getType() != Material.ELYTRA) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            meta.getPersistentDataContainer().set(this.armoredElytraKey, PersistentDataType.BYTE, (Object)1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            meta.setDamageResistant(DamageTypeTags.IS_FIRE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stack.setItemMeta(meta);
    }

    private boolean isArmoredElytra(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        if (stack.getType() != Material.ELYTRA) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            return meta.getPersistentDataContainer().has(this.armoredElytraKey, PersistentDataType.BYTE);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArmoredElytraItemDamage(EntityDamageEvent e) {
        if (e == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEnt = (Item)entity;
        ItemStack st = itemEnt.getItemStack();
        if (!this.isArmoredElytra(st)) {
            return;
        }
        EntityDamageEvent.DamageCause c = e.getCause();
        if (c == EntityDamageEvent.DamageCause.LAVA || c == EntityDamageEvent.DamageCause.FIRE || c == EntityDamageEvent.DamageCause.FIRE_TICK || c == EntityDamageEvent.DamageCause.HOT_FLOOR) {
            e.setCancelled(true);
            try {
                itemEnt.setFireTicks(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArmoredElytraCombust(EntityCombustEvent e) {
        if (e == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEnt = (Item)entity;
        ItemStack st = itemEnt.getItemStack();
        if (!this.isArmoredElytra(st)) {
            return;
        }
        e.setCancelled(true);
        try {
            itemEnt.setFireTicks(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreventNearBreakBlockDamage(BlockDamageEvent e) {
        if (!this.preventToolBreak) {
            return;
        }
        if (e == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (!this.isProtectedTool(tool)) {
            return;
        }
        if (this.isNearBreaking(tool, 1)) {
            e.setCancelled(true);
            this.playRepairWarn(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreventNearBreakBlockBreak(BlockBreakEvent e) {
        if (!this.preventToolBreak) {
            return;
        }
        if (e == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (!this.isProtectedTool(tool)) {
            return;
        }
        if (this.isNearBreaking(tool, 1)) {
            e.setCancelled(true);
            this.playRepairWarn(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreventNearBreakAttack(EntityDamageByEntityEvent e) {
        if (!this.preventToolBreak) {
            return;
        }
        if (e == null) {
            return;
        }
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (!this.isProtectedTool(tool)) {
            return;
        }
        if (this.isNearBreaking(tool, 1)) {
            e.setCancelled(true);
            this.playRepairWarn(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreventNearBreakShoot(EntityShootBowEvent e) {
        if (!this.preventToolBreak) {
            return;
        }
        if (e == null) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ItemStack bow = e.getBow();
        if (!this.isProtectedTool(bow)) {
            return;
        }
        if (this.isNearBreaking(bow, 1)) {
            e.setCancelled(true);
            this.playRepairWarn(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreventItemBreaking(PlayerItemDamageEvent e) {
        int cur;
        short max;
        if (e == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ItemStack it = e.getItem();
        if (this.isEmpty(it)) {
            return;
        }
        ItemMeta meta = it.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable dmg = (Damageable)meta;
        try {
            if (meta.isUnbreakable()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            max = it.getType().getMaxDurability();
        }
        catch (Throwable ignored) {
            return;
        }
        if (max <= 0) {
            return;
        }
        try {
            cur = dmg.getDamage();
        }
        catch (Throwable ignored) {
            return;
        }
        int incoming = Math.max(0, e.getDamage());
        int after = cur + incoming;
        if (after < max) {
            return;
        }
        Material m = it.getType();
        if (this.isArmorMaterial(m)) {
            if (!this.preventArmorBreak) {
                return;
            }
        } else {
            if (!this.preventToolBreak) {
                return;
            }
            if (!this.isProtectedTool(it)) {
                return;
            }
        }
        e.setCancelled(true);
        int targetDamage = Math.max(0, max - 1);
        this.setItemDamageSafe(it, targetDamage);
        this.playRepairWarn(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArmorNearBreakLetDamageThrough(EntityDamageEvent e) {
        DamageSource src;
        double raw;
        if (!this.preventArmorBreak) {
            return;
        }
        if (e == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!this.hasNearBreakingArmor(p)) {
            return;
        }
        try {
            raw = e.getDamage();
        }
        catch (Throwable ignored) {
            return;
        }
        if (raw <= 0.0) {
            return;
        }
        try {
            src = e.getDamageSource();
        }
        catch (Throwable ignored) {
            return;
        }
        if (src == null) {
            return;
        }
        UUID pid = p.getUniqueId();
        if (!this.armorNearBreakDamagePass.add(pid)) {
            return;
        }
        ItemStack[] savedArmor = null;
        try {
            e.setCancelled(true);
            savedArmor = this.cloneItems(p.getInventory().getArmorContents());
            p.getInventory().setArmorContents(new ItemStack[4]);
            p.damage(raw, src);
            this.playRepairWarn(p);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (savedArmor != null) {
                    p.getInventory().setArmorContents(savedArmor);
                    try {
                        p.updateInventory();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {}
            this.armorNearBreakDamagePass.remove(pid);
        }
    }

    private boolean hasNearBreakingArmor(Player p) {
        ItemStack[] armor;
        if (p == null) {
            return false;
        }
        try {
            armor = p.getInventory().getArmorContents();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (armor == null) {
            return false;
        }
        for (ItemStack it : armor) {
            if (this.isEmpty(it) || !this.isArmorMaterial(it.getType()) || !this.isNearBreaking(it, 1)) continue;
            return true;
        }
        return false;
    }

    private boolean isNearBreaking(ItemStack item, int remaining) {
        int cur;
        short max;
        if (this.isEmpty(item)) {
            return false;
        }
        try {
            max = item.getType().getMaxDurability();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (max <= 0) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return false;
        }
        Damageable dmg = (Damageable)meta;
        try {
            if (meta.isUnbreakable()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cur = dmg.getDamage();
        }
        catch (Throwable ignored) {
            return false;
        }
        int left = max - cur;
        int need = Math.max(1, remaining);
        return left <= need;
    }

    private void setItemDamageSafe(ItemStack stack, int newDamage) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable dmg = (Damageable)meta;
        if (newDamage < 0) {
            newDamage = 0;
        }
        try {
            dmg.setDamage(newDamage);
            stack.setItemMeta((ItemMeta)dmg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isArmorMaterial(Material m) {
        if (m == null) {
            return false;
        }
        String n = m.name();
        return n.endsWith("_HELMET") || n.endsWith("_CHESTPLATE") || n.endsWith("_LEGGINGS") || n.endsWith("_BOOTS");
    }

    private boolean isProtectedTool(ItemStack it) {
        short max;
        if (this.isEmpty(it)) {
            return false;
        }
        Material m = it.getType();
        if (m == null) {
            return false;
        }
        if (this.isArmorMaterial(m)) {
            return false;
        }
        if (m == Material.ELYTRA) {
            return false;
        }
        try {
            max = m.getMaxDurability();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (max <= 0) {
            return false;
        }
        ItemMeta meta = it.getItemMeta();
        return meta instanceof Damageable;
    }

    private void playRepairWarn(Player p) {
        if (p == null) {
            return;
        }
        long now = System.currentTimeMillis();
        UUID id = p.getUniqueId();
        Long prev = this.durabilityWarnCooldown.get(id);
        if (prev != null && now - prev < 1200L) {
            return;
        }
        this.durabilityWarnCooldown.put(id, now);
        try {
            p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 0.9f, 1.2f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryTotemPreventDeath(EntityDamageEvent e) {
        double finalDamage;
        double health;
        if (!this.inventoryTotem) {
            return;
        }
        if (e == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (this.inventoryTotemSkipIfHeld && this.isHoldingTotem(p)) {
            return;
        }
        try {
            health = p.getHealth();
            finalDamage = e.getFinalDamage();
        }
        catch (Throwable ignored) {
            return;
        }
        if (health <= 0.0) {
            return;
        }
        if (health - finalDamage > 0.0) {
            return;
        }
        boolean used = this.consumeOneTotemFromPlayerStorage(p);
        if (!used) {
            return;
        }
        e.setCancelled(true);
        this.applyTotemRescueEffects(p);
        try {
            p.updateInventory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isHoldingTotem(Player p) {
        ItemStack off;
        ItemStack main;
        if (p == null) {
            return false;
        }
        try {
            main = p.getInventory().getItemInMainHand();
            off = p.getInventory().getItemInOffHand();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (!this.isEmpty(main) && main.getType() == Material.TOTEM_OF_UNDYING) {
            return true;
        }
        return !this.isEmpty(off) && off.getType() == Material.TOTEM_OF_UNDYING;
    }

    private boolean consumeOneTotemFromPlayerStorage(Player p) {
        if (p == null) {
            return false;
        }
        try {
            if (this.tryConsumeTotemInInventory((Inventory)p.getInventory(), this.inventoryTotemUseShulkers, this.inventoryTotemUseBundles, this.inventoryTotemBundleMaxDepth)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.inventoryTotemCheckEnderChest) {
            return false;
        }
        try {
            Inventory ec = p.getEnderChest();
            return this.tryConsumeTotemInInventory(ec, this.inventoryTotemUseShulkers, this.inventoryTotemUseBundles, this.inventoryTotemBundleMaxDepth);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean tryConsumeTotemInInventory(Inventory inv, boolean useShulkers, boolean useBundles, int bundleDepth) {
        ItemStack it;
        int slot;
        int size;
        if (inv == null) {
            return false;
        }
        try {
            size = inv.getSize();
        }
        catch (Throwable ignored) {
            return false;
        }
        for (slot = 0; slot < size; ++slot) {
            it = null;
            try {
                it = inv.getItem(slot);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.isEmpty(it) || it.getType() != Material.TOTEM_OF_UNDYING) continue;
            this.consumeOneInInventorySlot(inv, slot, it);
            return true;
        }
        if (useBundles && bundleDepth > 0) {
            for (slot = 0; slot < size; ++slot) {
                it = null;
                try {
                    it = inv.getItem(slot);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.isEmpty(it) || it.getType() != Material.BUNDLE || !this.consumeOneTotemFromBundleItem(it, bundleDepth)) continue;
                try {
                    inv.setItem(slot, it);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        }
        if (useShulkers) {
            for (slot = 0; slot < size; ++slot) {
                it = null;
                try {
                    it = inv.getItem(slot);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!this.isShulkerBoxItem(it) || !this.consumeOneTotemFromShulkerItem(it, useBundles, bundleDepth)) continue;
                try {
                    inv.setItem(slot, it);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    private void consumeOneInInventorySlot(Inventory inv, int slot, ItemStack it) {
        if (inv == null) {
            return;
        }
        if (slot < 0) {
            return;
        }
        if (this.isEmpty(it)) {
            return;
        }
        int amt = it.getAmount();
        if (amt <= 1) {
            try {
                inv.setItem(slot, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        ItemStack ns = it.clone();
        ns.setAmount(amt - 1);
        try {
            inv.setItem(slot, ns);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean consumeOneTotemFromShulkerItem(ItemStack boxItem, boolean useBundles, int bundleDepth) {
        ItemStack it;
        int slot;
        int size;
        Inventory shInv;
        if (!this.isShulkerBoxItem(boxItem)) {
            return false;
        }
        ItemMeta itemMeta = boxItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return false;
        }
        BlockStateMeta bsm = (BlockStateMeta)itemMeta;
        BlockState blockState = bsm.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return false;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        try {
            shInv = shulker.getInventory();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (shInv == null) {
            return false;
        }
        try {
            size = shInv.getSize();
        }
        catch (Throwable ignored) {
            return false;
        }
        for (slot = 0; slot < size; ++slot) {
            it = null;
            try {
                it = shInv.getItem(slot);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.isEmpty(it) || it.getType() != Material.TOTEM_OF_UNDYING) continue;
            this.consumeOneInInventorySlot(shInv, slot, it);
            try {
                bsm.setBlockState((BlockState)shulker);
                boxItem.setItemMeta((ItemMeta)bsm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        if (useBundles && bundleDepth > 0) {
            for (slot = 0; slot < size; ++slot) {
                it = null;
                try {
                    it = shInv.getItem(slot);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.isEmpty(it) || it.getType() != Material.BUNDLE || !this.consumeOneTotemFromBundleItem(it, bundleDepth)) continue;
                try {
                    shInv.setItem(slot, it);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    bsm.setBlockState((BlockState)shulker);
                    boxItem.setItemMeta((ItemMeta)bsm);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    private boolean consumeOneTotemFromBundleItem(ItemStack bundleItem, int depth) {
        List items;
        if (this.isEmpty(bundleItem)) {
            return false;
        }
        if (bundleItem.getType() != Material.BUNDLE) {
            return false;
        }
        if (depth <= 0) {
            return false;
        }
        ItemMeta itemMeta = bundleItem.getItemMeta();
        if (!(itemMeta instanceof BundleMeta)) {
            return false;
        }
        BundleMeta bm = (BundleMeta)itemMeta;
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (items == null || items.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(items.size());
        for (ItemStack it : items) {
            newItems.add(it == null ? null : it.clone());
        }
        for (int i = 0; i < newItems.size(); ++i) {
            ItemStack inside = (ItemStack)newItems.get(i);
            if (this.isEmpty(inside)) continue;
            if (inside.getType() == Material.TOTEM_OF_UNDYING) {
                int amt = inside.getAmount();
                if (amt <= 1) {
                    newItems.remove(i);
                } else {
                    inside.setAmount(amt - 1);
                    newItems.set(i, inside);
                }
                try {
                    bm.setItems(newItems);
                    bundleItem.setItemMeta((ItemMeta)bm);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (inside.getType() != Material.BUNDLE || depth <= 1 || !this.consumeOneTotemFromBundleItem(inside, depth - 1)) continue;
            newItems.set(i, inside);
            try {
                bm.setItems(newItems);
                bundleItem.setItemMeta((ItemMeta)bm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void applyTotemRescueEffects(Player p) {
        if (p == null) {
            return;
        }
        double maxHealth = 20.0;
        try {
            AttributeInstance attr = p.getAttribute(Attribute.MAX_HEALTH);
            if (attr != null) {
                maxHealth = attr.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxHealth < 1.0) {
            maxHealth = 1.0;
        }
        try {
            p.setHealth(Math.min(1.0, maxHealth));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (PotionEffect eff : p.getActivePotionEffects()) {
                if (eff == null) continue;
                p.removePotionEffect(eff.getType());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 800, 1, true, true));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1, true, true));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0, true, true));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.setNoDamageTicks(40);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.setFallDistance(0.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.playEffect(EntityEffect.PROTECTED_FROM_DEATH);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.getWorld().playSound(p.getLocation(), Sound.ITEM_TOTEM_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, p.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static long posKey(Block b) {
        return GGQOL.posKey(b.getX(), b.getY(), b.getZ());
    }

    private static long posKey(int x, int y, int z) {
        return (long)(x & 0x3FFFFFF) << 38 | (long)(z & 0x3FFFFFF) << 12 | (long)(y & 0xFFF);
    }

    private Block getSugarCaneBase(Block anyCane) {
        Block below;
        if (anyCane == null) {
            return null;
        }
        if (anyCane.getType() != Material.SUGAR_CANE) {
            return anyCane;
        }
        Block cur = anyCane;
        int minY = cur.getWorld().getMinHeight();
        while (cur.getY() > minY && (below = cur.getRelative(BlockFace.DOWN)).getType() == Material.SUGAR_CANE) {
            cur = below;
        }
        return cur;
    }

    private Location getPinLocationForCane(Block anyCane) {
        Block base = this.getSugarCaneBase(anyCane);
        if (base == null) {
            return null;
        }
        return base.getLocation().add(0.5, 0.2, 0.5);
    }

    private void pinExistingItem(Item item, Location pinLoc) {
        if (item == null || pinLoc == null) {
            return;
        }
        try {
            item.setVelocity(new Vector(0, 0, 0));
            item.teleport(pinLoc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, pinLoc, t -> {
            try {
                if (!item.isValid()) {
                    return;
                }
                item.setVelocity(new Vector(0, 0, 0));
                item.teleport(pinLoc);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtendMarkCane(BlockPistonExtendEvent e) {
        Block piston = e.getBlock();
        if (piston == null) {
            return;
        }
        BlockFace dir = e.getDirection();
        if (dir == null) {
            return;
        }
        Block hit = piston.getRelative(dir);
        if (hit == null) {
            return;
        }
        if (hit.getType() != Material.SUGAR_CANE) {
            return;
        }
        Location pinLoc = this.getPinLocationForCane(hit);
        if (pinLoc == null) {
            return;
        }
        long expires = System.nanoTime() + 400000000L;
        ConcurrentHashMap<Long, PinnedDrop> map = this.pins(hit.getWorld());
        Block cur = hit;
        while (cur.getType() == Material.SUGAR_CANE) {
            map.put(GGQOL.posKey(cur), new PinnedDrop(pinLoc.clone(), expires));
            if ((cur = cur.getRelative(BlockFace.UP)).getY() < cur.getWorld().getMaxHeight()) continue;
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemSpawnPinCane(ItemSpawnEvent e) {
        Location at;
        Block b;
        Item it = e.getEntity();
        if (it == null) {
            return;
        }
        if (it.getItemStack() == null) {
            return;
        }
        if (it.getItemStack().getType() != Material.SUGAR_CANE) {
            return;
        }
        World w = it.getWorld();
        ConcurrentHashMap<Long, PinnedDrop> map = this.pins(w);
        PinnedDrop pd = map.remove(GGQOL.posKey(b = (at = it.getLocation()).getBlock()));
        if (pd == null) {
            pd = map.remove(GGQOL.posKey(b.getRelative(BlockFace.DOWN)));
        }
        if (pd == null) {
            pd = map.remove(GGQOL.posKey(b.getRelative(BlockFace.UP)));
        }
        if (pd == null) {
            return;
        }
        if (System.nanoTime() > pd.expiresAtNanos) {
            return;
        }
        Location pinLoc = pd.pinLoc;
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, at, t -> this.pinExistingItem(it, pinLoc), 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSilkTouchRecoverBlocks(BlockBreakEvent e) {
        ItemStack shulkerItem;
        if (!this.silkTouchRecoverBlocks) {
            return;
        }
        if (e == null) {
            return;
        }
        if (!e.isDropItems()) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!this.silkTouchRecoverAllowCreative && p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block b = e.getBlock();
        if (b == null) {
            return;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (this.isEmpty(tool)) {
            return;
        }
        int silk = 0;
        try {
            silk = tool.getEnchantmentLevel(Enchantment.SILK_TOUCH);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (silk <= 0) {
            return;
        }
        Material type = b.getType();
        if (type == null || type.isAir()) {
            return;
        }
        if (this.silkTouchRecoverBlacklist.contains(type)) {
            return;
        }
        if (type == Material.SPAWNER || type == Material.TRIAL_SPAWNER) {
            this.handleSilkTouchSpawnerBreak(e, p, b);
            return;
        }
        List<ItemStack> inventoryContents = this.collectInventoryBlockContents(b);
        e.setDropItems(true);
        e.setExpToDrop(0);
        String typeName = type.name();
        if (typeName.endsWith("SHULKER_BOX") && (shulkerItem = this.createShulkerBoxItemWithContents(b)) != null) {
            UUID trackerId = UUID.randomUUID();
            long expiresAt = System.nanoTime() + 200000000L;
            ArrayList<Material> shulkerMats = new ArrayList<Material>();
            shulkerMats.add(type);
            this.silkTouchBreaks.put(trackerId, new SilkTouchBreakTracker(b.getLocation().clone(), p.getUniqueId(), expiresAt, shulkerMats));
            UUID tid = trackerId;
            Bukkit.getRegionScheduler().runDelayed((Plugin)this, b.getLocation(), t -> {
                Player player;
                SilkTouchBreakTracker tracker = this.silkTouchBreaks.remove(tid);
                if (tracker != null && (player = Bukkit.getPlayer((UUID)tracker.playerId)) != null) {
                    this.giveOrDropNow(player, shulkerItem, tracker.location);
                }
            }, 3L);
            return;
        }
        Material itemType = this.convertBlockToItemMaterial(type);
        UUID trackerId = UUID.randomUUID();
        long expiresAt = System.nanoTime() + 200000000L;
        ArrayList<Material> blockDropTypes = new ArrayList<Material>();
        try {
            Collection drops = b.getDrops(tool, (Entity)p);
            if (drops != null) {
                Iterator iterator = drops.iterator();
                while (iterator.hasNext()) {
                    ItemStack drop = (ItemStack)iterator.next();
                    if (this.isEmpty(drop)) continue;
                    blockDropTypes.add(drop.getType());
                }
            }
        }
        catch (Throwable drops) {
            // empty catch block
        }
        for (ItemStack item : inventoryContents) {
            if (this.isEmpty(item)) continue;
            blockDropTypes.add(item.getType());
        }
        this.silkTouchBreaks.put(trackerId, new SilkTouchBreakTracker(b.getLocation().clone(), p.getUniqueId(), expiresAt, blockDropTypes));
        UUID tid = trackerId;
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, b.getLocation(), t -> {
            SilkTouchBreakTracker tracker = this.silkTouchBreaks.remove(tid);
            if (tracker == null) {
                return;
            }
            Player player = Bukkit.getPlayer((UUID)tracker.playerId);
            if (player == null) {
                return;
            }
            ItemStack blockItem = null;
            try {
                blockItem = new ItemStack(itemType, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (blockItem != null && !blockItem.getType().isAir()) {
                this.giveOrDropNow(player, blockItem, tracker.location);
            }
            for (ItemStack item : inventoryContents) {
                if (this.isEmpty(item)) continue;
                this.giveOrDropNow(player, item, tracker.location);
            }
        }, 3L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSpawnFromSilkTouch(ItemSpawnEvent e) {
        if (!this.silkTouchRecoverBlocks) {
            return;
        }
        if (e == null) {
            return;
        }
        Item itemEnt = e.getEntity();
        if (itemEnt == null) {
            return;
        }
        Location loc = itemEnt.getLocation();
        if (loc == null) {
            return;
        }
        ItemStack stack = itemEnt.getItemStack();
        if (this.isEmpty(stack)) {
            return;
        }
        long now = System.nanoTime();
        for (Map.Entry<UUID, SilkTouchBreakTracker> entry : this.silkTouchBreaks.entrySet()) {
            SilkTouchBreakTracker tracker = entry.getValue();
            if (tracker == null || now > tracker.expiresAtNanos || tracker.location.getWorld() != loc.getWorld() || tracker.location.distanceSquared(loc) > 16.0 || tracker.dropTypes == null || !tracker.dropTypes.contains(stack.getType())) continue;
            e.setCancelled(true);
            return;
        }
    }

    private Material convertBlockToItemMaterial(Material blockType) {
        return blockType;
    }

    private List<ItemStack> collectInventoryBlockContents(Block block) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (block == null) {
            return contents;
        }
        Material type = block.getType();
        if (type == null) {
            return contents;
        }
        String typeName = type.name();
        if (typeName.endsWith("SHULKER_BOX")) {
            return contents;
        }
        if (type == Material.ENDER_CHEST) {
            return contents;
        }
        try {
            ItemStack[] items;
            Container container;
            Inventory inv;
            BlockState state = block.getState();
            if (state instanceof Container && (inv = (container = (Container)state).getInventory()) != null && (items = inv.getContents()) != null) {
                for (ItemStack item : items) {
                    if (this.isEmpty(item)) continue;
                    contents.add(item.clone());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return contents;
    }

    private ItemStack createShulkerBoxItemWithContents(Block block) {
        if (block == null) {
            return null;
        }
        Material type = block.getType();
        String typeName = type.name();
        if (!typeName.endsWith("SHULKER_BOX")) {
            return null;
        }
        try {
            BlockState blockState = block.getState();
            if (!(blockState instanceof ShulkerBox)) {
                return null;
            }
            ShulkerBox shulker = (ShulkerBox)blockState;
            ItemStack item = new ItemStack(type, 1);
            ItemMeta itemMeta = item.getItemMeta();
            if (!(itemMeta instanceof BlockStateMeta)) {
                return null;
            }
            BlockStateMeta meta = (BlockStateMeta)itemMeta;
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void handleSilkTouchSpawnerBreak(BlockBreakEvent e, Player p, Block b) {
        Material egg;
        if (e == null || p == null || b == null) {
            return;
        }
        e.setDropItems(false);
        e.setExpToDrop(0);
        Location dropAt = b.getLocation();
        EntityType spawned = null;
        try {
            BlockState blockState = b.getState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner cs = (CreatureSpawner)blockState;
                spawned = cs.getSpawnedType();
            } else {
                blockState = b.getState();
                if (blockState instanceof TrialSpawner) {
                    TrialSpawnerConfiguration config;
                    TrialSpawner ts = (TrialSpawner)blockState;
                    TrialSpawnerConfiguration trialSpawnerConfiguration = config = ts.isOminous() ? ts.getOminousConfiguration() : ts.getNormalConfiguration();
                    if (config != null) {
                        spawned = config.getSpawnedType();
                    }
                }
            }
        }
        catch (Throwable cs) {
            // empty catch block
        }
        if (this.silkTouchSpawnerDropSpawner) {
            this.giveOrDropNow(p, new ItemStack(b.getType(), 1), dropAt);
        }
        if (this.silkTouchSpawnerDropEgg && this.silkTouchSpawnerEggAmount > 0 && spawned != null && (egg = this.spawnEggMaterial(spawned)) != null && egg != Material.AIR) {
            int amt = this.silkTouchSpawnerEggAmount;
            if (amt > 64) {
                amt = 64;
            }
            if (amt > 0) {
                this.giveOrDropNow(p, new ItemStack(egg, amt), dropAt);
            }
        }
    }

    private Material spawnEggMaterial(EntityType type) {
        String name;
        if (type == null) {
            return null;
        }
        try {
            name = type.name() + "_SPAWN_EGG";
        }
        catch (Throwable ignored) {
            return null;
        }
        try {
            return Material.matchMaterial((String)name);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void giveOrDropNow(Player p, ItemStack stack, Location dropAt) {
        HashMap left;
        if (p == null) {
            return;
        }
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            left = p.getInventory().addItem(new ItemStack[]{stack});
        }
        catch (Throwable ignored) {
            left = new HashMap();
            left.put(0, stack);
        }
        if (left == null || left.isEmpty()) {
            return;
        }
        World w = p.getWorld();
        Location at = dropAt == null ? p.getLocation() : dropAt;
        for (ItemStack lf : left.values()) {
            if (this.isEmpty(lf)) continue;
            try {
                w.dropItemNaturally(at, lf);
            }
            catch (Throwable throwable) {}
        }
    }

    private EnumSet<Material> loadMaterialSet(String path, Set<Material> defaults) {
        List list;
        EnumSet<Material> out = EnumSet.noneOf(Material.class);
        try {
            list = this.getConfig().getStringList(path);
        }
        catch (Throwable ignored) {
            list = null;
        }
        if (list == null || list.isEmpty()) {
            if (defaults != null) {
                out.addAll(defaults);
            }
            return out;
        }
        for (String s : list) {
            String raw;
            if (s == null || (raw = s.trim()).isEmpty()) continue;
            String up = raw.toUpperCase(Locale.ROOT);
            Material m = null;
            try {
                m = Material.matchMaterial((String)up);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m == null) {
                try {
                    m = Material.valueOf((String)up);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (m == null) continue;
            out.add(m);
        }
        if (out.isEmpty() && defaults != null) {
            out.addAll(defaults);
        }
        return out;
    }

    private void initPacketEvents() {
        try {
            PacketEvents.getAPI().init();
            this.bundleScrollPacketListener = new BundleScrollPacketListener();
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.bundleScrollPacketListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void terminatePacketEvents() {
        block6: {
            try {
                if (this.bundleScrollPacketListener == null) break block6;
                try {
                    PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.bundleScrollPacketListener);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.bundleScrollPacketListener = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            PacketEvents.getAPI().terminate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int safeGetSelectBundleSlot(WrapperPlayClientSelectBundleItem w) {
        try {
            return w.getSlotId();
        }
        catch (Throwable ignored) {
            return -1;
        }
    }

    private int safeGetSelectBundleIndex(WrapperPlayClientSelectBundleItem w) {
        try {
            return w.getSelectedItemIndex();
        }
        catch (Throwable ignored) {
            return -1;
        }
    }

    private void queueBundleScrollWork(Player p, int slotId, int selectedIndex) {
        if (p == null) {
            return;
        }
        p.getScheduler().run((Plugin)this, t -> this.handleBundleScrollSelect(p, slotId, selectedIndex), null);
    }

    private void handleBundleScrollSelect(Player p, int slotId, int selectedIndex) {
        boolean upWrap;
        List stacks;
        BundleMeta bm;
        InventoryView view;
        if (!this.bundleScroll) {
            return;
        }
        if (p == null) {
            return;
        }
        if (slotId < 0) {
            return;
        }
        try {
            view = p.getOpenInventory();
        }
        catch (Throwable ignored) {
            return;
        }
        if (view == null) {
            return;
        }
        int viewRawSlot = this.resolveBundleViewRawSlot(p, view, slotId);
        if (viewRawSlot < 0) {
            return;
        }
        ItemStack bundleItem = this.safeGetViewItem(view, viewRawSlot);
        if (!this.isBundleItem(bundleItem)) {
            return;
        }
        try {
            bm = (BundleMeta)bundleItem.getItemMeta();
        }
        catch (Throwable ignored) {
            return;
        }
        if (bm == null) {
            return;
        }
        try {
            stacks = bm.getItems();
        }
        catch (Throwable ignored) {
            return;
        }
        if (stacks == null) {
            return;
        }
        int stackCount = stacks.size();
        if (stackCount < this.bundleScrollMinStacks) {
            return;
        }
        int window = this.clampInt(this.bundleScrollWindowSize, 1, 64);
        int visibleCount = Math.min(window, stackCount);
        int lastVisible = visibleCount - 1;
        if (lastVisible < 0) {
            return;
        }
        if (selectedIndex < 0 || selectedIndex > lastVisible) {
            return;
        }
        UUID pid = p.getUniqueId();
        BundleScrollState state = this.getBundleScrollState(pid, 0, viewRawSlot);
        long now = System.nanoTime();
        boolean downWrap = state.lastIndex == lastVisible && selectedIndex == 0;
        boolean bl = upWrap = state.lastIndex == 0 && selectedIndex == lastVisible;
        if (downWrap || upWrap) {
            if (now - state.lastRotateNanos < this.bundleScrollCooldownNanos) {
                state.lastIndex = selectedIndex;
                return;
            }
            state.lastRotateNanos = now;
            state.lastIndex = selectedIndex;
            int pages = this.clampInt(this.bundleScrollStep, 1, 64);
            int pageShift = Math.max(1, visibleCount) * pages;
            boolean changed = downWrap ? this.rotateBundleMetaLeft(bm, pageShift) : this.rotateBundleMetaRight(bm, pageShift);
            if (changed) {
                ItemStack updated = bundleItem.clone();
                updated.setItemMeta((ItemMeta)bm);
                this.safeSetViewItem(view, viewRawSlot, updated);
                try {
                    p.updateInventory();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (selectedIndex != state.lastIndex) {
            state.lastIndex = selectedIndex;
            return;
        }
    }

    private int resolveBundleViewRawSlot(Player p, InventoryView view, int slotId) {
        ItemStack mapped;
        int raw;
        ItemStack direct;
        int bottomSize;
        int topSize;
        if (p == null || view == null) {
            return -1;
        }
        if (slotId < 0) {
            return -1;
        }
        try {
            topSize = view.getTopInventory() == null ? 0 : view.getTopInventory().getSize();
        }
        catch (Throwable ignored) {
            topSize = 0;
        }
        try {
            bottomSize = view.getBottomInventory() == null ? 0 : view.getBottomInventory().getSize();
        }
        catch (Throwable ignored) {
            bottomSize = 0;
        }
        int maxRaw = topSize + bottomSize - 1;
        if (slotId >= 0 && slotId <= maxRaw && this.isBundleItem(direct = this.safeGetViewItem(view, slotId))) {
            return slotId;
        }
        int bottomIndex = this.protocolSlotToBottomIndex(slotId, bottomSize);
        if (bottomIndex >= 0 && (raw = topSize + bottomIndex) >= 0 && raw <= maxRaw && this.isBundleItem(mapped = this.safeGetViewItem(view, raw))) {
            return raw;
        }
        return -1;
    }

    private int protocolSlotToBottomIndex(int slotId, int bottomSize) {
        if (bottomSize <= 0) {
            return -1;
        }
        if (slotId >= 36 && slotId <= 44) {
            int idx = slotId - 36;
            return idx < bottomSize ? idx : -1;
        }
        if (slotId >= 9 && slotId <= 35) {
            int idx = slotId;
            return idx < bottomSize ? idx : -1;
        }
        if (slotId == 45) {
            int idx = 40;
            return idx < bottomSize ? idx : -1;
        }
        return -1;
    }

    private BundleScrollState getBundleScrollState(UUID playerId, int containerId, int rawSlot) {
        if (playerId == null) {
            return new BundleScrollState();
        }
        long key = this.bundleScrollKey(containerId, rawSlot);
        ConcurrentHashMap perPlayer = this.bundleScrollStates.computeIfAbsent(playerId, k -> new ConcurrentHashMap());
        return perPlayer.computeIfAbsent(key, k -> new BundleScrollState());
    }

    private long bundleScrollKey(int containerId, int rawSlot) {
        return (long)containerId << 32 ^ (long)rawSlot & 0xFFFFFFFFL;
    }

    private boolean rotateBundleMetaLeft(BundleMeta bm, int shift) {
        List items;
        if (bm == null) {
            return false;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (items == null) {
            return false;
        }
        int n = items.size();
        if (n <= 1) {
            return false;
        }
        int s = shift;
        if (s < 0) {
            s = -s;
        }
        if (s == 0) {
            return false;
        }
        if ((s %= n) == 0) {
            return false;
        }
        ArrayList<ItemStack> rotated = new ArrayList<ItemStack>(n);
        for (int i = 0; i < n; ++i) {
            rotated.add((ItemStack)items.get((i + s) % n));
        }
        try {
            bm.setItems(rotated);
        }
        catch (Throwable ignored) {
            return false;
        }
        return true;
    }

    private boolean rotateBundleMetaRight(BundleMeta bm, int shift) {
        List items;
        if (bm == null) {
            return false;
        }
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (items == null) {
            return false;
        }
        int n = items.size();
        if (n <= 1) {
            return false;
        }
        int s = shift;
        if (s < 0) {
            s = -s;
        }
        if (s == 0) {
            return false;
        }
        if ((s %= n) == 0) {
            return false;
        }
        return this.rotateBundleMetaLeft(bm, n - s);
    }

    private ItemStack safeGetViewItem(InventoryView view, int rawSlot) {
        Inventory bottom;
        Inventory top;
        if (view == null) {
            return null;
        }
        if (rawSlot < 0) {
            return null;
        }
        try {
            top = view.getTopInventory();
            bottom = view.getBottomInventory();
        }
        catch (Throwable ignored) {
            return null;
        }
        int topSize = 0;
        try {
            topSize = top == null ? 0 : top.getSize();
        }
        catch (Throwable ignored) {
            topSize = 0;
        }
        if (rawSlot < topSize) {
            try {
                return top.getItem(rawSlot);
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        int bSlot = rawSlot - topSize;
        if (bottom == null) {
            return null;
        }
        int bSize = 0;
        try {
            bSize = bottom.getSize();
        }
        catch (Throwable ignored) {
            bSize = 0;
        }
        if (bSlot < 0 || bSlot >= bSize) {
            return null;
        }
        try {
            return bottom.getItem(bSlot);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void safeSetViewItem(InventoryView view, int rawSlot, ItemStack item) {
        Inventory bottom;
        Inventory top;
        if (view == null) {
            return;
        }
        if (rawSlot < 0) {
            return;
        }
        try {
            top = view.getTopInventory();
            bottom = view.getBottomInventory();
        }
        catch (Throwable ignored) {
            return;
        }
        int topSize = 0;
        try {
            topSize = top == null ? 0 : top.getSize();
        }
        catch (Throwable ignored) {
            topSize = 0;
        }
        if (rawSlot < topSize) {
            try {
                top.setItem(rawSlot, item);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return;
        }
        int bSlot = rawSlot - topSize;
        if (bottom == null) {
            return;
        }
        int bSize = 0;
        try {
            bSize = bottom.getSize();
        }
        catch (Throwable ignored) {
            bSize = 0;
        }
        if (bSlot < 0 || bSlot >= bSize) {
            return;
        }
        try {
            bottom.setItem(bSlot, item);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMudBottleUseSpread(PlayerInteractEvent e) {
        ItemStack main;
        if (!this.mudSpread) {
            return;
        }
        if (e == null) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EquipmentSlot hand = e.getHand();
        if (hand == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (hand == EquipmentSlot.OFF_HAND && this.isWaterBottle(main = p.getInventory().getItemInMainHand())) {
            return;
        }
        ItemStack held = e.getItem();
        if (!this.isWaterBottle(held)) {
            return;
        }
        Block clicked = e.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (clicked.getType() != Material.DIRT) {
            return;
        }
        World world = clicked.getWorld();
        UUID wid = world.getUID();
        int x = clicked.getX();
        int y = clicked.getY();
        int z = clicked.getZ();
        int cx = x >> 4;
        int cz = z >> 4;
        Bukkit.getRegionScheduler().runDelayed((Plugin)this, world, cx, cz, t -> this.mudSpreadAfterVanilla(wid, x, y, z), 1L);
    }

    private boolean isWaterBottle(ItemStack it) {
        PotionType base;
        if (this.isEmpty(it)) {
            return false;
        }
        if (it.getType() != Material.POTION) {
            return false;
        }
        ItemMeta meta = it.getItemMeta();
        if (!(meta instanceof PotionMeta)) {
            return false;
        }
        PotionMeta pm = (PotionMeta)meta;
        try {
            base = pm.getBasePotionType();
        }
        catch (Throwable ignored) {
            return false;
        }
        return base == PotionType.WATER;
    }

    private void mudSpreadAfterVanilla(UUID worldId, int x, int y, int z) {
        if (!this.mudSpread) {
            return;
        }
        if (this.mudSpreadRange <= 0) {
            return;
        }
        World w = Bukkit.getWorld((UUID)worldId);
        if (w == null) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            return;
        }
        Block b = w.getBlockAt(x, y, z);
        if (b.getType() != Material.MUD) {
            return;
        }
        this.startMudSpreadFromMudBlock(worldId, x, y, z);
    }

    private void startMudSpreadFromMudBlock(UUID worldId, int x, int y, int z) {
        if (!this.mudSpread) {
            return;
        }
        int range = this.mudSpreadRange;
        if (range <= 0) {
            return;
        }
        long jobKey = this.blockKey(worldId, x, y, z);
        MudSpreadJob job = new MudSpreadJob(worldId, x, y, z, range);
        MudSpreadJob existing = this.mudSpreadJobs.putIfAbsent(jobKey, job);
        if (existing != null) {
            return;
        }
        World w = Bukkit.getWorld((UUID)worldId);
        if (w == null) {
            this.mudSpreadJobs.remove(jobKey);
            return;
        }
        job.visited.add(jobKey);
        if (range >= 1) {
            int ox = job.originX;
            int oy = job.originY;
            int oz = job.originZ;
            this.enqueueMudNode(w, job, ox + 1, oy, oz, 1);
            this.enqueueMudNode(w, job, ox - 1, oy, oz, 1);
            this.enqueueMudNode(w, job, ox, oy, oz + 1, 1);
            this.enqueueMudNode(w, job, ox, oy, oz - 1, 1);
        }
        if (job.queue.isEmpty()) {
            this.mudSpreadJobs.remove(jobKey);
            return;
        }
        this.scheduleNextMudSpreadTick(jobKey, 1L);
    }

    private void scheduleNextMudSpreadTick(long jobKey, long delayTicks) {
        ScheduledTask t;
        MudSpreadJob job = this.mudSpreadJobs.get(jobKey);
        if (job == null) {
            return;
        }
        World w = Bukkit.getWorld((UUID)job.worldId);
        if (w == null) {
            return;
        }
        int cx = job.originX >> 4;
        int cz = job.originZ >> 4;
        job.task = t = Bukkit.getRegionScheduler().runDelayed((Plugin)this, w, cx, cz, st -> {
            if (!this.mudSpread) {
                return;
            }
            if (this.mudSpreadRange <= 0) {
                return;
            }
            if (!this.mudSpreadJobs.containsKey(jobKey)) {
                return;
            }
            this.mudSpreadTick(jobKey);
        }, GGQOL.sanitizeTicks(delayTicks));
    }

    private void enqueueMudNode(World w, MudSpreadJob job, int x, int y, int z, int dist) {
        if (job == null) {
            return;
        }
        if (dist > job.range) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            return;
        }
        long k = this.blockKey(job.worldId, x, y, z);
        if (!job.visited.add(k)) {
            return;
        }
        job.queue.addLast(new MudNode(x, y, z, dist));
    }

    private void mudSpreadTick(long jobKey) {
        MudNode node;
        MudSpreadJob job = this.mudSpreadJobs.get(jobKey);
        if (job == null) {
            return;
        }
        job.task = null;
        if (!this.mudSpread || this.mudSpreadRange <= 0) {
            this.stopMudSpreadJob(jobKey);
            return;
        }
        World w = Bukkit.getWorld((UUID)job.worldId);
        if (w == null) {
            this.stopMudSpreadJob(jobKey);
            return;
        }
        int perStep = this.mudSpreadBlocksPerStep;
        if (perStep < 1) {
            perStep = 1;
        }
        for (int i = 0; i < perStep && (node = job.queue.pollFirst()) != null; ++i) {
            this.mudSpreadProcessNode(jobKey, job, w, node.x(), node.y(), node.z(), node.dist());
        }
        if (!this.mudSpreadJobs.containsKey(jobKey)) {
            return;
        }
        if (job.queue.isEmpty()) {
            this.stopMudSpreadJob(jobKey);
            return;
        }
        long periodTicks = GGQOL.sanitizeTicks(this.mudSpreadStepIntervalTicks);
        this.scheduleNextMudSpreadTick(jobKey, periodTicks);
    }

    private void stopMudSpreadJob(long jobKey) {
        MudSpreadJob job = this.mudSpreadJobs.remove(jobKey);
        if (job == null) {
            return;
        }
        ScheduledTask t = job.task;
        job.task = null;
        if (t != null) {
            try {
                t.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void cancelMudSpreadTasks() {
        for (MudSpreadJob job : this.mudSpreadJobs.values()) {
            if (job == null) continue;
            ScheduledTask t = job.task;
            job.task = null;
            if (t == null) continue;
            try {
                t.cancel();
            }
            catch (Throwable throwable) {}
        }
        this.mudSpreadJobs.clear();
    }

    private void mudSpreadProcessNode(long jobKey, MudSpreadJob job, World w, int x, int y, int z, int dist) {
        if (job == null) {
            return;
        }
        if (!this.mudSpread) {
            return;
        }
        if (dist > job.range) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (!w.isChunkLoaded(cx, cz)) {
            return;
        }
        Block b = w.getBlockAt(x, y, z);
        Material t = b.getType();
        if (t == Material.DIRT) {
            b.setType(Material.MUD, false);
        } else if (t != Material.MUD) {
            return;
        }
        if (dist >= job.range) {
            return;
        }
        int nd = dist + 1;
        this.enqueueMudNode(w, job, x + 1, y, z, nd);
        this.enqueueMudNode(w, job, x - 1, y, z, nd);
        this.enqueueMudNode(w, job, x, y, z + 1, nd);
        this.enqueueMudNode(w, job, x, y, z - 1, nd);
    }

    private long blockKey(UUID worldId, int xIn, int yIn, int zIn) {
        long x = (long)xIn & 0x3FFFFFFL;
        long y = (long)yIn & 0xFFFL;
        long z = (long)zIn & 0x3FFFFFFL;
        long pos = x << 38 | z << 12 | y;
        return pos ^ worldId.getMostSignificantBits() ^ worldId.getLeastSignificantBits();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemSpawnConcretePowderWater(ItemSpawnEvent e) {
        if (!this.concretePowderInWater) {
            return;
        }
        if (e == null) {
            return;
        }
        Item item = e.getEntity();
        if (item == null) {
            return;
        }
        if (!this.isConcreteConvertCandidate(item.getItemStack())) {
            return;
        }
        this.startConcretePowderPoll(item, 0);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityAddConcretePowderWater(EntityAddToWorldEvent e) {
        if (!this.concretePowderInWater) {
            return;
        }
        if (e == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        if (!this.isConcreteConvertCandidate(item.getItemStack())) {
            return;
        }
        this.startConcretePowderPoll(item, 0);
    }

    private boolean isConcreteConvertCandidate(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        if (POWDER_TO_CONCRETE.containsKey(stack.getType())) {
            return true;
        }
        if (this.concretePowderInWaterUseShulkers && this.isShulkerBoxItem(stack)) {
            return true;
        }
        return this.concretePowderInWaterUseBundles && this.isBundleItem(stack);
    }

    private void startConcretePowderPoll(Item item, int ticksElapsed) {
        if (item == null) {
            return;
        }
        UUID id = item.getUniqueId();
        if (!this.concretePowderPollActive.add(id)) {
            return;
        }
        this.scheduleConcretePowderPoll(item, ticksElapsed);
    }

    private void scheduleConcretePowderPoll(Item item, int ticksElapsed) {
        if (item == null) {
            return;
        }
        try {
            item.getScheduler().runDelayed((Plugin)this, t -> {
                this.concretePowderPollActive.remove(item.getUniqueId());
                this.tickConcretePowderPoll(item, ticksElapsed + 2);
            }, null, 2L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void tickConcretePowderPoll(Item item, int ticksElapsed) {
        Location loc;
        if (!this.concretePowderInWater) {
            return;
        }
        try {
            if (!item.isValid()) {
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        try {
            loc = item.getLocation();
        }
        catch (Throwable ignored) {
            return;
        }
        if (this.isItemInWaterSource(loc)) {
            this.doConcreteConvert(item, loc);
            return;
        }
        if (ticksElapsed >= 60) {
            return;
        }
        UUID id = item.getUniqueId();
        if (!this.concretePowderPollActive.add(id)) {
            return;
        }
        this.scheduleConcretePowderPoll(item, ticksElapsed);
    }

    private boolean isItemInWaterSource(Location loc) {
        if (loc == null) {
            return false;
        }
        World w = loc.getWorld();
        if (w == null) {
            return false;
        }
        Block at = w.getBlockAt(loc);
        if (this.isWaterSource(at)) {
            return true;
        }
        Block below = at.getRelative(BlockFace.DOWN);
        return this.isWaterSource(below);
    }

    private void doConcreteConvert(Item item, Location loc) {
        ItemStack copy;
        ItemStack original;
        if (item == null || loc == null) {
            return;
        }
        try {
            original = item.getItemStack();
        }
        catch (Throwable ignored) {
            return;
        }
        if (this.isEmpty(original)) {
            return;
        }
        Material concreteMat = POWDER_TO_CONCRETE.get(original.getType());
        if (concreteMat != null) {
            int amount = original.getAmount();
            try {
                item.remove();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spawnConcreteItem(loc, new ItemStack(concreteMat, amount));
            this.spawnConcreteConvertEffect(loc.clone().add(0.5, 0.5, 0.5));
            return;
        }
        ItemStack converted = null;
        if (this.concretePowderInWaterUseShulkers && this.isShulkerBoxItem(original)) {
            ItemStack copy2 = original.clone();
            if (this.convertConcretePowderInShulkerItem(copy2)) {
                converted = copy2;
            }
        } else if (this.concretePowderInWaterUseBundles && this.isBundleItem(original) && this.convertConcretePowderInBundleItem(copy = original.clone(), this.concretePowderInWaterBundleMaxDepth)) {
            converted = copy;
        }
        if (converted == null) {
            return;
        }
        try {
            item.setItemStack(converted);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.spawnConcreteConvertEffect(loc.clone().add(0.5, 0.5, 0.5));
    }

    private void spawnConcreteItem(Location loc, ItemStack stack) {
        if (loc == null || this.isEmpty(stack)) {
            return;
        }
        World w = loc.getWorld();
        if (w == null) {
            return;
        }
        try {
            Item spawned = w.dropItem(loc, stack);
            spawned.setVelocity(new Vector(0, 0, 0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean convertConcretePowderInShulkerItem(ItemStack boxItem) {
        if (!this.isShulkerBoxItem(boxItem)) {
            return false;
        }
        ItemMeta itemMeta = boxItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return false;
        }
        BlockStateMeta bsm = (BlockStateMeta)itemMeta;
        BlockState blockState = bsm.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return false;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        Inventory inv = shulker.getInventory();
        boolean changed = false;
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack bundleCopy;
            ItemStack it;
            try {
                it = inv.getItem(slot);
            }
            catch (Throwable ignored) {
                continue;
            }
            if (this.isEmpty(it)) continue;
            Material concrete = POWDER_TO_CONCRETE.get(it.getType());
            if (concrete != null) {
                try {
                    inv.setItem(slot, new ItemStack(concrete, it.getAmount()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                changed = true;
                continue;
            }
            if (!this.concretePowderInWaterUseBundles || !this.isBundleItem(it) || !this.convertConcretePowderInBundleItem(bundleCopy = it.clone(), this.concretePowderInWaterBundleMaxDepth)) continue;
            try {
                inv.setItem(slot, bundleCopy);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            changed = true;
        }
        if (changed) {
            try {
                bsm.setBlockState((BlockState)shulker);
                boxItem.setItemMeta((ItemMeta)bsm);
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        return changed;
    }

    private boolean convertConcretePowderInBundleItem(ItemStack bundleItem, int depth) {
        List items;
        if (!this.isBundleItem(bundleItem)) {
            return false;
        }
        if (depth <= 0) {
            return false;
        }
        ItemMeta itemMeta = bundleItem.getItemMeta();
        if (!(itemMeta instanceof BundleMeta)) {
            return false;
        }
        BundleMeta bm = (BundleMeta)itemMeta;
        try {
            items = bm.getItems();
        }
        catch (Throwable ignored) {
            return false;
        }
        if (items == null || items.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(items.size());
        boolean changed = false;
        for (ItemStack it : items) {
            ItemStack shulkerCopy;
            ItemStack nested;
            if (this.isEmpty(it)) {
                newItems.add(it);
                continue;
            }
            Material concrete = POWDER_TO_CONCRETE.get(it.getType());
            if (concrete != null) {
                newItems.add(new ItemStack(concrete, it.getAmount()));
                changed = true;
                continue;
            }
            if (this.concretePowderInWaterUseBundles && depth > 1 && this.isBundleItem(it) && this.convertConcretePowderInBundleItem(nested = it.clone(), depth - 1)) {
                newItems.add(nested);
                changed = true;
                continue;
            }
            if (this.concretePowderInWaterUseShulkers && this.isShulkerBoxItem(it) && this.convertConcretePowderInShulkerItem(shulkerCopy = it.clone())) {
                newItems.add(shulkerCopy);
                changed = true;
                continue;
            }
            newItems.add(it);
        }
        if (changed) {
            try {
                bm.setItems(newItems);
                bundleItem.setItemMeta((ItemMeta)bm);
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        return changed;
    }

    private boolean isWaterSource(Block block) {
        if (block == null) {
            return false;
        }
        if (block.getType() != Material.WATER) {
            return false;
        }
        BlockData bd = block.getBlockData();
        if (bd instanceof Levelled) {
            Levelled levelled = (Levelled)bd;
            return levelled.getLevel() == 0;
        }
        return false;
    }

    private void spawnConcreteConvertEffect(Location loc) {
        if (loc == null) {
            return;
        }
        World w = loc.getWorld();
        if (w == null) {
            return;
        }
        try {
            w.playSound(loc, Sound.BLOCK_SAND_PLACE, SoundCategory.BLOCKS, 0.8f, 1.3f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            w.spawnParticle(Particle.SPLASH, loc, 6, 0.15, 0.15, 0.15, 0.04);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFarmlandFadeProtect(BlockFadeEvent e) {
        if (!this.pistonProtectFarmland) {
            return;
        }
        Block block = e.getBlock();
        if (block.getType() != Material.FARMLAND) {
            return;
        }
        if (e.getNewState().getType() != Material.DIRT) {
            return;
        }
        if (!this.pistonFarmlandHasWater(block, this.pistonProtectFarmlandWaterRadius)) {
            return;
        }
        e.setCancelled(true);
    }

    private boolean pistonFarmlandHasWater(Block farmland, int radius) {
        if (farmland == null) {
            return false;
        }
        World world = farmland.getWorld();
        int fx = farmland.getX();
        int fy = farmland.getY();
        int fz = farmland.getZ();
        int minY = world.getMinHeight();
        int maxY = world.getMaxHeight() - 1;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    Waterlogged wl;
                    int cy = fy + dy;
                    if (cy < minY || cy > maxY) continue;
                    Block b = world.getBlockAt(fx + dx, cy, fz + dz);
                    if (b.getType() == Material.WATER) {
                        return true;
                    }
                    BlockData bd = b.getBlockData();
                    if (!(bd instanceof Waterlogged) || !(wl = (Waterlogged)bd).isWaterlogged()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        SAPLING_TREE_TYPES.put(Material.OAK_SAPLING, TreeType.TREE);
        SAPLING_TREE_TYPES.put(Material.SPRUCE_SAPLING, TreeType.REDWOOD);
        SAPLING_TREE_TYPES.put(Material.BIRCH_SAPLING, TreeType.BIRCH);
        SAPLING_TREE_TYPES.put(Material.JUNGLE_SAPLING, TreeType.SMALL_JUNGLE);
        SAPLING_TREE_TYPES.put(Material.ACACIA_SAPLING, TreeType.ACACIA);
        SAPLING_TREE_TYPES.put(Material.DARK_OAK_SAPLING, TreeType.DARK_OAK);
        try {
            SAPLING_TREE_TYPES.put(Material.valueOf((String)"CHERRY_SAPLING"), TreeType.valueOf((String)"CHERRY"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SAPLING_TREE_TYPES.put(Material.valueOf((String)"PALE_OAK_SAPLING"), TreeType.valueOf((String)"PALE_OAK"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TREE_GEN_LOCK = new Object();
        POWDER_TO_CONCRETE = new EnumMap(Material.class);
        POWDER_TO_CONCRETE.put(Material.WHITE_CONCRETE_POWDER, Material.WHITE_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.ORANGE_CONCRETE_POWDER, Material.ORANGE_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.MAGENTA_CONCRETE_POWDER, Material.MAGENTA_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.LIGHT_BLUE_CONCRETE_POWDER, Material.LIGHT_BLUE_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.YELLOW_CONCRETE_POWDER, Material.YELLOW_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.LIME_CONCRETE_POWDER, Material.LIME_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.PINK_CONCRETE_POWDER, Material.PINK_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.GRAY_CONCRETE_POWDER, Material.GRAY_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.LIGHT_GRAY_CONCRETE_POWDER, Material.LIGHT_GRAY_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.CYAN_CONCRETE_POWDER, Material.CYAN_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.PURPLE_CONCRETE_POWDER, Material.PURPLE_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.BLUE_CONCRETE_POWDER, Material.BLUE_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.BROWN_CONCRETE_POWDER, Material.BROWN_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.GREEN_CONCRETE_POWDER, Material.GREEN_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.RED_CONCRETE_POWDER, Material.RED_CONCRETE);
        POWDER_TO_CONCRETE.put(Material.BLACK_CONCRETE_POWDER, Material.BLACK_CONCRETE);
    }

    private record SavedBlock(int x, int y, int z, BlockData data) {
    }

    private static final class VillagerTradeClickState {
        final long merchantKey;
        final int index;
        final long timeNanos;

        VillagerTradeClickState(long merchantKey, int index, long timeNanos) {
            this.merchantKey = merchantKey;
            this.index = index;
            this.timeNanos = timeNanos;
        }
    }

    private static final class PinnedDrop {
        final Location pinLoc;
        final long expiresAtNanos;

        PinnedDrop(Location pinLoc, long expiresAtNanos) {
            this.pinLoc = pinLoc;
            this.expiresAtNanos = expiresAtNanos;
        }
    }

    private static final class SilkTouchBreakTracker {
        final Location location;
        final UUID playerId;
        final long expiresAtNanos;
        final List<Material> dropTypes;

        SilkTouchBreakTracker(Location location, UUID playerId, long expiresAtNanos, List<Material> dropTypes) {
            this.location = location;
            this.playerId = playerId;
            this.expiresAtNanos = expiresAtNanos;
            this.dropTypes = dropTypes;
        }
    }

    private final class BundleScrollPacketListener
    extends PacketListenerAbstract {
        private BundleScrollPacketListener() {
        }

        public void onPacketReceive(PacketReceiveEvent event) {
            UUID playerId;
            WrapperPlayClientSelectBundleItem w;
            if (!GGQOL.this.bundleScroll) {
                return;
            }
            if (event == null) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Client.SELECT_BUNDLE_ITEM) {
                return;
            }
            try {
                w = new WrapperPlayClientSelectBundleItem(event);
            }
            catch (Throwable ignored) {
                return;
            }
            try {
                playerId = event.getUser().getUUID();
            }
            catch (Throwable ignored) {
                return;
            }
            Player p = Bukkit.getPlayer((UUID)playerId);
            if (p == null) {
                return;
            }
            int slotId = GGQOL.this.safeGetSelectBundleSlot(w);
            int selectedIndex = GGQOL.this.safeGetSelectBundleIndex(w);
            if (slotId < 0) {
                return;
            }
            if (selectedIndex < 0) {
                return;
            }
            GGQOL.this.queueBundleScrollWork(p, slotId, selectedIndex);
        }
    }

    private static final class BundleScrollState {
        int lastIndex = -1;
        long lastRotateNanos = 0L;

        private BundleScrollState() {
        }
    }

    private static final class MudSpreadJob {
        final UUID worldId;
        final int originX;
        final int originY;
        final int originZ;
        final int range;
        final HashSet<Long> visited = new HashSet();
        final ArrayDeque<MudNode> queue = new ArrayDeque();
        volatile ScheduledTask task;

        MudSpreadJob(UUID worldId, int x, int y, int z, int range) {
            this.worldId = worldId;
            this.originX = x;
            this.originY = y;
            this.originZ = z;
            this.range = range;
        }
    }

    private record MudNode(int x, int y, int z, int dist) {
    }
}

