/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;

public class MobGuard
extends JavaPlugin
implements Listener {
    private boolean blockCreeperExplosions;
    private boolean blockCreeperExplosionPrime;
    private boolean blockChargedCreepers;
    private boolean blockGhastFireballs;
    private boolean blockGhastFireIgnite;
    private boolean blockWitherSkullExplosions;
    private boolean blockWitherBlockBreaking;
    private boolean blockWitherFireIgnite;
    private boolean blockDragonBlockBreaking;
    private boolean blockEndermanBlockMoving;
    private boolean blockEndermanTeleport;
    private boolean blockShulkerTeleport;
    private boolean blockRavagerGriefing;
    private boolean blockZombieDoorBreaking;
    private boolean blockBlazeFireIgnite;
    private boolean blockMagmaCubeSplit;
    private boolean blockSlimeSplit;
    private boolean blockMobProjectiles;
    private EnumSet<EntityType> mobProjectileBlockedShooters = EnumSet.noneOf(EntityType.class);
    private boolean blockHostileTargetPlayers;
    private boolean blockHostileTargetVillagers;
    private boolean blockMobItemPickup;
    private EnumSet<EntityType> mobItemPickupBlockedTypes = EnumSet.noneOf(EntityType.class);
    private boolean blockMobPickedUpItemDrops;
    private EnumSet<EntityType> mobPickedUpItemDropBlockedTypes = EnumSet.noneOf(EntityType.class);
    private boolean blockMobPortals;
    private EnumSet<EntityType> mobPortalBlockedTypes = EnumSet.noneOf(EntityType.class);
    private boolean blockFarmlandTrample;
    private boolean blockMobPressurePlates;
    private boolean blockSilverfishInfesting;
    private boolean blockEnderPearlTeleport;
    private boolean blockEnderPearlDamage;
    private final Object2LongOpenHashMap<UUID> pearlNoFallUntilMs = new Object2LongOpenHashMap(64);
    private boolean blockRaidTrigger;
    private boolean blockBabyZombies;
    private boolean blockZombieReinforcements;
    private boolean preventMobBurning;
    private EnumSet<EntityType> preventMobBurningTypes = EnumSet.noneOf(EntityType.class);
    private boolean forceMobBurning;
    private EnumSet<EntityType> forceMobBurningTypes = EnumSet.noneOf(EntityType.class);
    private int forceMobBurningTicks;
    private boolean debug;
    private boolean spawnControlEnabled;
    private boolean spawnAllowCommandSpawns;
    private boolean spawnBlockNaturalSpawns;
    private boolean spawnBlockSpawnerSpawns;
    private boolean spawnBlockEggSpawns;
    private boolean spawnCleanNewChunks;
    private boolean spawnBlockAllOverworld;
    private boolean spawnBlockAllNether;
    private boolean spawnBlockAllEnd;
    private boolean dropControlEnabled;
    private final Map<EntityType, MobDropRule> dropRules = new EnumMap<EntityType, MobDropRule>(EntityType.class);
    private EnumSet<EntityType> spawnBlockedOverworldMobs = EnumSet.noneOf(EntityType.class);
    private EnumSet<EntityType> spawnBlockedNetherMobs = EnumSet.noneOf(EntityType.class);
    private EnumSet<EntityType> spawnBlockedEndMobs = EnumSet.noneOf(EntityType.class);
    private static final EnumSet<Material> PRESSURE_PLATES = MobGuard.buildPressurePlateSet();
    private NamespacedKey pickedUpKey;
    private final EnumMap<EntityType, HeightRange> spawnControlledOverworldMobs = new EnumMap(EntityType.class);
    private final EnumMap<EntityType, HeightRange> spawnControlledNetherMobs = new EnumMap(EntityType.class);
    private final EnumMap<EntityType, HeightRange> spawnControlledEndMobs = new EnumMap(EntityType.class);

    public void onEnable() {
        this.ensureConfigExists();
        this.pearlNoFallUntilMs.defaultReturnValue(0L);
        this.pickedUpKey = new NamespacedKey((Plugin)this, "picked_up_item_drop_block");
        this.loadSettings();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this, task -> this.prunePearlMap(), 200L, 200L);
        this.getLogger().info("MobDropRule enabled");
    }

    public void onDisable() {
        this.pearlNoFallUntilMs.clear();
        this.getLogger().info("MobDropRule disabled");
    }

    private void ensureConfigExists() {
        File cfg;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(cfg = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
    }

    private void loadSettings() {
        this.reloadConfig();
        this.blockCreeperExplosions = this.getConfig().getBoolean("settings.block-creeper-explosions", true);
        this.blockCreeperExplosionPrime = this.getConfig().getBoolean("settings.block-creeper-explosion-prime", false);
        this.blockChargedCreepers = this.getConfig().getBoolean("settings.block-charged-creepers", true);
        this.blockGhastFireballs = this.getConfig().getBoolean("settings.block-ghast-fireballs", true);
        this.blockGhastFireIgnite = this.getConfig().getBoolean("settings.block-ghast-fire-ignite", true);
        this.blockWitherSkullExplosions = this.getConfig().getBoolean("settings.block-wither-skull-explosions", true);
        this.blockWitherBlockBreaking = this.getConfig().getBoolean("settings.block-wither-block-breaking", true);
        this.blockWitherFireIgnite = this.getConfig().getBoolean("settings.block-wither-fire-ignite", true);
        this.blockDragonBlockBreaking = this.getConfig().getBoolean("settings.block-ender-dragon-block-breaking", true);
        this.blockEndermanBlockMoving = this.getConfig().getBoolean("settings.block-enderman-block-moving", true);
        this.blockEndermanTeleport = this.getConfig().getBoolean("settings.block-enderman-teleport", true);
        this.blockShulkerTeleport = this.getConfig().getBoolean("settings.block-shulker-teleport", true);
        this.blockRavagerGriefing = this.getConfig().getBoolean("settings.block-ravager-griefing", true);
        this.blockZombieDoorBreaking = this.getConfig().getBoolean("settings.block-zombie-door-breaking", true);
        this.blockBlazeFireIgnite = this.getConfig().getBoolean("settings.block-blaze-fire-ignite", true);
        this.blockMagmaCubeSplit = this.getConfig().getBoolean("settings.block-magma-cube-split", true);
        this.blockSlimeSplit = this.getConfig().getBoolean("settings.block-slime-split", true);
        this.blockMobProjectiles = this.getConfig().getBoolean("projectile-control.enabled", false);
        this.mobProjectileBlockedShooters = this.parseEntityTypeList(this.getConfig().getStringList("projectile-control.blocked-shooters"));
        this.blockHostileTargetPlayers = this.getConfig().getBoolean("target-control.block-hostile-targeting-players", false);
        this.blockHostileTargetVillagers = this.getConfig().getBoolean("target-control.block-hostile-targeting-villagers", false);
        this.blockMobItemPickup = this.getConfig().getBoolean("item-pickup-control.enabled", false);
        this.mobItemPickupBlockedTypes = this.parseEntityTypeList(this.getConfig().getStringList("item-pickup-control.blocked-types"));
        this.blockMobPickedUpItemDrops = this.getConfig().getBoolean("item-pickup-control.block-picked-up-item-drops", false);
        this.mobPickedUpItemDropBlockedTypes = this.parseEntityTypeList(this.getConfig().getStringList("item-pickup-control.drop-blocked-types"));
        this.blockMobPortals = this.getConfig().getBoolean("portal-control.enabled", false);
        this.mobPortalBlockedTypes = this.parseEntityTypeList(this.getConfig().getStringList("portal-control.blocked-types"));
        this.blockFarmlandTrample = this.getConfig().getBoolean("block-control.block-farmland-trample", true);
        this.blockMobPressurePlates = this.getConfig().getBoolean("block-control.block-mob-pressure-plates", false);
        this.blockSilverfishInfesting = this.getConfig().getBoolean("block-control.block-silverfish-infesting", true);
        this.blockEnderPearlTeleport = this.getConfig().getBoolean("ender-pearl-control.block-ender-pearl-teleport", false);
        this.blockEnderPearlDamage = this.getConfig().getBoolean("ender-pearl-control.block-ender-pearl-damage", false);
        this.blockRaidTrigger = this.getConfig().getBoolean("raid-control.block-raid-trigger", false);
        this.blockBabyZombies = this.getConfig().getBoolean("zombie-control.block-baby-zombies", false);
        this.blockZombieReinforcements = this.getConfig().getBoolean("zombie-control.block-zombie-reinforcements", false);
        this.preventMobBurning = this.getConfig().getBoolean("combustion-control.prevent-burning", false);
        this.preventMobBurningTypes = this.parseEntityTypeList(this.getConfig().getStringList("combustion-control.prevent-burning-types"));
        this.forceMobBurning = this.getConfig().getBoolean("combustion-control.force-burning", false);
        this.forceMobBurningTypes = this.parseEntityTypeList(this.getConfig().getStringList("combustion-control.force-burning-types"));
        this.forceMobBurningTicks = this.getConfig().getInt("combustion-control.force-burning-ticks", 200);
        this.debug = this.getConfig().getBoolean("settings.debug", false);
        this.spawnControlEnabled = this.getConfig().getBoolean("spawn-control.enabled", true);
        this.spawnAllowCommandSpawns = this.getConfig().getBoolean("spawn-control.allow-command-spawns", true);
        this.spawnBlockNaturalSpawns = this.getConfig().getBoolean("spawn-control.block-natural-spawns", true);
        this.spawnBlockSpawnerSpawns = this.getConfig().getBoolean("spawn-control.block-spawner-spawns", true);
        this.spawnBlockEggSpawns = this.getConfig().getBoolean("spawn-control.block-egg-spawns", true);
        this.spawnCleanNewChunks = this.getConfig().getBoolean("spawn-control.clean-new-chunks", true);
        this.spawnBlockAllOverworld = this.getBooleanWithFallback("spawn-control.worlds.overworld.block-all-hostile-mobs", "spawn-control.worlds.world.block-all-hostile-mobs", false);
        this.spawnBlockAllNether = this.getConfig().getBoolean("spawn-control.worlds.nether.block-all-hostile-mobs", false);
        this.spawnBlockAllEnd = this.getConfig().getBoolean("spawn-control.worlds.end.block-all-hostile-mobs", false);
        this.spawnBlockedOverworldMobs = this.parseEntityTypeList(this.getStringListWithFallback("spawn-control.worlds.overworld.blocked-mobs", "spawn-control.worlds.world.blocked-mobs"));
        this.spawnBlockedNetherMobs = this.parseEntityTypeList(this.getConfig().getStringList("spawn-control.worlds.nether.blocked-mobs"));
        this.spawnBlockedEndMobs = this.parseEntityTypeList(this.getConfig().getStringList("spawn-control.worlds.end.blocked-mobs"));
        this.loadSpawnControlledMobSettings();
        this.loadDropControlSettings();
    }

    private boolean getBooleanWithFallback(String primaryPath, String fallbackPath, boolean def) {
        if (this.getConfig().contains(primaryPath)) {
            return this.getConfig().getBoolean(primaryPath, def);
        }
        return this.getConfig().getBoolean(fallbackPath, def);
    }

    private List<String> getStringListWithFallback(String primaryPath, String fallbackPath) {
        if (this.getConfig().isList(primaryPath)) {
            return this.getConfig().getStringList(primaryPath);
        }
        return this.getConfig().getStringList(fallbackPath);
    }

    private boolean isBlockAllHostileEnabled(WorldKey worldKey) {
        if (worldKey == null) {
            return false;
        }
        switch (worldKey.ordinal()) {
            case 0: {
                return this.spawnBlockAllOverworld;
            }
            case 1: {
                return this.spawnBlockAllNether;
            }
            case 2: {
                return this.spawnBlockAllEnd;
            }
        }
        return false;
    }

    private static EnumSet<Material> buildPressurePlateSet() {
        EnumSet<Material> set = EnumSet.noneOf(Material.class);
        for (Material m : Material.values()) {
            if (m == null || !m.name().endsWith("_PRESSURE_PLATE")) continue;
            set.add(m);
        }
        return set;
    }

    private EnumSet<Material> parseMaterialList(List<String> list) {
        EnumSet<Material> set = EnumSet.noneOf(Material.class);
        if (list == null) {
            return set;
        }
        for (String raw : list) {
            String name;
            if (raw == null || (name = raw.trim().toUpperCase()).isEmpty()) continue;
            try {
                Material mat = Material.valueOf((String)name);
                set.add(mat);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().warning("Unknown Material in config: " + raw);
            }
        }
        return set;
    }

    private void loadDropControlSettings() {
        this.dropControlEnabled = this.getConfig().getBoolean("drop-control.enabled", false);
        this.dropRules.clear();
        ConfigurationSection mobsSec = this.getConfig().getConfigurationSection("drop-control.mobs");
        if (mobsSec == null) {
            return;
        }
        for (String mobKey : mobsSec.getKeys(false)) {
            EntityType mobType;
            String mobName;
            if (mobKey == null || (mobName = mobKey.trim().toUpperCase()).isEmpty()) continue;
            try {
                mobType = EntityType.valueOf((String)mobName);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().warning("Unknown EntityType in drop-control.mobs: " + mobKey);
                continue;
            }
            ConfigurationSection mobSec = mobsSec.getConfigurationSection(mobKey);
            if (mobSec == null) continue;
            boolean replace = mobSec.getBoolean("replace-default-drops", false);
            EnumSet<Material> remove = this.parseMaterialList(mobSec.getStringList("remove-drops"));
            ArrayList<DropEntry> add = new ArrayList<DropEntry>();
            ConfigurationSection addSec = mobSec.getConfigurationSection("add-drops");
            if (addSec != null) {
                for (String matKey : addSec.getKeys(false)) {
                    double rawPercent;
                    Material mat;
                    String matName;
                    if (matKey == null || (matName = matKey.trim().toUpperCase()).isEmpty()) continue;
                    try {
                        mat = Material.valueOf((String)matName);
                    }
                    catch (IllegalArgumentException ex) {
                        this.getLogger().warning("Unknown Material in add-drops for " + String.valueOf(mobType) + ": " + matKey);
                        continue;
                    }
                    ConfigurationSection dSec = addSec.getConfigurationSection(matKey);
                    if (dSec == null) {
                        this.getLogger().warning("add-drops entry for " + String.valueOf(mobType) + "." + matKey + " must be a section with min/max");
                        continue;
                    }
                    int min = dSec.getInt("min", 1);
                    int max = dSec.getInt("max", min);
                    if (min < 0) {
                        min = 0;
                    }
                    if (max < 0) {
                        max = 0;
                    }
                    if (max < min) {
                        int tmp = min;
                        min = max;
                        max = tmp;
                    }
                    if ((rawPercent = dSec.getDouble("chance", 100.0)) < 0.0) {
                        rawPercent = 0.0;
                    }
                    if (rawPercent > 100.0) {
                        rawPercent = 100.0;
                    }
                    double chanceProb = this.percentChanceToProbability(rawPercent);
                    add.add(new DropEntry(mat, min, max, chanceProb));
                }
            }
            this.dropRules.put(mobType, new MobDropRule(replace, remove, add, this.parseXpRule(mobSec, mobType)));
        }
        this.logDebug(() -> "Loaded drop-control rules: " + this.dropRules.size());
    }

    private double percentChanceToProbability(double rawPercent) {
        if (Double.isNaN(rawPercent) || Double.isInfinite(rawPercent)) {
            return 0.0;
        }
        if (rawPercent <= 0.0) {
            return 0.0;
        }
        if (rawPercent >= 100.0) {
            return 1.0;
        }
        return rawPercent / 100.0;
    }

    private XpRule parseXpRule(ConfigurationSection mobSec, EntityType mobType) {
        double rawPercent;
        if (!mobSec.isConfigurationSection("xp")) {
            return null;
        }
        ConfigurationSection xpSec = mobSec.getConfigurationSection("xp");
        int min = xpSec.getInt("min", 0);
        int max = xpSec.getInt("max", min);
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        if (max < min) {
            int tmp = min;
            min = max;
            max = tmp;
        }
        if ((rawPercent = xpSec.getDouble("chance", 100.0)) < 0.0) {
            rawPercent = 0.0;
        }
        if (rawPercent > 100.0) {
            rawPercent = 100.0;
        }
        double chance = this.percentChanceToProbability(rawPercent);
        int finalMin = min;
        int finalMax = max;
        double finalPercent = rawPercent;
        this.logDebug(() -> "Loaded xp rule for " + String.valueOf(mobType) + ": min=" + finalMin + " max=" + finalMax + " chance=" + finalPercent + "%");
        return new XpRule(min, max, chance);
    }

    private void applyDropControl(EntityDeathEvent e, LivingEntity le) {
        if (!this.dropControlEnabled) {
            return;
        }
        if (e == null || le == null) {
            return;
        }
        MobDropRule rule = this.dropRules.get(le.getType());
        if (rule == null) {
            return;
        }
        List drops = e.getDrops();
        if (drops == null) {
            return;
        }
        if (rule.replaceDefaultDrops) {
            drops.clear();
        }
        if (rule.removeDrops != null && !rule.removeDrops.isEmpty() && !drops.isEmpty()) {
            for (int i = drops.size() - 1; i >= 0; --i) {
                Material t;
                ItemStack it = (ItemStack)drops.get(i);
                if (it == null || (t = it.getType()) == Material.AIR || !rule.removeDrops.contains(t)) continue;
                drops.remove(i);
            }
        }
        if (rule.addDrops == null || rule.addDrops.isEmpty()) {
            this.applyXpRule(e, le, rule.xpRule);
            return;
        }
        int looting = this.getLootingLevel(le);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (DropEntry de : rule.addDrops) {
            int give;
            if (de == null || de.material == null || de.material == Material.AIR || de.chance < 1.0 && rnd.nextDouble() > de.chance) continue;
            int amount = de.max <= de.min ? de.min : rnd.nextInt(de.min, de.max + 1);
            if (looting > 0 && amount > 0) {
                amount += rnd.nextInt(looting + 1);
            }
            if (amount <= 0) continue;
            int maxStack = Math.max(1, de.material.getMaxStackSize());
            for (int left = amount; left > 0; left -= give) {
                give = Math.min(left, maxStack);
                drops.add(new ItemStack(de.material, give));
            }
        }
        this.applyXpRule(e, le, rule.xpRule);
    }

    private void applyXpRule(EntityDeathEvent e, LivingEntity le, XpRule rule) {
        if (rule == null) {
            return;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (rule.chance < 1.0 && rnd.nextDouble() > rule.chance) {
            e.setDroppedExp(0);
            this.logDebug(() -> "XP chance roll failed for " + String.valueOf(le.getType()) + " at " + String.valueOf(le.getLocation()) + " \u2014 set to 0");
            return;
        }
        int xp = rule.max <= rule.min ? rule.min : rnd.nextInt(rule.min, rule.max + 1);
        xp = Math.max(0, xp);
        e.setDroppedExp(xp);
        int finalXp = xp;
        this.logDebug(() -> "Applied xp rule for " + String.valueOf(le.getType()) + " at " + String.valueOf(le.getLocation()) + ": " + finalXp + " xp");
    }

    private int getLootingLevel(LivingEntity dead) {
        if (dead == null) {
            return 0;
        }
        Player killer = dead.getKiller();
        if (killer == null) {
            return 0;
        }
        ItemStack weapon = killer.getInventory().getItemInMainHand();
        if (weapon == null) {
            return 0;
        }
        if (weapon.getType() == Material.AIR) {
            return 0;
        }
        return Math.max(0, weapon.getEnchantmentLevel(Enchantment.LOOTING));
    }

    private EnumSet<EntityType> parseEntityTypeList(List<String> list) {
        EnumSet<EntityType> set = EnumSet.noneOf(EntityType.class);
        if (list == null) {
            return set;
        }
        for (String raw : list) {
            String name;
            if (raw == null || (name = raw.trim().toUpperCase()).isEmpty()) continue;
            try {
                EntityType type = EntityType.valueOf((String)name);
                set.add(type);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().warning("Unknown EntityType in config: " + raw);
            }
        }
        return set;
    }

    private void logDebug(Supplier<String> msgSupplier) {
        if (!this.debug) {
            return;
        }
        if (msgSupplier == null) {
            return;
        }
        this.getLogger().info("[Debug] " + msgSupplier.get());
    }

    private WorldKey getWorldKey(World world) {
        if (world == null) {
            return WorldKey.WORLD;
        }
        World.Environment env = world.getEnvironment();
        if (env == World.Environment.NETHER) {
            return WorldKey.NETHER;
        }
        if (env == World.Environment.THE_END) {
            return WorldKey.END;
        }
        return WorldKey.WORLD;
    }

    private boolean shouldBlockSpawnReason(CreatureSpawnEvent.SpawnReason reason) {
        if (reason == null) {
            return true;
        }
        if (this.spawnAllowCommandSpawns && (reason == CreatureSpawnEvent.SpawnReason.COMMAND || reason == CreatureSpawnEvent.SpawnReason.CUSTOM)) {
            return false;
        }
        if (this.spawnBlockSpawnerSpawns && (reason == CreatureSpawnEvent.SpawnReason.SPAWNER || reason == CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER || reason == CreatureSpawnEvent.SpawnReason.OMINOUS_ITEM_SPAWNER)) {
            return true;
        }
        if (this.spawnBlockEggSpawns && (reason == CreatureSpawnEvent.SpawnReason.EGG || reason == CreatureSpawnEvent.SpawnReason.DISPENSE_EGG || reason == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG)) {
            return true;
        }
        if (!this.spawnBlockNaturalSpawns) {
            return false;
        }
        return reason == CreatureSpawnEvent.SpawnReason.NATURAL || reason == CreatureSpawnEvent.SpawnReason.PATROL || reason == CreatureSpawnEvent.SpawnReason.RAID || reason == CreatureSpawnEvent.SpawnReason.REINFORCEMENTS || reason == CreatureSpawnEvent.SpawnReason.NETHER_PORTAL || reason == CreatureSpawnEvent.SpawnReason.VILLAGE_INVASION || reason == CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE || reason == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT || reason == CreatureSpawnEvent.SpawnReason.DEFAULT;
    }

    private boolean isMobBlockedInWorld(WorldKey worldKey, EntityType mobType) {
        if (worldKey == null || mobType == null) {
            return false;
        }
        switch (worldKey.ordinal()) {
            case 0: {
                return this.spawnBlockedOverworldMobs.contains(mobType);
            }
            case 1: {
                return this.spawnBlockedNetherMobs.contains(mobType);
            }
            case 2: {
                return this.spawnBlockedEndMobs.contains(mobType);
            }
        }
        return false;
    }

    private boolean isFire(Block b) {
        if (b == null) {
            return false;
        }
        Material m = b.getType();
        return m == Material.FIRE || m == Material.SOUL_FIRE;
    }

    private void removeFireInCube(Block center, int radius) {
        if (center == null) {
            return;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    Block b = center.getRelative(dx, dy, dz);
                    if (!this.isFire(b)) continue;
                    b.setType(Material.AIR);
                }
            }
        }
    }

    private void scheduleFireCleanup(Block center1, Block center2) {
        if (center1 == null && center2 == null) {
            return;
        }
        Location loc = center1 != null ? center1.getLocation() : center2.getLocation();
        int[] runs = new int[]{0};
        this.getServer().getRegionScheduler().runAtFixedRate((Plugin)this, loc, task -> {
            if (center1 != null) {
                this.removeFireInCube(center1, 2);
            }
            if (center2 != null) {
                this.removeFireInCube(center2, 2);
            }
            runs[0] = runs[0] + 1;
            if (runs[0] >= 2) {
                task.cancel();
            }
        }, 1L, 1L);
    }

    private boolean matchesTypeList(EnumSet<EntityType> set, EntityType type) {
        if (type == null) {
            return false;
        }
        if (set == null || set.isEmpty()) {
            return true;
        }
        return set.contains(type);
    }

    private void removeEquipmentFromDrops(List<ItemStack> drops, LivingEntity le) {
        if (drops == null || le == null) {
            return;
        }
        EntityEquipment eq = le.getEquipment();
        if (eq == null) {
            return;
        }
        ItemStack main = eq.getItemInMainHand();
        ItemStack off = eq.getItemInOffHand();
        ItemStack[] armor = eq.getArmorContents();
        block0: for (int i = drops.size() - 1; i >= 0; --i) {
            ItemStack d = drops.get(i);
            if (d == null || d.getType() == Material.AIR) continue;
            if (main != null && main.getType() != Material.AIR && d.isSimilar(main)) {
                drops.remove(i);
                continue;
            }
            if (off != null && off.getType() != Material.AIR && d.isSimilar(off)) {
                drops.remove(i);
                continue;
            }
            if (armor == null) continue;
            for (ItemStack a : armor) {
                if (a == null || a.getType() == Material.AIR || !d.isSimilar(a)) continue;
                drops.remove(i);
                continue block0;
            }
        }
    }

    private void prunePearlMap() {
        if (this.pearlNoFallUntilMs.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        ObjectIterator it = this.pearlNoFallUntilMs.object2LongEntrySet().fastIterator();
        while (it.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)it.next();
            if (entry.getLongValue() >= now) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent e) {
        if (!this.blockCreeperExplosionPrime) {
            return;
        }
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        if (ent.getType() == EntityType.CREEPER) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked creeper explosion prime at " + String.valueOf(ent.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreeperPower(CreeperPowerEvent e) {
        if (!this.blockChargedCreepers) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (e.getCause() == CreeperPowerEvent.PowerCause.LIGHTNING) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked charged creeper at " + String.valueOf(e.getEntity().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent e) {
        if (!this.blockMobProjectiles) {
            return;
        }
        Projectile proj = e.getEntity();
        if (proj == null) {
            return;
        }
        ProjectileSource shooter = proj.getShooter();
        if (!(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)shooter;
        if (le instanceof Player) {
            return;
        }
        EntityType shooterType = le.getType();
        if (!this.matchesTypeList(this.mobProjectileBlockedShooters, shooterType)) {
            return;
        }
        e.setCancelled(true);
        this.logDebug(() -> "Blocked mob projectile launch: shooter=" + String.valueOf(shooterType) + " proj=" + String.valueOf(proj.getType()) + " at " + String.valueOf(proj.getLocation()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent e) {
        if (!this.blockHostileTargetPlayers && !this.blockHostileTargetVillagers) {
            return;
        }
        Entity attacker = e.getEntity();
        if (!(attacker instanceof Enemy)) {
            return;
        }
        LivingEntity target = e.getTarget();
        if (target == null) {
            return;
        }
        if (this.blockHostileTargetPlayers && target instanceof Player) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked hostile targeting player: attacker=" + String.valueOf(attacker.getType()) + " at " + String.valueOf(attacker.getLocation()));
            return;
        }
        if (this.blockHostileTargetVillagers && target instanceof AbstractVillager) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked hostile targeting villager: attacker=" + String.valueOf(attacker.getType()) + " at " + String.valueOf(attacker.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityPickupItem(EntityPickupItemEvent e) {
        LivingEntity le = e.getEntity();
        if (le == null) {
            return;
        }
        if (le instanceof Player) {
            return;
        }
        EntityType type = le.getType();
        if (this.blockMobItemPickup && this.matchesTypeList(this.mobItemPickupBlockedTypes, type)) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked mob item pickup: " + String.valueOf(type) + " at " + String.valueOf(le.getLocation()));
            return;
        }
        if (this.blockMobPickedUpItemDrops && this.matchesTypeList(this.mobPickedUpItemDropBlockedTypes, type)) {
            le.getPersistentDataContainer().set(this.pickedUpKey, PersistentDataType.BYTE, (Object)1);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent e) {
        LivingEntity le = e.getEntity();
        if (le == null) {
            return;
        }
        if (this.blockMobPickedUpItemDrops && le.getPersistentDataContainer().has(this.pickedUpKey, PersistentDataType.BYTE)) {
            this.removeEquipmentFromDrops(e.getDrops(), le);
            le.getPersistentDataContainer().remove(this.pickedUpKey);
            this.logDebug(() -> "Removed picked-up equipment drops for " + String.valueOf(le.getType()) + " at " + String.valueOf(le.getLocation()));
        }
        this.applyDropControl(e, le);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityPortal(EntityPortalEvent e) {
        if (!this.blockMobPortals) {
            return;
        }
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        EntityType type = ent.getType();
        if (!this.matchesTypeList(this.mobPortalBlockedTypes, type)) {
            return;
        }
        e.setCancelled(true);
        this.logDebug(() -> "Blocked mob portal use: " + String.valueOf(type) + " at " + String.valueOf(ent.getLocation()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent e) {
        if (!this.blockMobPressurePlates) {
            return;
        }
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        Block b = e.getBlock();
        if (b == null) {
            return;
        }
        if (PRESSURE_PLATES.contains(b.getType())) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked mob pressure plate: " + String.valueOf(ent.getType()) + " on " + String.valueOf(b.getType()) + " at " + String.valueOf(b.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRaidTrigger(RaidTriggerEvent e) {
        if (!this.blockRaidTrigger) {
            return;
        }
        e.setCancelled(true);
        this.logDebug(() -> "Blocked raid trigger at " + e.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player p = e.getPlayer();
        if (p == null) {
            return;
        }
        if (this.blockEnderPearlTeleport) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked ender pearl teleport for " + p.getName() + " from " + String.valueOf(e.getFrom()) + " to " + String.valueOf(e.getTo()));
            return;
        }
        if (this.blockEnderPearlDamage) {
            long until = System.currentTimeMillis() + 1200L;
            this.pearlNoFallUntilMs.put((Object)p.getUniqueId(), until);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent e) {
        if (!this.blockEnderPearlDamage) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        long until = this.pearlNoFallUntilMs.getLong((Object)p.getUniqueId());
        if (until == 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (until >= now) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked ender pearl damage for " + p.getName() + " at " + String.valueOf(p.getLocation()));
        } else {
            this.pearlNoFallUntilMs.removeLong((Object)p.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (p != null) {
            this.pearlNoFallUntilMs.removeLong((Object)p.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent e) {
        if (!this.preventMobBurning) {
            return;
        }
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        EntityType type = ent.getType();
        if (!this.matchesTypeList(this.preventMobBurningTypes, type)) {
            return;
        }
        e.setCancelled(true);
        this.logDebug(() -> "Blocked combustion for " + String.valueOf(type) + " at " + String.valueOf(ent.getLocation()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent e) {
        Fireball fb;
        ProjectileSource shooter;
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        EntityType type = ent.getType();
        boolean stopBlocks = false;
        if (this.blockCreeperExplosions && type == EntityType.CREEPER) {
            stopBlocks = true;
            this.logDebug(() -> "Blocked creeper block damage at " + ent.getLocation().getBlockX() + ", " + ent.getLocation().getBlockY() + ", " + ent.getLocation().getBlockZ());
        }
        if (!stopBlocks && this.blockGhastFireballs && (type == EntityType.FIREBALL || type == EntityType.SMALL_FIREBALL) && ent instanceof Fireball && (shooter = (fb = (Fireball)ent).getShooter()) instanceof Ghast) {
            stopBlocks = true;
            this.logDebug(() -> "Blocked ghast fireball block damage at " + ent.getLocation().getBlockX() + ", " + ent.getLocation().getBlockY() + ", " + ent.getLocation().getBlockZ());
        }
        if (!stopBlocks && this.blockWitherSkullExplosions && type == EntityType.WITHER_SKULL) {
            stopBlocks = true;
            this.logDebug(() -> "Blocked wither skull block damage at " + ent.getLocation().getBlockX() + ", " + ent.getLocation().getBlockY() + ", " + ent.getLocation().getBlockZ());
        }
        if (!stopBlocks && this.blockWitherBlockBreaking && type == EntityType.WITHER) {
            stopBlocks = true;
            this.logDebug(() -> "Blocked wither explosion-style block damage at " + ent.getLocation().getBlockX() + ", " + ent.getLocation().getBlockY() + ", " + ent.getLocation().getBlockZ());
        }
        if (!stopBlocks && this.blockDragonBlockBreaking && type == EntityType.ENDER_DRAGON) {
            stopBlocks = true;
            this.logDebug(() -> "Blocked ender dragon block damage at " + ent.getLocation().getBlockX() + ", " + ent.getLocation().getBlockY() + ", " + ent.getLocation().getBlockZ());
        }
        if (stopBlocks) {
            e.blockList().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemExplosionDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Item)) {
            return;
        }
        EntityDamageEvent.DamageCause cause = e.getCause();
        if (cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent e) {
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        EntityType type = ent.getType();
        if (this.blockFarmlandTrample && e.getBlock().getType() == Material.FARMLAND && e.getTo() == Material.DIRT && !(ent instanceof Player)) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked farmland trample by " + String.valueOf(type) + " at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockSilverfishInfesting && type == EntityType.SILVERFISH) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked silverfish block change at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockEndermanBlockMoving && type == EntityType.ENDERMAN) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked enderman block change at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockWitherBlockBreaking && type == EntityType.WITHER) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked wither block change at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockDragonBlockBreaking && type == EntityType.ENDER_DRAGON) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked ender dragon block change at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockRavagerGriefing && type == EntityType.RAVAGER) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked ravager block change at " + String.valueOf(e.getBlock().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBreakDoor(EntityBreakDoorEvent e) {
        if (!this.blockZombieDoorBreaking) {
            return;
        }
        LivingEntity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        EntityType type = ent.getType();
        if (type == EntityType.ZOMBIE || type == EntityType.HUSK || type == EntityType.DROWNED || type == EntityType.ZOMBIE_VILLAGER) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked zombie-type door breaking at " + String.valueOf(e.getBlock().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent e) {
        EntityType type;
        if (!(this.blockBlazeFireIgnite || this.blockGhastFireIgnite || this.blockWitherFireIgnite)) {
            return;
        }
        BlockIgniteEvent.IgniteCause cause = e.getCause();
        if (cause != BlockIgniteEvent.IgniteCause.EXPLOSION && cause != BlockIgniteEvent.IgniteCause.FIREBALL) {
            return;
        }
        Entity igniter = e.getIgnitingEntity();
        if (igniter instanceof Fireball) {
            Fireball fb = (Fireball)igniter;
            ProjectileSource shooter = fb.getShooter();
            if (this.blockGhastFireIgnite && shooter instanceof Ghast) {
                e.setCancelled(true);
                this.logDebug(() -> "Blocked ghast fire ignition at " + String.valueOf(e.getBlock().getLocation()));
                return;
            }
            if (this.blockBlazeFireIgnite && shooter instanceof Blaze) {
                e.setCancelled(true);
                this.logDebug(() -> "Blocked blaze fire ignition at " + String.valueOf(e.getBlock().getLocation()));
                return;
            }
        }
        if (this.blockBlazeFireIgnite && igniter instanceof Blaze) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked blaze fire ignition (direct blaze) at " + String.valueOf(e.getBlock().getLocation()));
            return;
        }
        if (this.blockWitherFireIgnite && igniter != null && ((type = igniter.getType()) == EntityType.WITHER_SKULL || type == EntityType.WITHER)) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked wither fire ignition at " + String.valueOf(e.getBlock().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent e) {
        Projectile proj = e.getEntity();
        if (proj == null) {
            return;
        }
        EntityType pType = proj.getType();
        if (pType != EntityType.SMALL_FIREBALL && pType != EntityType.FIREBALL) {
            return;
        }
        ProjectileSource shooter = proj.getShooter();
        if (shooter == null) {
            return;
        }
        boolean cleanup = false;
        if (this.blockBlazeFireIgnite && shooter instanceof Blaze) {
            cleanup = true;
        }
        if (this.blockGhastFireIgnite && shooter instanceof Ghast) {
            cleanup = true;
        }
        if (!cleanup) {
            return;
        }
        Block hitBlock = e.getHitBlock();
        BlockFace hitFace = e.getHitBlockFace();
        Block center1 = hitBlock != null ? hitBlock : proj.getLocation().getBlock();
        Block center2 = null;
        if (hitBlock != null && hitFace != null) {
            center2 = hitBlock.getRelative(hitFace);
        }
        this.scheduleFireCleanup(center1, center2);
        this.logDebug(() -> "Scheduled fire cleanup for projectile hit at " + String.valueOf(proj.getLocation()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSlimeSplit(SlimeSplitEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        EntityType type = e.getEntity().getType();
        if (this.blockSlimeSplit && type == EntityType.SLIME) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked slime split at " + String.valueOf(e.getEntity().getLocation()));
            return;
        }
        if (this.blockMagmaCubeSplit && type == EntityType.MAGMA_CUBE) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked magma cube split at " + String.valueOf(e.getEntity().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        int y;
        EntityType mobType;
        WorldKey worldKey;
        Zombie z;
        LivingEntity livingEntity;
        if (this.blockZombieReinforcements && e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.REINFORCEMENTS) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked reinforcement spawn: " + String.valueOf(e.getEntityType()) + " at " + String.valueOf(e.getLocation()));
            return;
        }
        if (this.blockBabyZombies && (livingEntity = e.getEntity()) instanceof Zombie && !(z = (Zombie)livingEntity).isAdult()) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked baby zombie-type spawn: " + String.valueOf(e.getEntityType()) + " at " + String.valueOf(e.getLocation()));
            return;
        }
        if (this.forceMobBurning && !this.forceMobBurningTypes.isEmpty() && this.forceMobBurningTypes.contains(e.getEntityType())) {
            e.getEntity().setFireTicks(Math.max(0, this.forceMobBurningTicks));
        }
        if (!this.spawnControlEnabled) {
            return;
        }
        if (!this.shouldBlockSpawnReason(e.getSpawnReason())) {
            return;
        }
        World world = e.getLocation().getWorld();
        if (this.isControlledMobOutOfRange(world, worldKey = this.getWorldKey(world), mobType = e.getEntityType(), y = e.getLocation().getBlockY())) {
            e.setCancelled(true);
            HeightRange r = this.getControlledRange(worldKey, mobType);
            this.logDebug(() -> "Blocked controlled-mob spawn (out of range) in " + String.valueOf((Object)worldKey) + ": " + String.valueOf(mobType) + " y=" + y + " allowed=" + (String)(r == null ? "null" : r.minY() + ".." + r.maxY()) + " reason=" + String.valueOf(e.getSpawnReason()));
            return;
        }
        if (this.isBlockAllHostileEnabled(worldKey) && e.getEntity() instanceof Enemy) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked hostile spawn in " + String.valueOf((Object)worldKey) + ": " + String.valueOf(mobType) + " reason=" + String.valueOf(e.getSpawnReason()));
            return;
        }
        if (this.isMobBlockedInWorld(worldKey, mobType)) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked spawn in " + String.valueOf((Object)worldKey) + ": " + String.valueOf(mobType) + " reason=" + String.valueOf(e.getSpawnReason()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChunkLoad(ChunkLoadEvent e) {
        if (!this.spawnControlEnabled) {
            return;
        }
        if (!this.spawnCleanNewChunks) {
            return;
        }
        if (!e.isNewChunk()) {
            return;
        }
        World world = e.getWorld();
        WorldKey worldKey = this.getWorldKey(world);
        for (Entity ent : e.getChunk().getEntities()) {
            int y;
            if (ent == null) continue;
            EntityType type = ent.getType();
            boolean remove = false;
            if (this.isBlockAllHostileEnabled(worldKey) && ent instanceof Enemy) {
                remove = true;
            }
            if (!remove && this.isMobBlockedInWorld(worldKey, type)) {
                remove = true;
            }
            if (!remove && this.isControlledMobOutOfRange(world, worldKey, type, y = ent.getLocation().getBlockY())) {
                remove = true;
            }
            if (!remove) continue;
            ent.remove();
            this.logDebug(() -> "Removed blocked mob from NEW chunk in " + String.valueOf((Object)worldKey) + ": " + String.valueOf(type));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTeleport(EntityTeleportEvent e) {
        Entity ent = e.getEntity();
        if (ent == null) {
            return;
        }
        EntityType type = ent.getType();
        if (this.blockEndermanTeleport && type == EntityType.ENDERMAN) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked enderman teleport from " + String.valueOf(e.getFrom()) + " to " + String.valueOf(e.getTo()));
            return;
        }
        if (this.blockShulkerTeleport && type == EntityType.SHULKER) {
            e.setCancelled(true);
            this.logDebug(() -> "Blocked shulker teleport from " + String.valueOf(e.getFrom()) + " to " + String.valueOf(e.getTo()));
        }
    }

    private ConfigurationSection getSectionWithFallback(String primaryPath, String fallbackPath) {
        if (this.getConfig().isConfigurationSection(primaryPath)) {
            return this.getConfig().getConfigurationSection(primaryPath);
        }
        return this.getConfig().getConfigurationSection(fallbackPath);
    }

    private EnumMap<EntityType, HeightRange> parseControlledMobRanges(ConfigurationSection sec) {
        EnumMap<EntityType, HeightRange> out = new EnumMap<EntityType, HeightRange>(EntityType.class);
        if (sec == null) {
            return out;
        }
        for (String mobKey : sec.getKeys(false)) {
            EntityType type;
            String mobName;
            if (mobKey == null || (mobName = mobKey.trim().toUpperCase()).isEmpty()) continue;
            try {
                type = EntityType.valueOf((String)mobName);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().warning("Unknown EntityType in controlled-mobs: " + mobKey);
                continue;
            }
            ConfigurationSection mobSec = sec.getConfigurationSection(mobKey);
            if (mobSec == null) {
                this.getLogger().warning("controlled-mobs entry for " + String.valueOf(type) + " must be a section");
                continue;
            }
            boolean hasMin = mobSec.contains("minimum-y-height");
            boolean hasMax = mobSec.contains("maximum-y-height");
            if (!hasMin && !hasMax) {
                this.getLogger().warning("controlled-mobs entry for " + String.valueOf(type) + " needs minimum-y-height and/or maximum-y-height");
                continue;
            }
            int min = mobSec.getInt("minimum-y-height", Integer.MIN_VALUE);
            int max = mobSec.getInt("maximum-y-height", Integer.MAX_VALUE);
            if (max < min) {
                int tmp = min;
                min = max;
                max = tmp;
            }
            out.put(type, new HeightRange(min, max));
        }
        return out;
    }

    private void loadSpawnControlledMobSettings() {
        this.spawnControlledOverworldMobs.clear();
        this.spawnControlledNetherMobs.clear();
        this.spawnControlledEndMobs.clear();
        ConfigurationSection ow = this.getSectionWithFallback("spawn-control.worlds.overworld.controlled-mobs", "spawn-control.worlds.world.controlled-mobs");
        this.spawnControlledOverworldMobs.putAll(this.parseControlledMobRanges(ow));
        ConfigurationSection ne = this.getConfig().getConfigurationSection("spawn-control.worlds.nether.controlled-mobs");
        this.spawnControlledNetherMobs.putAll(this.parseControlledMobRanges(ne));
        ConfigurationSection en = this.getConfig().getConfigurationSection("spawn-control.worlds.end.controlled-mobs");
        this.spawnControlledEndMobs.putAll(this.parseControlledMobRanges(en));
        this.logDebug(() -> "Loaded spawn controlled-mobs: overworld=" + this.spawnControlledOverworldMobs.size() + " nether=" + this.spawnControlledNetherMobs.size() + " end=" + this.spawnControlledEndMobs.size());
    }

    private HeightRange getControlledRange(WorldKey worldKey, EntityType mobType) {
        if (worldKey == null || mobType == null) {
            return null;
        }
        return switch (worldKey.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.spawnControlledOverworldMobs.get(mobType);
            case 1 -> this.spawnControlledNetherMobs.get(mobType);
            case 2 -> this.spawnControlledEndMobs.get(mobType);
        };
    }

    private boolean isControlledMobOutOfRange(World world, WorldKey worldKey, EntityType mobType, int y) {
        HeightRange r = this.getControlledRange(worldKey, mobType);
        if (r == null) {
            return false;
        }
        return !r.contains(world, y);
    }

    private static enum WorldKey {
        WORLD,
        NETHER,
        END;

    }

    private static class DropEntry {
        private final Material material;
        private final int min;
        private final int max;
        private final double chance;

        private DropEntry(Material material, int min, int max, double chance) {
            this.material = material;
            this.min = min;
            this.max = max;
            this.chance = chance;
        }
    }

    private static class MobDropRule {
        private final boolean replaceDefaultDrops;
        private final EnumSet<Material> removeDrops;
        private final List<DropEntry> addDrops;
        private final XpRule xpRule;

        private MobDropRule(boolean replaceDefaultDrops, EnumSet<Material> removeDrops, List<DropEntry> addDrops, XpRule xpRule) {
            this.replaceDefaultDrops = replaceDefaultDrops;
            this.removeDrops = removeDrops == null ? EnumSet.noneOf(Material.class) : removeDrops;
            this.addDrops = addDrops == null ? List.of() : addDrops;
            this.xpRule = xpRule;
        }
    }

    private static class XpRule {
        private final int min;
        private final int max;
        private final double chance;

        private XpRule(int min, int max, double chance) {
            this.min = min;
            this.max = max;
            this.chance = chance;
        }
    }

    private record HeightRange(int minY, int maxY) {
        boolean contains(World world, int y) {
            int min = this.minY;
            int max = this.maxY;
            if (world != null) {
                int worldMin = world.getMinHeight();
                int worldMax = world.getMaxHeight() - 1;
                if (min < worldMin) {
                    min = worldMin;
                }
                if (max > worldMax) {
                    max = worldMax;
                }
            }
            return y >= min && y <= max;
        }
    }
}

